import ajustador as aju

def params_fitness(morph_file,ntype,modeltype,ghkkluge=1):

    P = aju.optimize.AjuParam
    params = aju.optimize.ParamSet(
        P('junction_potential', -5.45e-3, min=-20e-3, max = 20e-3),
        P('RA',                 1.81,  min=.4,      max=4),
        P('RM',                3.2,   min=0.01,      max=100),
        P('CM',                 0.0084, min=0.0025,      max=0.05),
        P('Cond_Kir',      4.85,      min=1, max=50),
        P('Eleak', -0.07, min=-0.1, max=-0.020),
        P('Cond_NaF_0',      1200e3,      min=20e3, max=10000e3),
        P('Cond_NaF_1',      3800,      min=0, max=100e3),
        P('Cond_NaF_2',      1000,      min=0, max=100e3),
        P('Cond_KaS_0',      51.6,        min=1, max=10000),
        P('Cond_KaS_1',      821,        min=1, max=10000),
        P('Cond_KaS_2',      20,        min=1, max=10000),
        P('Cond_KaF_0',      120,        min=10, max=10000),
        P('Cond_KaF_1',      903,        min=10, max=10000),
        P('Cond_KaF_2',      42,        min=10, max=10000),
        P('Cond_Krp',      0.06,        min=0, max=100),
        #P('Cond_Krp_1',      0.05,        min=0, max=50),
        #P('Cond_Krp_2',      0.05,        min=0, max=50),
        P('Cond_SKCa', 0.7, min=0, max=10),
        P('Cond_CaCC', 4, min=.1, max=100),
        P('Cond_BKCa', 5, min=1, max=100),
        P('Cond_CaN_0',      3*ghkkluge,      min=0, max=10*ghkkluge),
        P('Cond_CaT_1',      0.01*ghkkluge,      min=0, max=10*ghkkluge),
        P('Cond_CaT_2',      0.06*ghkkluge,      min=0, max=10*ghkkluge),
        P('Cond_CaL12_0',    1.8*ghkkluge,      min=0, max=20*ghkkluge),
        P('Cond_CaL12_1',    2.8*ghkkluge,      min=0, max=20*ghkkluge),
        P('Cond_CaL12_2',    2.5*ghkkluge,      min=0, max=20*ghkkluge),
        P('Cond_CaL13_0',   5.5*ghkkluge,      min=0, max=20*ghkkluge),
        P('Cond_CaL13_1',    0.015*ghkkluge,      min=0, max=20*ghkkluge),
        P('Cond_CaL13_2',    0.62*ghkkluge,      min=0, max=20*ghkkluge),
        P('Cond_CaR_0',     5*ghkkluge,      min=0, max=60*ghkkluge),
        P('Cond_CaR_1',     10*ghkkluge,      min=0, max=60*ghkkluge),
        P('Cond_CaR_2',     20*ghkkluge,      min=0, max=60*ghkkluge),
        P('Chan_NaF_vshift_X', 0.0112, min=-0.02, max=0.02),
        P('Chan_NaF_vshift_Y', 0.009, min=-0.02, max=0.02),
        P('Chan_NaF_taumul_X', 1.88, min=0.25, max=3),
        P('Chan_NaF_taumul_Y', 1.73, min=0.25, max=3),
        P('Chan_KaF_vshift_X', -0.013, min=-0.02, max=0.02),
        P('Chan_KaF_vshift_Y', 0.0046, min=-0.02, max=0.02),
        P('Chan_KaF_taumul_X', 1.65, min=0.25, max=3),
        P('Chan_KaF_taumul_Y', .5, min=0.25, max=3),
        P('Chan_KaS_vshift_X', -0.008, min=-0.020, max=0.020),
        P('Chan_KaS_vshift_Y', 0.006, min=-0.020, max=0.020),
        P('Chan_KaS_taumul_X', 2.99, min=0.25, max=4),
        P('Chan_KaS_taumul_Y', .57, min=0.25, max=3),
        #P('Chan_Krp_vshift', -0.004, min=-0.01, max=0.01),
        #P('Chan_Krp_taumul', 1.2, min=0.5, max=2),
        P('Chan_Kir_vshift', 0.02, min = -.02, max = .03),
        P('Chan_Kir_taumul', 2.3, min = .25, max = 3),
        P('morph_file', morph_file, fixed=1),
        P('neuron_type', ntype,                     fixed=1),
        P('model',           modeltype,     fixed=1))

    #fitness=aju.fitnesses.combined_fitness('new_combined_fitness')
    fitness = aju.fitnesses.combined_fitness('empty',
                                             response=2,
                                             baseline_pre=1,
                                             baseline_post=1,
                                             rectification=1,
                                             falling_curve_time=1,
                                             spike_time=2,
                                             spike_width=2,
                                             spike_height=10,
                                             spike_latency=1,
                                             spike_count=1,
                                             spike_ahp=2,
                                             ahp_curve=2,
                                             charging_curve_time=2,
                                             charging_curve_full=5,
                                             spike_range_y_histogram=1,
                                             mean_isi=2,
                                             isi_spread=2,
                                             spike_threshold=1,
                                             #response_variance=0.05,
                                             post_injection_curve_tau = 2)

    return params,fitness
