TITLE Mod file for component: Component(id=generated_model__slow_delayed_rectifier_potassium_current_0 type=generated_model__slow_delayed_rectifier_potassium_current)

COMMENT

    This NEURON file has been generated by org.neuroml.export (see https://github.com/NeuroML/org.neuroml.export)
         org.neuroml.export  v1.4.6
         org.neuroml.model   v1.4.6
         jLEMS               v0.9.8.6

ENDCOMMENT

NEURON {
    SUFFIX Ksdr :generated_model__slow_delayed_rectifier_potassium_current_0
    USEION k READ ek WRITE ik 
    
    RANGE g_Ks                              : parameter
    : RANGE V                                 : parameter
    : RANGE time_                             : parameter
    : RANGE E_K                               : parameter
    : RANGE tscale                            : parameter
    
    RANGE alpha_n                           : exposure
    
    RANGE ik                              : exposure
    
    RANGE beta_n                            : exposure
    
}

UNITS {
    
    (nA) = (nanoamp)
    (uA) = (microamp)
    (mA) = (milliamp)
    (A) = (amp)
    (mV) = (millivolt)
    (mS) = (millisiemens)
    (uS) = (microsiemens)
    (molar) = (1/liter)
    (kHz) = (kilohertz)
    (mM) = (millimolar)
    (um) = (micrometer)
    (umol) = (micromole)
    (S) = (siemens)
    
}

PARAMETER {
    
    g_Ks = 0.00000575 (mho/cm2) 
    v (mV)
    :time_ = NaN 
    ek (mV)
    tscale = 0.001 (kHz)
}

ASSIGNED {
    
    alpha_n (1)                                : derived variable
    
    ik  (mA/cm2)                                  : derived variable
    
    beta_n (1)                                : derived variable
    rate_nKs (/ms)
    
}

STATE {
    nKs  (1)
    
}

INITIAL {
    rates(v)
    rates(v) ? To ensure correct initialisation.
    
    nKs = 2.62753E-4
    
}

BREAKPOINT {
    
    SOLVE states METHOD cnexp
    ik = ((  g_Ks   * (  nKs^2)) * (  v   -   ek  )) ? evaluable
}

DERIVATIVE states {
    rates(v)
    nKs' = rate_nKs 
    
}

PROCEDURE rates(v (mV)) {
    
    alpha_n = (4.81333E-6 (/mV) * ((  v   + 26.5 (mV)) / (1.0 - exp((- 0.128 (/mV) * (  v   + 26.5 (mV))))))) ? evaluable
    beta_n = (9.53333E-5 * exp(((- 0.038 (/mV)) * (  v   + 26.5 (mV))))) ? evaluable
    rate_nKs = tscale  * (((  alpha_n   * (1.0 -   nKs  )) - (  beta_n   *   nKs  ))) ? Note units of all quantities used here need to be consistent!
    
     
    
}

