TITLE Mod file for component: Component(id=generated_model__time_independent_potassium_current_0 type=generated_model__time_independent_potassium_current)

COMMENT

    This NEURON file has been generated by org.neuroml.export (see https://github.com/NeuroML/org.neuroml.export)
         org.neuroml.export  v1.4.6
         org.neuroml.model   v1.4.6
         jLEMS               v0.9.8.6

ENDCOMMENT

NEURON {
    SUFFIX Kti :generated_model__time_independent_potassium_current_0
    USEION k READ ek WRITE ik 
    
    RANGE K1_leak_p                         : parameter
    RANGE K1_slope                          : parameter
    RANGE g                              : parameter
    RANGE K1_KIR_p                          : parameter
    : RANGE V                                 : parameter
    : RANGE E_K                               : parameter
    : RANGE Ko                                : parameter
    : RANGE tscale                            : parameter
    
    RANGE ik                              : exposure
    
    RANGE K1_KIR_O                          : exposure
    
    RANGE K1_leak_O                         : exposure
    
}

UNITS {
    
    (nA) = (nanoamp)
    (uA) = (microamp)
    (mA) = (milliamp)
    (A) = (amp)
    (mV) = (millivolt)
    (mS) = (millisiemens)
    (uS) = (microsiemens)
    (kHz) = (kilohertz)
    (um) = (micrometer)
    (umol) = (micromole)
    (S) = (siemens)
    
}

PARAMETER {
    
    K1_leak_p = 0.5 (1)
    K1_slope = 11.16 (mV)
    g = 0.0002647 (mho/cm2) 
    K1_KIR_p = 0.5 (1)
    v (mV) 
    ek (mV) 
    tscale = 0.001 (kHz)
}

ASSIGNED {
    
    ik (mA/cm2)                                 : derived variable
    
    K1_KIR_O   (mV)                            : derived variable
    
    K1_leak_O     (mV)                         : derived variable
    
}

INITIAL {
    rates(v)
    rates(v) ? To ensure correct initialisation.
    
}

BREAKPOINT {
    
    rates(v)
    ik = (  g   * (  K1_leak_O  +   K1_KIR_O  )) ? evaluable
    :ik = (  g   * (  K1_leak_O )):  +   K1_KIR_O  )) ? evaluable
    : ik = (  g   * (  K1_KIR_O )):  +   K1_KIR_O  )) ? evaluable
    
}

PROCEDURE rates(v (mV)) {
    
    
    K1_KIR_O = ((  K1_KIR_p    * (  v   -   ek  )) / (1.0 + exp((  v   -   ek  ) /   K1_slope  ))) ? evaluable
    K1_leak_O = (  K1_leak_p   * (  v   -   ek  )) ? evaluable
    
     
    
}

