TITLE Mod file for component: Component(id=generated_model__rapid_delayed_rectifier_potassium_current_0 type=generated_model__rapid_delayed_rectifier_potassium_current)

COMMENT

    This NEURON file has been generated by org.neuroml.export (see https://github.com/NeuroML/org.neuroml.export)
         org.neuroml.export  v1.4.6
         org.neuroml.model   v1.4.6
         jLEMS               v0.9.8.6

ENDCOMMENT

NEURON {
    SUFFIX Krdr : generated_model__rapid_delayed_rectifier_potassium_current_0
    USEION k READ ki, ko WRITE ik 
    USEION na READ nai, nao
    
    RANGE kb                                : parameter
    RANGE kf                                : parameter
    RANGE g_Kr                              : parameter
    : RANGE V                                 : parameter
    : RANGE time_                             : parameter
    : RANGE Ki                                : parameter
    : RANGE Nai                               : parameter
    : RANGE R                                 : parameter
    : RANGE T                                 : parameter
    : RANGE Ko                                : parameter
    : RANGE F                                 : parameter
    : RANGE Nao                               : parameter
    : RANGE tscale                            : parameter
    
    RANGE ik                              : exposure
    
    RANGE C_K0                              : exposure
    
    RANGE alpha_a0                          : exposure
    
    RANGE beta_a1                           : exposure
    
    RANGE beta_a0                           : exposure
    
    RANGE rapid_delayed_rectifier_potassium_current_beta_i : exposure
    
    RANGE alpha_a1                          : exposure
    
    RANGE rapid_delayed_rectifier_potassium_current_alpha_i : exposure
    
}

UNITS {
    
    (nA) = (nanoamp)
    (uA) = (microamp)
    (mA) = (milliamp)
    (A) = (amp)
    (mV) = (millivolt)
    (mS) = (millisiemens)
    (uS) = (microsiemens)
    (molar) = (1/liter)
    (kHz) = (kilohertz)
    (mM) = (millimolar)
    (um) = (micrometer)
    (umol) = (micromole)
    (S) = (siemens)
    F       = (faraday) (kilocoulombs)
    :F      = (faraday) (coulomb)
    R       = (k-mole) (joule/degC)
    
}

PARAMETER {
    
    kb = 0.036778 (1)
    kf = 0.023761 (1)
    g_Kr = 0.000234 (mho/cm2)
    v (mV)
    : time_ = NaN 
    ki (mM)
    nai (mM) 
    : R = NaN 
    : T = NaN 
    ko (mM)
    : F = NaN 
    nao (mM)
    tscale = 0.001 (kHz)
    celsius (degC)
}

ASSIGNED {
    
    ik (mA/cm2)
    
    C_K0                                   : derived variable
    
    alpha_a0  (1)                             : derived variable
    
    beta_a1   (1)                             : derived variable
    
    beta_a0   (1)                            : derived variable
    
    rapid_delayed_rectifier_potassium_current_beta_i (1) : derived variable
    
    alpha_a1 (1)                               : derived variable
    
    rapid_delayed_rectifier_potassium_current_alpha_i (1) : derived variable
    rate_I_K (/ms)
    rate_C_K2 (/ms)
    rate_C_K1 (/ms)
    rate_O_K (/ms)
    
    T (degC)
}

STATE {
    I_K  (1)
    C_K2  (1)
    C_K1  (1)
    O_K  (1)
    
}

INITIAL {
    T = 273 + celsius
    
    rates(v)
    rates(v) ? To ensure correct initialisation.
    
    I_K = 3.19129E-5
    
    C_K2 = 6.41229E-4
    
    C_K1 = 9.92513E-4
    
    O_K = 1.75298E-4
    
}

BREAKPOINT {
    
    SOLVE states METHOD cnexp
    ik = ((  g_Kr   *   O_K  ) * (  v  - ((  R   * (  T   /   F  )) * log((((0.98 *   ko  ) + (0.02 *   nao  )) / ((0.98 *   ki  ) + (0.02 *   nai  ))))))) ? evaluable
    
    
}

DERIVATIVE states {
    rates(v)
    I_K' = rate_I_K 
    C_K2' = rate_C_K2 
    C_K1' = rate_C_K1 
    O_K' = rate_O_K 
    
}

PROCEDURE rates(v (mV)) {
    
    
    C_K0 = (1.0 - (((  C_K1   +   C_K2  ) +   O_K  ) +   I_K  )) ? evaluable
    
    alpha_a0 = (0.022348 * exp((0.01176 (/mV) *   v  ))) ? evaluable
    
    beta_a1 = (6.89E-5 * exp(( - 0.04178 (/mV) *   v  ))) ? evaluable
    
    beta_a0 = (0.047002 * exp((- 0.0631 (/mV) *   v  ))) ? evaluable
    
    rapid_delayed_rectifier_potassium_current_beta_i = (0.006497 * exp(( - 0.03268 (/mV) * (  v   + 5.0 (mV))))) ? evaluable
    
    alpha_a1 = (0.013733 * exp((0.038198 (/mV) *   v  ))) ? evaluable
    
    rapid_delayed_rectifier_potassium_current_alpha_i = (0.090821 * exp((0.023391 (/mV)* (  v   + 5.0 (mV))))) ? evaluable
    
    rate_C_K2 = tscale  * (((  kf   *   C_K1  ) + ((  beta_a1   *   O_K  ) - ((  kb   *   C_K2  ) + (  alpha_a1   *   C_K2  ))))) ? Note units of all quantities used here need to be consistent!
    
    rate_C_K1 = tscale  * (((  alpha_a0   *   C_K0  ) + ((  kb   *   C_K2  ) - ((  beta_a0   *   C_K1  ) + (  kf   *   C_K1  ))))) ? Note units of all quantities used here need to be consistent!
    
    rate_I_K = tscale  * (((  rapid_delayed_rectifier_potassium_current_alpha_i   *   O_K  ) - (  rapid_delayed_rectifier_potassium_current_beta_i   *   I_K  ))) ? Note units of all quantities used here need to be consistent!
    
    rate_O_K = tscale  * (((  alpha_a1   *   C_K2  ) + ((  rapid_delayed_rectifier_potassium_current_beta_i   *   I_K  ) - ((  beta_a1   *   O_K  ) + (  rapid_delayed_rectifier_potassium_current_alpha_i   *   O_K  ))))) ? Note units of all quantities used here need to be consistent!
    
     
    
}

