TITLE Mod file for component: Component(id=generated_model__fast_transient_outward_potassium_current_0 type=generated_model__fast_transient_outward_potassium_current)

COMMENT

    This NEURON file has been generated by org.neuroml.export (see https://github.com/NeuroML/org.neuroml.export)
         org.neuroml.export  v1.4.6
         org.neuroml.model   v1.4.6
         jLEMS               v0.9.8.6

ENDCOMMENT

NEURON {
    SUFFIX Kto_f :generated_model__fast_transient_outward_potassium_current_0
    USEION k READ ki, ko WRITE ik 

    RANGE g_Kto_f                           : parameter
    :RANGE time_                             : parameter
    :RANGE V                                 : parameter
    :RANGE T                                 : parameter
    :RANGE F                                 : parameter
    RANGE ko                                : parameter
    RANGE ki                                : parameter
    :RANGE R                                 : parameter
    :RANGE tscale                            : parameter
    
    RANGE beta_a                            : exposure
    
    RANGE alpha_a                           : exposure
    
    RANGE fast_transient_outward_potassium_current_alpha_i : exposure
    
    RANGE ik                           : exposure
    
    :RANGE E_K                               : exposure
    
    RANGE fast_transient_outward_potassium_current_beta_i : exposure
    
}

UNITS {
    
    (nA) = (nanoamp)
    (uA) = (microamp)
    (mA) = (milliamp)
    (A) = (amp)
    (mV) = (millivolt)
    (mS) = (millisiemens)
    (uS) = (microsiemens)
    (molar) = (1/liter)
    (kHz) = (kilohertz)
    (mM) = (millimolar)
    (um) = (micrometer)
    (umol) = (micromole)
    (S) = (siemens)
    F       = (faraday) (kilocoulombs)
    :F      = (faraday) (coulomb)
    R       = (k-mole) (joule/degC)
    
}

PARAMETER {
    
    g_Kto_f = 0.0004067 (mho/cm2)
    :time_ = NaN 
    v (mV)
    ko (mM)
    ki (mM)
    celsius (degC)
    :F = 9.64853399e4 (f) : Faraday constant C / mol
    :R = 8.314472 (J/deg/mol): Universal gas constant in J/ (K * mol)
    :tscale = 0.001 (kHz)
}

ASSIGNED {
    
    T (degC)
    
    beta_a (/ms)                                : derived variable
    
    alpha_a (/ms)                               : derived variable
    
    fast_transient_outward_potassium_current_alpha_i (/ms) : derived variable
    
    ik (mA/cm2)                                : derived variable
    
    E_K (mV)                                   : derived variable
    
    fast_transient_outward_potassium_current_beta_i (/ms) : derived variable
    rate_ato_f (/ms)
    rate_ito_f (/ms)
    
}

STATE {
    ato_f  (1)
    ito_f  (1)
    
}

INITIAL {
    
    T = 273 + celsius

    rates(v)
    rates(v) ? To ensure correct initialisation.
    
    ato_f = 0.00265563
    
    ito_f = 0.999977
    
}

BREAKPOINT {
    
    SOLVE states METHOD cnexp
    ik = (((  g_Kto_f   * (  ato_f   ^ 3)) *   ito_f  ) * (  v   -   E_K  )) ? evaluable
    
    
}

DERIVATIVE states {
    rates(v)
    ato_f' = (((  alpha_a   * (1.0 -   ato_f  )) - (  beta_a   *   ato_f  ))) 
    ito_f' = (((  fast_transient_outward_potassium_current_alpha_i   * (1.0 -   ito_f  )) - (  fast_transient_outward_potassium_current_beta_i   *   ito_f  ))) 
    
}

PROCEDURE rates(v (mV)) {
    
    beta_a = (0.3956 (/ms) * exp(((- 0.06237(/mV)) * (  v   + 30.0(mV))))) ? evaluable
    alpha_a = (0.18064 (/ms) * exp((0.03577 (/mV)* (  v   + 30.0  (mV))))) ? evaluable
    fast_transient_outward_potassium_current_alpha_i = (1.52E-4 (/ms)* (exp((( - (  v   + 13.5 (mV))) / 7.0 (mV))) / ((0.0067083 * exp(((- (  v   + 33.5 (mV))) / 7.0 (mV)))) + 1.0))) ? evaluable
    E_K = ((  R   * (  T   /   F  )) * log((  ko   /   ki  ))) ? evaluable
    fast_transient_outward_potassium_current_beta_i = (9.5E-4 (/ms) * (exp(((  v   + 33.5 (mV)) / 7.0(mV))) / ((0.051335 * exp(((  v   + 33.5 (mV)) / 7.0 (mV)))) + 1.0))) ? evaluable
    :rate_ito_f = tscale  * (((  fast_transient_outward_potassium_current_alpha_i   * (1.0 -   ito_f  )) - (  fast_transient_outward_potassium_current_beta_i   *   ito_f  ))) ? Note units of all quantities used here need to be consistent!
    :rate_ato_f = tscale  * (((  alpha_a   * (1.0 -   ato_f  )) - (  beta_a   *   ato_f  ))) ? Note units of all quantities used here need to be consistent!
    
     
    
}

