
function xdot=cav_2states_model_scale(t,x,flag,tv,V_in)


% 2-state ODE model for CaV (Eqs. 13-14)

global  V_0 k_minus k_plus beta1  alpha1 beta1_0 alpha1_0 rho

c=x(1);

o=x(2);

b=1-o-c;


if isempty(tv)
    V=V_0;
else
    
    if length(tv)==1
        if t<tv
            V=V_0;       
        else
            V=V_in;
        end    
    else
        if t<tv(1)
            V=V_0;
        elseif t>tv(end)
            V=V_in(end);
        else
            k=1;
            t_found=false;
            while not(t_found)
                if t>=tv(k) && t<=tv(k+1)
                    t_found=true;
                    V=V_in(k);
                end
                k=k+1;
            end
        end
    end
end

% CaV parameters

alpha=alpha1_0*exp(-alpha1*V);
beta=beta1_0*exp(-beta1*V);
beta_scale=(beta+alpha)*rho;

%%% compute calcium level at 7nm of the pore (cav sensor) and at 13nm (bk sensor)
D_ca=250; %microm^2 s^-1
F=9.6485*10^4; %C mol^-1
conv_F=10^(-15);  % mol a M/microm^3
conv_microM=10^6; % M to microM
r_bk=13*10^(-3);% microm
r_ca=7*10^(-3); %microm
k_B=500; %microM^-1 * s^-1
B_tot=30; %microM
Eca=60; %mV
conv_V=10^(-3); %mV to V
g_ca=2.8; %pS 
conv_S=10^(-12); %pS to S
i_ca=abs((V-Eca))*conv_V*g_ca*conv_S; % C/sec

ca_o_rca=i_ca/(8*pi*D_ca*F*conv_F*r_ca)*exp(-r_ca/(sqrt(D_ca/k_B/B_tot)))*conv_microM;
ca_o=i_ca/(8*pi*D_ca*F*conv_F*r_bk)*exp(-r_bk/(sqrt(D_ca/k_B/B_tot)))*conv_microM;
% ca_o= -6/20*V+19;


dot_c=-alpha*c + beta_scale*o;
dot_o=alpha*c - beta_scale*o+k_minus*b - k_plus*ca_o_rca*o;

%dot_b= -k_minus*b + k_plus*ca_o_rca*o;

xdot=[dot_c;dot_o];