# TwoCompartmentModel

This repository includes simulation code used in 

Title: Soma-axon coupling configurations that enhance neuronal coincidence detection

Authors: Joshua H Goldwyn, Michiel WH Remme, John Rinzel

Manuscript available at: https://journals.plos.org/ploscompbiol/article/authors?id=10.1371/journal.pcbi.1006476 

Manuscript accepted for publication in: PLoS Computational Biology

The authors make the following code available for scientific research and educational purposes:

**** MATLAB CODE ****

EasyRun.m
This is a "starter" program that lets the user set model parameters and run the two-compartment model.
Note: Simulating responses to auditory nerve inputs requires installation of the Zilany,Bruce, Carney model. See below.  

getParam.m
User enters coupling coefficients and KLT fractions, and code returns parameters for the two-compartment model

passiveParamFig.m
Run this to reproduce Figure 2

*  ResponseToAN.m
Simulate responses to synaptic inputs generated by Zilany et al Auditory Nerve model
Run this to reproduce Figure 4

ResponseToStep.m
Simulate responses to a "step" of constant current.
Run this to reproduce Figure 7A-D 

ResponseToRamp.m
Simulate responses to a "ramp" of current.
Run this to reproduce Figure 8A-D

ResponseToEPSGpair.m
Simulate responses to a sequence of two EPSGs with possible time delay between the EPSG events.
Run this to reproduce Figure 10A-D

TwoCptODE.m
System of ordinary differential equations that define the dynamics of the two-compartment model in response to current input.

* TwoCptANode.m
System of ordinary differential equations that define the dynamics of the two-compartment model in response to synaptic inputs. This script is called by the function TwoCptAN_func.m

* CarneyModel.m
Generates auditory nerve spike trains that can be used as inputs to the two-compartment model.  This script is called by the function TwoCptAN_func.m

* TwoCptAN_func.m
Simulates response of two-compartment model to AN spike trains.  This function is called by ResponseToAN.m




* Programs marked with asterisk require the Zilany,Bruce, Carney "updated" Auditory Nerve model (2014).  
Code for this model is available at https://www.urmc.rochester.edu/labs/carney/publications/auditory-models.aspx
Using the AN model requires that the Zilany et al code by mex-compiled, and placed in a path to which MATLAB has access.
