/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy;

import java.util.Collection;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.partition.list.PartitionMutableList;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.AbstractRichIterable;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.factory.Procedures2;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.PartitionProcedure;
import org.eclipse.collections.impl.lazy.primitive.CollectBooleanIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectByteIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectCharIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectDoubleIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectFloatIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectIntIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectLongIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectShortIterable;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.list.FastListMultimap;
import org.eclipse.collections.impl.partition.list.PartitionFastList;
import org.eclipse.collections.impl.stack.mutable.ArrayStack;
import org.eclipse.collections.impl.utility.LazyIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public abstract class AbstractLazyIterable<T>
extends AbstractRichIterable<T>
implements LazyIterable<T> {
    @Override
    public LazyIterable<T> asLazy() {
        return this;
    }

    @Override
    public <R extends Collection<T>> R into(R target) {
        this.forEachWith(Procedures2.addToCollection(), target);
        return target;
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.toList().toArray(array);
    }

    @Override
    public int size() {
        return this.count(Predicates.alwaysTrue());
    }

    @Override
    public boolean isEmpty() {
        return !this.anySatisfy(Predicates.alwaysTrue());
    }

    @Override
    public T getFirst() {
        return (T)this.detect(Predicates.alwaysTrue());
    }

    @Override
    public T getLast() {
        final Object[] result = new Object[1];
        this.forEach(new Procedure<T>(){

            @Override
            public void value(T each2) {
                result[0] = each2;
            }
        });
        return (T)result[0];
    }

    @Override
    public LazyIterable<T> select(Predicate<? super T> predicate) {
        return LazyIterate.select(this, predicate);
    }

    @Override
    public <P> LazyIterable<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return LazyIterate.select(this, Predicates.bind(predicate, parameter));
    }

    @Override
    public LazyIterable<T> reject(Predicate<? super T> predicate) {
        return LazyIterate.reject(this, predicate);
    }

    @Override
    public <P> LazyIterable<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return LazyIterate.reject(this, Predicates.bind(predicate, parameter));
    }

    @Override
    public PartitionMutableList<T> partition(Predicate<? super T> predicate) {
        PartitionFastList partitionMutableList = new PartitionFastList();
        this.forEach(new PartitionProcedure<T>(predicate, partitionMutableList));
        return partitionMutableList;
    }

    @Override
    public <P> PartitionMutableList<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.partition((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public <S> LazyIterable<S> selectInstancesOf(Class<S> clazz) {
        return LazyIterate.selectInstancesOf(this, clazz);
    }

    @Override
    public <V> LazyIterable<V> collect(Function<? super T, ? extends V> function) {
        return LazyIterate.collect(this, function);
    }

    @Override
    public LazyBooleanIterable collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return new CollectBooleanIterable<T>(this, booleanFunction);
    }

    @Override
    public LazyByteIterable collectByte(ByteFunction<? super T> byteFunction) {
        return new CollectByteIterable<T>(this, byteFunction);
    }

    @Override
    public LazyCharIterable collectChar(CharFunction<? super T> charFunction) {
        return new CollectCharIterable<T>(this, charFunction);
    }

    @Override
    public LazyDoubleIterable collectDouble(DoubleFunction<? super T> doubleFunction) {
        return new CollectDoubleIterable<T>(this, doubleFunction);
    }

    @Override
    public LazyFloatIterable collectFloat(FloatFunction<? super T> floatFunction) {
        return new CollectFloatIterable<T>(this, floatFunction);
    }

    @Override
    public LazyIntIterable collectInt(IntFunction<? super T> intFunction) {
        return new CollectIntIterable<T>(this, intFunction);
    }

    @Override
    public LazyLongIterable collectLong(LongFunction<? super T> longFunction) {
        return new CollectLongIterable<T>(this, longFunction);
    }

    @Override
    public LazyShortIterable collectShort(ShortFunction<? super T> shortFunction) {
        return new CollectShortIterable<T>(this, shortFunction);
    }

    @Override
    public <P, V> LazyIterable<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return LazyIterate.collect(this, Functions.bind(function, parameter));
    }

    @Override
    public <V> LazyIterable<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return LazyIterate.flatCollect(this, function);
    }

    @Override
    public LazyIterable<T> concatenate(Iterable<T> iterable) {
        return LazyIterate.concatenate(this, iterable);
    }

    @Override
    public <V> LazyIterable<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return LazyIterate.collectIf(this, predicate, function);
    }

    @Override
    public LazyIterable<T> take(int count2) {
        return LazyIterate.take(this, count2);
    }

    @Override
    public LazyIterable<T> drop(int count2) {
        return LazyIterate.drop(this, count2);
    }

    @Override
    public LazyIterable<T> distinct() {
        return LazyIterate.distinct(this);
    }

    public MutableStack<T> toStack() {
        return ArrayStack.newStack(this);
    }

    @Override
    public <V> Multimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.groupBy(function, FastListMultimap.newMultimap());
    }

    @Override
    public <V> Multimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.groupByEach(function, FastListMultimap.newMultimap());
    }

    @Override
    public <V> MapIterable<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.groupByUniqueKey(function, UnifiedMap.newMap());
    }

    @Override
    public <S> LazyIterable<Pair<T, S>> zip(Iterable<S> that) {
        return LazyIterate.zip(this, that);
    }

    @Override
    public LazyIterable<Pair<T, Integer>> zipWithIndex() {
        return LazyIterate.zipWithIndex(this);
    }

    @Override
    public LazyIterable<RichIterable<T>> chunk(int size2) {
        return LazyIterate.chunk(this, size2);
    }

    @Override
    public LazyIterable<T> tap(Procedure<? super T> procedure) {
        return LazyIterate.tap(this, procedure);
    }

    @Override
    public <K, V> MapIterable<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        UnifiedMap map2 = UnifiedMap.newMap();
        this.forEach(new MutatingAggregationProcedure<T, K, V>(map2, groupBy, zeroValueFactory, mutatingAggregator));
        return map2;
    }

    @Override
    public <K, V> MapIterable<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        UnifiedMap map2 = UnifiedMap.newMap();
        this.forEach(new NonMutatingAggregationProcedure<T, K, V>(map2, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map2;
    }
}

