/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel.list;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterable;
import org.eclipse.collections.impl.lazy.parallel.OrderedBatch;
import org.eclipse.collections.impl.lazy.parallel.list.AbstractParallelListIterable;
import org.eclipse.collections.impl.lazy.parallel.list.ListBatch;
import org.eclipse.collections.impl.utility.Iterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class ParallelFlatCollectListIterable<T, V>
extends AbstractParallelListIterable<V, ListBatch<V>> {
    private final AbstractParallelIterable<T, ? extends OrderedBatch<T>> parallelIterable;
    private final Function<? super T, ? extends Iterable<V>> function;

    public ParallelFlatCollectListIterable(AbstractParallelIterable<T, ? extends OrderedBatch<T>> parallelIterable, Function<? super T, ? extends Iterable<V>> function) {
        this.parallelIterable = parallelIterable;
        this.function = function;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.parallelIterable.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.parallelIterable.getBatchSize();
    }

    @Override
    public LazyIterable<ListBatch<V>> split() {
        return this.parallelIterable.split().collect(new Function<OrderedBatch<T>, ListBatch<V>>(){

            @Override
            public ListBatch<V> valueOf(OrderedBatch<T> batch) {
                return batch.flatCollect(ParallelFlatCollectListIterable.this.function);
            }
        });
    }

    @Override
    public void forEach(final Procedure<? super V> procedure) {
        this.parallelIterable.forEach(new Procedure<T>(){

            @Override
            public void value(T each2) {
                Iterate.forEach((Iterable)ParallelFlatCollectListIterable.this.function.valueOf(each2), procedure);
            }
        });
    }

    @Override
    public V detect(final Predicate<? super V> predicate) {
        final AtomicReference result = new AtomicReference();
        this.parallelIterable.anySatisfy(new Predicate<T>(){

            @Override
            public boolean accept(T each2) {
                return Iterate.anySatisfy((Iterable)ParallelFlatCollectListIterable.this.function.valueOf(each2), new Predicate<V>(){

                    @Override
                    public boolean accept(V each2) {
                        if (predicate.accept(each2)) {
                            result.compareAndSet(null, each2);
                            return true;
                        }
                        return false;
                    }
                });
            }
        });
        return result.get();
    }

    @Override
    public boolean anySatisfy(final Predicate<? super V> predicate) {
        return this.parallelIterable.anySatisfy(new Predicate<T>(){

            @Override
            public boolean accept(T each2) {
                return Iterate.anySatisfy((Iterable)ParallelFlatCollectListIterable.this.function.valueOf(each2), predicate);
            }
        });
    }

    @Override
    public boolean allSatisfy(final Predicate<? super V> predicate) {
        return this.parallelIterable.allSatisfy(new Predicate<T>(){

            @Override
            public boolean accept(T each2) {
                return Iterate.allSatisfy((Iterable)ParallelFlatCollectListIterable.this.function.valueOf(each2), predicate);
            }
        });
    }
}

