/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel.set;

import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.IfProcedure;
import org.eclipse.collections.impl.lazy.parallel.set.AbstractParallelUnsortedSetIterable;
import org.eclipse.collections.impl.lazy.parallel.set.UnsortedSetBatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
class ParallelSelectUnsortedSetIterable<T>
extends AbstractParallelUnsortedSetIterable<T, UnsortedSetBatch<T>> {
    private final AbstractParallelUnsortedSetIterable<T, ? extends UnsortedSetBatch<T>> delegate;
    private final Predicate<? super T> predicate;

    ParallelSelectUnsortedSetIterable(AbstractParallelUnsortedSetIterable<T, ? extends UnsortedSetBatch<T>> delegate, Predicate<? super T> predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.delegate.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.delegate.getBatchSize();
    }

    @Override
    public LazyIterable<UnsortedSetBatch<T>> split() {
        return this.delegate.split().collect(new Function<UnsortedSetBatch<T>, UnsortedSetBatch<T>>(){

            @Override
            public UnsortedSetBatch<T> valueOf(UnsortedSetBatch<T> eachBatch) {
                return eachBatch.select(ParallelSelectUnsortedSetIterable.this.predicate);
            }
        });
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        this.delegate.forEach(new IfProcedure<T>(this.predicate, procedure));
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return this.delegate.anySatisfy(Predicates.and(this.predicate, predicate));
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return this.delegate.allSatisfy(new SelectAllSatisfyPredicate(this.predicate, predicate));
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return this.delegate.detect(Predicates.and(this.predicate, predicate));
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toList().select(this.predicate).toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.delegate.toList().select(this.predicate).toArray(array);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SelectAllSatisfyPredicate<T>
    implements Predicate<T> {
        private final Predicate<? super T> left;
        private final Predicate<? super T> right;

        private SelectAllSatisfyPredicate(Predicate<? super T> left, Predicate<? super T> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean accept(T each2) {
            boolean leftResult = this.left.accept(each2);
            return !leftResult || this.right.accept(each2);
        }
    }
}

