/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortBytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.ImmutableShortByteMap;
import org.eclipse.collections.api.map.primitive.ShortByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.ShortBytePair;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ShortByteMaps;
import org.eclipse.collections.impl.factory.primitive.ShortLists;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.ShortByteHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableShortSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableShortByteSingletonMap
implements ImmutableShortByteMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_VALUE = 0;
    private final short key1;
    private final byte value1;

    ImmutableShortByteSingletonMap(short key1, byte value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    @Override
    public byte get(short key) {
        return this.getIfAbsent(key, (byte)0);
    }

    @Override
    public byte getIfAbsent(short key, byte ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    @Override
    public byte getOrThrow(short key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(short key) {
        return this.key1 == key;
    }

    @Override
    public boolean containsValue(byte value) {
        return this.value1 == value;
    }

    @Override
    public void forEachValue(ByteProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public void forEachKey(ShortProcedure procedure) {
        procedure.value(this.key1);
    }

    @Override
    public void forEachKeyValue(ShortByteProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    @Override
    public LazyShortIterable keysView() {
        return ShortLists.immutable.of(this.key1).asLazy();
    }

    @Override
    public RichIterable<ShortBytePair> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    @Override
    public ImmutableShortByteMap select(ShortBytePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? ShortByteHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new ShortByteHashMap().toImmutable();
    }

    @Override
    public ImmutableShortByteMap reject(ShortBytePredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new ShortByteHashMap().toImmutable() : ShortByteHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.value1);
    }

    @Override
    public ImmutableShortByteMap toImmutable() {
        return this;
    }

    @Override
    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator(ShortByteHashMap.newWithKeysValues(this.key1, this.value1).byteIterator());
    }

    @Override
    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ByteProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public int count(BytePredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    @Override
    public long sum() {
        return this.value1;
    }

    @Override
    public byte min() {
        return this.value1;
    }

    @Override
    public byte max() {
        return this.value1;
    }

    @Override
    public byte maxIfEmpty(byte defaultValue) {
        return this.value1;
    }

    @Override
    public byte minIfEmpty(byte defaultValue) {
        return this.value1;
    }

    @Override
    public double average() {
        return this.value1;
    }

    @Override
    public double median() {
        return this.value1;
    }

    @Override
    public byte[] toSortedArray() {
        return new byte[]{this.value1};
    }

    @Override
    public MutableByteList toSortedList() {
        return ByteArrayList.newListWith(this.value1);
    }

    @Override
    public boolean anySatisfy(BytePredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean allSatisfy(BytePredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean noneSatisfy(BytePredicate predicate) {
        return !predicate.accept(this.value1);
    }

    @Override
    public ImmutableByteCollection select(BytePredicate predicate) {
        return predicate.accept(this.value1) ? ByteArrayList.newListWith(this.value1).toImmutable() : new ByteArrayList().toImmutable();
    }

    @Override
    public ImmutableByteCollection reject(BytePredicate predicate) {
        return predicate.accept(this.value1) ? new ByteArrayList().toImmutable() : ByteArrayList.newListWith(this.value1).toImmutable();
    }

    @Override
    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    @Override
    public <V> ImmutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    @Override
    public byte[] toArray() {
        return new byte[]{this.value1};
    }

    @Override
    public boolean contains(byte value) {
        return this.value1 == value;
    }

    @Override
    public boolean containsAll(byte ... source) {
        for (byte value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator2 = source.byteIterator();
        while (iterator2.hasNext()) {
            if (this.value1 == iterator2.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableByteList toList() {
        return ByteArrayList.newListWith(this.value1);
    }

    @Override
    public MutableByteSet toSet() {
        return ByteHashSet.newSetWith(this.value1);
    }

    @Override
    public MutableByteBag toBag() {
        return ByteHashBag.newBagWith(this.value1);
    }

    @Override
    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter(this);
    }

    @Override
    public ImmutableShortByteMap newWithKeyValue(short key, byte value) {
        return ShortByteMaps.immutable.withAll(ShortByteHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    @Override
    public ImmutableShortByteMap newWithoutKey(short key) {
        return this.key1 == key ? ShortByteMaps.immutable.with() : this;
    }

    @Override
    public ImmutableShortByteMap newWithoutAllKeys(ShortIterable keys) {
        return keys.contains(this.key1) ? ShortByteMaps.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public MutableShortSet keySet() {
        return UnmodifiableShortSet.of(ShortHashSet.newSetWith(this.key1));
    }

    @Override
    public MutableByteCollection values() {
        return UnmodifiableByteCollection.of(ByteArrayList.newListWith(this.value1));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShortByteMap)) {
            return false;
        }
        ShortByteMap map2 = (ShortByteMap)obj;
        if (map2.size() != 1) {
            return false;
        }
        return map2.containsKey(this.key1) && this.value1 == map2.getOrThrow(this.key1);
    }

    @Override
    public int hashCode() {
        return this.key1 ^ this.value1;
    }

    @Override
    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

