/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.partition.set.PartitionMutableSet;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.SetIterable;
import org.eclipse.collections.api.set.UnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.collection.mutable.AbstractMultiReaderMutableCollection;
import org.eclipse.collections.impl.factory.Iterables;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.lazy.parallel.set.MultiReaderParallelUnsortedSetIterable;
import org.eclipse.collections.impl.set.mutable.SynchronizedMutableSet;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.UnmodifiableMutableSet;
import org.eclipse.collections.impl.utility.LazyIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiReaderUnifiedSet<T>
extends AbstractMultiReaderMutableCollection<T>
implements RandomAccess,
Externalizable,
MutableSet<T> {
    private static final long serialVersionUID = 1L;
    private transient ReadWriteLock lock;
    private MutableSet<T> delegate;

    @Deprecated
    public MultiReaderUnifiedSet() {
    }

    private MultiReaderUnifiedSet(MutableSet<T> newDelegate) {
        this(newDelegate, new ReentrantReadWriteLock());
    }

    private MultiReaderUnifiedSet(MutableSet<T> newDelegate, ReadWriteLock newLock) {
        this.lock = newLock;
        this.delegate = newDelegate;
    }

    public static <T> MultiReaderUnifiedSet<T> newSet() {
        return new MultiReaderUnifiedSet(UnifiedSet.newSet());
    }

    public static <T> MultiReaderUnifiedSet<T> newSet(int capacity) {
        return new MultiReaderUnifiedSet(UnifiedSet.newSet(capacity));
    }

    public static <T> MultiReaderUnifiedSet<T> newSet(Iterable<T> iterable) {
        return new MultiReaderUnifiedSet<T>(UnifiedSet.newSet(iterable));
    }

    public static <T> MultiReaderUnifiedSet<T> newSetWith(T ... elements) {
        return new MultiReaderUnifiedSet<T>(UnifiedSet.newSetWith(elements));
    }

    @Override
    protected MutableSet<T> getDelegate() {
        return this.delegate;
    }

    @Override
    protected ReadWriteLock getLock() {
        return this.lock;
    }

    UntouchableMutableSet<T> asReadUntouchable() {
        return new UntouchableMutableSet(this.delegate.asUnmodifiable());
    }

    UntouchableMutableSet<T> asWriteUntouchable() {
        return new UntouchableMutableSet(this.delegate);
    }

    public void withReadLockAndDelegate(Procedure<MutableSet<T>> procedure) {
        this.acquireReadLock();
        try {
            UntouchableMutableSet<T> untouchableSet = this.asReadUntouchable();
            procedure.value(untouchableSet);
            untouchableSet.becomeUseless();
        }
        finally {
            this.unlockReadLock();
        }
    }

    public void withWriteLockAndDelegate(Procedure<MutableSet<T>> procedure) {
        this.acquireWriteLock();
        try {
            UntouchableMutableSet<T> untouchableSet = this.asWriteUntouchable();
            procedure.value(untouchableSet);
            untouchableSet.becomeUseless();
        }
        finally {
            this.unlockWriteLock();
        }
    }

    @Override
    public MutableSet<T> asSynchronized() {
        this.acquireReadLock();
        try {
            SynchronizedMutableSet synchronizedMutableSet = SynchronizedMutableSet.of(this);
            return synchronizedMutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public ImmutableSet<T> toImmutable() {
        this.acquireReadLock();
        try {
            ImmutableSet<T> immutableSet = Sets.immutable.withAll(this.delegate);
            return immutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableSet<T> asUnmodifiable() {
        this.acquireReadLock();
        try {
            UnmodifiableMutableSet unmodifiableMutableSet = UnmodifiableMutableSet.of(this);
            return unmodifiableMutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableSet<T> clone() {
        this.acquireReadLock();
        try {
            MultiReaderUnifiedSet<T> multiReaderUnifiedSet = new MultiReaderUnifiedSet<T>(this.delegate.clone());
            return multiReaderUnifiedSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <V> MutableSet<V> collect(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            MutableSet<? extends V> mutableSet = this.delegate.collect(function);
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableBooleanSet collectBoolean(BooleanFunction<? super T> booleanFunction) {
        this.acquireReadLock();
        try {
            MutableBooleanSet mutableBooleanSet = this.delegate.collectBoolean(booleanFunction);
            return mutableBooleanSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableByteSet collectByte(ByteFunction<? super T> byteFunction) {
        this.acquireReadLock();
        try {
            MutableByteSet mutableByteSet = this.delegate.collectByte(byteFunction);
            return mutableByteSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableCharSet collectChar(CharFunction<? super T> charFunction) {
        this.acquireReadLock();
        try {
            MutableCharSet mutableCharSet = this.delegate.collectChar(charFunction);
            return mutableCharSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableDoubleSet collectDouble(DoubleFunction<? super T> doubleFunction) {
        this.acquireReadLock();
        try {
            MutableDoubleSet mutableDoubleSet = this.delegate.collectDouble(doubleFunction);
            return mutableDoubleSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableFloatSet collectFloat(FloatFunction<? super T> floatFunction) {
        this.acquireReadLock();
        try {
            MutableFloatSet mutableFloatSet = this.delegate.collectFloat(floatFunction);
            return mutableFloatSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableIntSet collectInt(IntFunction<? super T> intFunction) {
        this.acquireReadLock();
        try {
            MutableIntSet mutableIntSet = this.delegate.collectInt(intFunction);
            return mutableIntSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableLongSet collectLong(LongFunction<? super T> longFunction) {
        this.acquireReadLock();
        try {
            MutableLongSet mutableLongSet = this.delegate.collectLong(longFunction);
            return mutableLongSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableShortSet collectShort(ShortFunction<? super T> shortFunction) {
        this.acquireReadLock();
        try {
            MutableShortSet mutableShortSet = this.delegate.collectShort(shortFunction);
            return mutableShortSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <V> MutableSet<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        this.acquireReadLock();
        try {
            MutableSet mutableSet = this.delegate.flatCollect(function);
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableSet<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            MutableSet<? extends V> mutableSet = this.delegate.collectIf(predicate, function);
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P, V> MutableSet<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        this.acquireReadLock();
        try {
            MutableSet<? extends V> mutableSet = this.delegate.collectWith(function, parameter);
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableSet<T> newEmpty() {
        return MultiReaderUnifiedSet.newSet();
    }

    @Override
    public MutableSet<T> reject(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            MutableSet<? super T> mutableSet = this.delegate.reject(predicate);
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> MutableSet<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            MutableSet<? super T> mutableSet = this.delegate.rejectWith(predicate, parameter);
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableSet<T> tap(Procedure<? super T> procedure) {
        this.acquireReadLock();
        try {
            this.forEach(procedure);
            MultiReaderUnifiedSet multiReaderUnifiedSet = this;
            return multiReaderUnifiedSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableSet<T> select(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            MutableSet<? super T> mutableSet = this.delegate.select(predicate);
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> MutableSet<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            MutableSet<? super T> mutableSet = this.delegate.selectWith(predicate, parameter);
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public PartitionMutableSet<T> partition(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            PartitionMutableSet<? super T> partitionMutableSet = this.delegate.partition(predicate);
            return partitionMutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> PartitionMutableSet<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            PartitionMutableSet<? super T> partitionMutableSet = this.delegate.partitionWith(predicate, parameter);
            return partitionMutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <S> MutableSet<S> selectInstancesOf(Class<S> clazz) {
        this.acquireReadLock();
        try {
            MutableSet<S> mutableSet = this.delegate.selectInstancesOf(clazz);
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableSet<T> with(T element) {
        this.add(element);
        return this;
    }

    @Override
    public MutableSet<T> without(T element) {
        this.remove(element);
        return this;
    }

    @Override
    public MutableSet<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    @Override
    public MutableSet<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        this.acquireReadLock();
        try {
            boolean bl = this.delegate.equals(o);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public int hashCode() {
        this.acquireReadLock();
        try {
            int n = this.delegate.hashCode();
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.delegate);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.delegate = (MutableSet)in.readObject();
        this.lock = new ReentrantReadWriteLock();
    }

    @Override
    public <V> MutableSetMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            MutableSetMultimap<? extends V, ? super T> mutableSetMultimap = this.delegate.groupBy(function);
            return mutableSetMultimap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <V> MutableSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        this.acquireReadLock();
        try {
            MutableSetMultimap mutableSetMultimap = this.delegate.groupByEach(function);
            return mutableSetMultimap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            MutableMap<? extends V, ? super T> mutableMap = this.delegate.groupByUniqueKey(function);
            return mutableMap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    @Deprecated
    public <S> MutableSet<Pair<T, S>> zip(Iterable<S> that) {
        this.acquireReadLock();
        try {
            MutableSet<Pair<T, S>> mutableSet = this.delegate.zip(that);
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        this.acquireReadLock();
        try {
            MutableSet<Pair<T, Integer>> mutableSet = this.delegate.zipWithIndex();
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public RichIterable<RichIterable<T>> chunk(int size2) {
        this.acquireReadLock();
        try {
            RichIterable richIterable = this.delegate.chunk(size2);
            return richIterable;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableSet<T> union(SetIterable<? extends T> set) {
        this.acquireReadLock();
        try {
            MutableSet<? extends T> mutableSet = this.delegate.union(set);
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Set<T>> R unionInto(SetIterable<? extends T> set, R targetSet) {
        this.acquireReadLock();
        try {
            R r = this.delegate.unionInto(set, targetSet);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableSet<T> intersect(SetIterable<? extends T> set) {
        this.acquireReadLock();
        try {
            MutableSet<? extends T> mutableSet = this.delegate.intersect(set);
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Set<T>> R intersectInto(SetIterable<? extends T> set, R targetSet) {
        this.acquireReadLock();
        try {
            R r = this.delegate.intersectInto(set, targetSet);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableSet<T> difference(SetIterable<? extends T> subtrahendSet) {
        this.acquireReadLock();
        try {
            MutableSet<? extends T> mutableSet = this.delegate.difference(subtrahendSet);
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Set<T>> R differenceInto(SetIterable<? extends T> subtrahendSet, R targetSet) {
        this.acquireReadLock();
        try {
            R r = this.delegate.differenceInto(subtrahendSet, targetSet);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableSet<T> symmetricDifference(SetIterable<? extends T> setB) {
        this.acquireReadLock();
        try {
            MutableSet<? extends T> mutableSet = this.delegate.symmetricDifference(setB);
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Set<T>> R symmetricDifferenceInto(SetIterable<? extends T> set, R targetSet) {
        this.acquireReadLock();
        try {
            R r = this.delegate.symmetricDifferenceInto(set, targetSet);
            return r;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public boolean isSubsetOf(SetIterable<? extends T> candidateSuperset) {
        this.acquireReadLock();
        try {
            boolean bl = this.delegate.isSubsetOf(candidateSuperset);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public boolean isProperSubsetOf(SetIterable<? extends T> candidateSuperset) {
        this.acquireReadLock();
        try {
            boolean bl = this.delegate.isProperSubsetOf(candidateSuperset);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableSet<UnsortedSetIterable<T>> powerSet() {
        this.acquireReadLock();
        try {
            MutableSet<UnsortedSetIterable<T>> mutableSet = this.delegate.powerSet();
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <B> LazyIterable<Pair<T, B>> cartesianProduct(SetIterable<B> set) {
        this.acquireReadLock();
        try {
            LazyIterable lazyIterable = this.delegate.cartesianProduct(set);
            return lazyIterable;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public ParallelUnsortedSetIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        return new MultiReaderParallelUnsortedSetIterable(this.delegate.asParallel(executorService, batchSize), this.lock);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UntouchableIterator<T>
    implements Iterator<T> {
        private Iterator<T> delegate;

        private UntouchableIterator(Iterator<T> newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        public void becomeUseless() {
            this.delegate = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UntouchableMutableSet<T>
    extends AbstractMultiReaderMutableCollection.UntouchableMutableCollection<T>
    implements MutableSet<T> {
        private final MutableList<UntouchableIterator<T>> requestedIterators = Iterables.mList();

        private UntouchableMutableSet(MutableSet<T> newDelegate) {
            this.delegate = newDelegate;
        }

        public void becomeUseless() {
            this.delegate = null;
            this.requestedIterators.forEach(new Procedure<UntouchableIterator<T>>(){

                @Override
                public void value(UntouchableIterator<T> each2) {
                    each2.becomeUseless();
                }
            });
        }

        @Override
        public MutableSet<T> with(T element) {
            this.add(element);
            return this;
        }

        @Override
        public MutableSet<T> without(T element) {
            this.remove(element);
            return this;
        }

        @Override
        public MutableSet<T> withAll(Iterable<? extends T> elements) {
            this.addAllIterable(elements);
            return this;
        }

        @Override
        public MutableSet<T> withoutAll(Iterable<? extends T> elements) {
            this.removeAllIterable(elements);
            return this;
        }

        @Override
        public MutableSet<T> asSynchronized() {
            throw new UnsupportedOperationException("Cannot call asSynchronized() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableSet<T> asUnmodifiable() {
            throw new UnsupportedOperationException("Cannot call asUnmodifiable() on " + this.getClass().getSimpleName());
        }

        @Override
        public ImmutableSet<T> toImmutable() {
            return Sets.immutable.withAll(this.getDelegate());
        }

        @Override
        public LazyIterable<T> asLazy() {
            return LazyIterate.adapt(this);
        }

        @Override
        public MutableSet<T> clone() {
            return this.getDelegate().clone();
        }

        @Override
        public <V> MutableSet<V> collect(Function<? super T, ? extends V> function) {
            return this.getDelegate().collect(function);
        }

        @Override
        public MutableBooleanSet collectBoolean(BooleanFunction<? super T> booleanFunction) {
            return this.getDelegate().collectBoolean(booleanFunction);
        }

        @Override
        public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super T> booleanFunction, R target) {
            return this.getDelegate().collectBoolean(booleanFunction, target);
        }

        @Override
        public MutableByteSet collectByte(ByteFunction<? super T> byteFunction) {
            return this.getDelegate().collectByte(byteFunction);
        }

        @Override
        public <R extends MutableByteCollection> R collectByte(ByteFunction<? super T> byteFunction, R target) {
            return this.getDelegate().collectByte(byteFunction, target);
        }

        @Override
        public MutableCharSet collectChar(CharFunction<? super T> charFunction) {
            return this.getDelegate().collectChar(charFunction);
        }

        @Override
        public <R extends MutableCharCollection> R collectChar(CharFunction<? super T> charFunction, R target) {
            return this.getDelegate().collectChar(charFunction, target);
        }

        @Override
        public MutableDoubleSet collectDouble(DoubleFunction<? super T> doubleFunction) {
            return this.getDelegate().collectDouble(doubleFunction);
        }

        @Override
        public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super T> doubleFunction, R target) {
            return this.getDelegate().collectDouble(doubleFunction, target);
        }

        @Override
        public MutableFloatSet collectFloat(FloatFunction<? super T> floatFunction) {
            return this.getDelegate().collectFloat(floatFunction);
        }

        @Override
        public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super T> floatFunction, R target) {
            return this.getDelegate().collectFloat(floatFunction, target);
        }

        @Override
        public MutableIntSet collectInt(IntFunction<? super T> intFunction) {
            return this.getDelegate().collectInt(intFunction);
        }

        @Override
        public <R extends MutableIntCollection> R collectInt(IntFunction<? super T> intFunction, R target) {
            return this.getDelegate().collectInt(intFunction, target);
        }

        @Override
        public MutableLongSet collectLong(LongFunction<? super T> longFunction) {
            return this.getDelegate().collectLong(longFunction);
        }

        @Override
        public <R extends MutableLongCollection> R collectLong(LongFunction<? super T> longFunction, R target) {
            return this.getDelegate().collectLong(longFunction, target);
        }

        @Override
        public MutableShortSet collectShort(ShortFunction<? super T> shortFunction) {
            return this.getDelegate().collectShort(shortFunction);
        }

        @Override
        public <R extends MutableShortCollection> R collectShort(ShortFunction<? super T> shortFunction, R target) {
            return this.getDelegate().collectShort(shortFunction, target);
        }

        @Override
        public <V> MutableSet<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
            return this.getDelegate().flatCollect(function);
        }

        @Override
        public <V> MutableSet<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
            return this.getDelegate().collectIf(predicate, function);
        }

        @Override
        public <P, V> MutableSet<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
            return this.getDelegate().collectWith(function, parameter);
        }

        @Override
        public <V> MutableSetMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
            return this.getDelegate().groupBy(function);
        }

        @Override
        public <V> MutableSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
            return this.getDelegate().groupByEach(function);
        }

        @Override
        public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
            return this.getDelegate().groupByUniqueKey(function);
        }

        @Override
        public MutableSet<T> newEmpty() {
            return this.getDelegate().newEmpty();
        }

        @Override
        public MutableSet<T> reject(Predicate<? super T> predicate) {
            return this.getDelegate().reject(predicate);
        }

        @Override
        public <P> MutableSet<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().rejectWith(predicate, parameter);
        }

        @Override
        public MutableSet<T> tap(Procedure<? super T> procedure) {
            this.forEach(procedure);
            return this;
        }

        @Override
        public MutableSet<T> select(Predicate<? super T> predicate) {
            return this.getDelegate().select(predicate);
        }

        @Override
        public <P> MutableSet<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().selectWith(predicate, parameter);
        }

        @Override
        public PartitionMutableSet<T> partition(Predicate<? super T> predicate) {
            return this.getDelegate().partition(predicate);
        }

        @Override
        public <P> PartitionMutableSet<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().partitionWith(predicate, parameter);
        }

        @Override
        public <S> MutableSet<S> selectInstancesOf(Class<S> clazz) {
            return this.getDelegate().selectInstancesOf(clazz);
        }

        @Override
        public Iterator<T> iterator() {
            UntouchableIterator iterator2 = new UntouchableIterator(this.delegate.iterator());
            this.requestedIterators.add(iterator2);
            return iterator2;
        }

        @Override
        @Deprecated
        public <S> MutableSet<Pair<T, S>> zip(Iterable<S> that) {
            return this.getDelegate().zip(that);
        }

        @Override
        @Deprecated
        public MutableSet<Pair<T, Integer>> zipWithIndex() {
            return this.getDelegate().zipWithIndex();
        }

        @Override
        public MutableSet<T> union(SetIterable<? extends T> set) {
            return this.getDelegate().union(set);
        }

        @Override
        public <R extends Set<T>> R unionInto(SetIterable<? extends T> set, R targetSet) {
            return this.getDelegate().unionInto(set, targetSet);
        }

        @Override
        public MutableSet<T> intersect(SetIterable<? extends T> set) {
            return this.getDelegate().intersect(set);
        }

        @Override
        public <R extends Set<T>> R intersectInto(SetIterable<? extends T> set, R targetSet) {
            return this.getDelegate().intersectInto(set, targetSet);
        }

        @Override
        public MutableSet<T> difference(SetIterable<? extends T> subtrahendSet) {
            return this.getDelegate().difference(subtrahendSet);
        }

        @Override
        public <R extends Set<T>> R differenceInto(SetIterable<? extends T> subtrahendSet, R targetSet) {
            return this.getDelegate().differenceInto(subtrahendSet, targetSet);
        }

        @Override
        public MutableSet<T> symmetricDifference(SetIterable<? extends T> setB) {
            return this.getDelegate().symmetricDifference(setB);
        }

        @Override
        public <R extends Set<T>> R symmetricDifferenceInto(SetIterable<? extends T> set, R targetSet) {
            return this.getDelegate().symmetricDifferenceInto(set, targetSet);
        }

        @Override
        public boolean isSubsetOf(SetIterable<? extends T> candidateSuperset) {
            return this.getDelegate().isSubsetOf(candidateSuperset);
        }

        @Override
        public boolean isProperSubsetOf(SetIterable<? extends T> candidateSuperset) {
            return this.getDelegate().isProperSubsetOf(candidateSuperset);
        }

        @Override
        public MutableSet<UnsortedSetIterable<T>> powerSet() {
            return this.getDelegate().powerSet();
        }

        @Override
        public <B> LazyIterable<Pair<T, B>> cartesianProduct(SetIterable<B> set) {
            return this.getDelegate().cartesianProduct(set);
        }

        @Override
        public ParallelUnsortedSetIterable<T> asParallel(ExecutorService executorService, int batchSize) {
            return this.getDelegate().asParallel(executorService, batchSize);
        }

        private MutableSet<T> getDelegate() {
            return (MutableSet)this.delegate;
        }
    }
}

