/*
 * Decompiled with CFR 0.152.
 */
package utils.statistics;

import connectivity.conn_package.PackageReader;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import utils.statistics.BurningWriter;
import utils.statistics.CollectedBurn;
import utils.statistics.CollectedFire;
import utils.statistics.FiringWriter;

public class StatisticsCollector {
    private final String TAG = "[Statistic Collector] ";
    private Long active = 0L;
    private Long passive = 0L;
    private Long passive2active = 0L;
    private Long active2passive = 0L;
    public Long missedFires = 0L;
    private ArrayList<Double> firstFiringTimes = null;
    private Double minMissedAxonalDelay = Double.MAX_VALUE;
    private Double minNe_xn_ratio;
    private Double maxNe_xn_ratio;
    private Boolean badCurve = false;
    private long firingSpikesCounter = 0L;
    private long burningSpikesCounter = 0L;
    private int serializeAfter = 10000;
    private int wrotes_split = 0;
    private String filename = "";
    protected Boolean matlab = false;
    protected Boolean gephi = false;
    protected Boolean reducedOutput = false;
    protected Boolean superReducedOutput = false;
    private int count = 1;
    private ArrayList<CollectedFire> newFires = new ArrayList();
    private ArrayList<CollectedBurn> newBurns = new ArrayList();
    private Lock lock = new ReentrantLock();
    private Condition eventQueueCondition = this.lock.newCondition();
    protected Boolean keepRunning = true;
    private String defFileName = null;
    private File towritefile;
    private BurningWriter burningWriter;
    private FiringWriter firingWriter;

    public void start() {
        this.burningWriter.start();
        this.firingWriter.start();
    }

    public void kill() {
        this.keepRunning = false;
        this.burningWriter.flush();
        this.firingWriter.flush();
    }

    public void close() {
        this.burningWriter.close();
        this.firingWriter.close();
    }

    public void setSerializeAfter(int sa) {
        this.serializeAfter = sa;
    }

    public int getSerializeAfter() {
        return this.serializeAfter;
    }

    public void init(String defFilename) {
        this.burningWriter = new BurningWriter(this, this.defFileName, this.serializeAfter);
        this.firingWriter = new FiringWriter(this, this.defFileName, this.serializeAfter);
    }

    public void setMatlab() {
        this.matlab = true;
    }

    public void setReducedOutput() {
        this.reducedOutput = true;
    }

    public void setSuperReducedOutput() {
        this.superReducedOutput = true;
    }

    public void setGephi() {
        this.gephi = true;
    }

    public synchronized void collectActive() {
        this.active = this.active + 1L;
    }

    public synchronized void collectPassive2active() {
        this.passive2active = this.passive2active + 1L;
    }

    public synchronized void collectActive2passive() {
        this.active2passive = this.active2passive + 1L;
    }

    public synchronized void collectPassive() {
        this.passive = this.passive + 1L;
    }

    public synchronized void collectFireSpike(Integer firingNodeId, Long firingNeuronId, Double firingTime, Long maxN, Double compressionFactor, Boolean isExcitatory, Boolean isExternal) {
        this.firingWriter.put(new CollectedFire(firingNodeId, firingNeuronId, firingTime, maxN, compressionFactor, isExcitatory, isExternal));
    }

    public synchronized void collectBurnSpike(Long firingNeuronId, Integer firingNodeId, Long burningNeuronId, Integer burningNodeId, Double burnTime, Boolean fromExternalSource, Double fromState, Double stepInState, Double postsynapticWeight, Double presynapticWeight, Double timeToFire, Double fireTime) {
        this.burningWriter.put(new CollectedBurn(firingNeuronId, firingNodeId, burningNeuronId, burningNodeId, burnTime, fromExternalSource, fromState, stepInState, postsynapticWeight, presynapticWeight, timeToFire, fireTime));
    }

    public synchronized void collectMissedFire(Double missedAxonalDelay) {
        if (missedAxonalDelay < this.minMissedAxonalDelay) {
            this.minMissedAxonalDelay = missedAxonalDelay;
        }
        this.missedFires = this.missedFires + 1L;
    }

    public void setMinMaxNe_xn_ratios(Double minNe_xn_ratio, Double maxNe_xn_ratio) {
        this.minNe_xn_ratio = minNe_xn_ratio;
        this.maxNe_xn_ratio = maxNe_xn_ratio;
    }

    public void PrintResults() {
        String minNe_xn_ratioStr = this.minNe_xn_ratio == PackageReader.MIN_NE_EN_RATIO_DEF ? "no connection between nodes" : "" + this.minNe_xn_ratio;
        String maxNe_xn_ratioStr = this.maxNe_xn_ratio == PackageReader.MAX_NE_EN_RATIO_DEF ? "no connection between nodes" : "" + this.maxNe_xn_ratio;
        System.out.println("missed Fires:" + this.missedFires);
        if (this.missedFires > 0L) {
            System.out.println("minimum missed fire axonal delay:" + this.minMissedAxonalDelay);
        }
        System.out.println("Good curve:" + (this.badCurve == false));
    }

    public void setBadCurve() {
        this.badCurve = true;
    }

    public Boolean getReducedOutput() {
        Thread currentThread = Thread.currentThread();
        System.out.println("Thread :" + currentThread.getId());
        System.out.println("sc reducedOutput: " + this.reducedOutput);
        System.out.println();
        return this.reducedOutput;
    }

    public void setWriters(PrintWriter burningPw, PrintWriter burningPwGephi, PrintWriter burningPwMatlab, PrintWriter firingPw, PrintWriter firingPwGephi, PrintWriter firingPwMatlab) {
        this.burningWriter.setWriters(burningPw, burningPwGephi, burningPwMatlab);
        this.firingWriter.setWriters(firingPw, firingPwGephi, firingPwMatlab);
    }
}

