/*
 * Decompiled with CFR 0.152.
 */
package connectivity.nodes;

import connectivity.conn_package.PackageReader;
import connectivity.nodes.Node;
import java.util.ArrayList;
import java.util.HashMap;
import spiking.node.NodesInterconnection;
import utils.tools.IntegerCouple;

public class ConnectivityPackageManager {
    private ArrayList<Node> nodes = new ArrayList();
    private PackageReader pr = new PackageReader(this);
    private ArrayList<NodesInterconnection> ris = new ArrayList();
    private HashMap<IntegerCouple, Integer> indexes = new HashMap();

    private void _addNode(Node r) {
        if (this.nodes == null) {
            return;
        }
        this.nodes.add(r);
    }

    public void addNode() {
        this._addNode(new Node());
    }

    public void addNode(Node r) {
        this._addNode(r);
    }

    public void addNode(String label, Double x, Double y, Double z) {
        this._addNode(new Node(this, label, x, y, z));
    }

    public Node getNode(Integer id) {
        return this.nodes.get(id);
    }

    public void addEdge(Integer src, Integer dst, Double weight) {
        IntegerCouple tmp;
        Integer index;
        if (this.nodes.get(src) != null && this.nodes.get(dst) != null && (index = this.indexes.get(tmp = new IntegerCouple(src, dst))) == null) {
            this.indexes.put(tmp, this.ris.size());
            this.ris.add(new NodesInterconnection(src, dst, weight));
        }
    }

    public void addAmplitude(Integer src, Integer dst, Double amplitude) {
        IntegerCouple tmp;
        Integer index;
        if (this.nodes.get(src) != null && this.nodes.get(dst) != null && (index = this.indexes.get(tmp = new IntegerCouple(src, dst))) != null) {
            this.ris.get(index).setAmplitude(amplitude);
        }
    }

    public void addAmplitudeStdDeviation(Integer src, Integer dst, Double amplitude) {
        IntegerCouple tmp;
        Integer index;
        if (this.nodes.get(src) != null && this.nodes.get(dst) != null && (index = this.indexes.get(tmp = new IntegerCouple(src, dst))) != null) {
            this.ris.get(index).setAmplitudeStdDeviation(amplitude);
        }
    }

    public void addLength(Integer src, Integer dst, double lenght) {
        IntegerCouple tmp;
        Integer index;
        if (this.nodes.get(src) != null && this.nodes.get(dst) != null && (index = this.indexes.get(tmp = new IntegerCouple(src, dst))) != null) {
            this.ris.get(index).setLength(lenght);
        }
    }

    public void addLengthShapeParameter(Integer src, Integer dst, double lenghtShapeParameter) {
        IntegerCouple tmp;
        Integer index;
        if (this.nodes.get(src) != null && this.nodes.get(dst) != null && (index = this.indexes.get(tmp = new IntegerCouple(src, dst))) != null) {
            this.ris.get(index).setLengthShapeParameter(lenghtShapeParameter);
        }
    }

    public void addType(Integer src, Integer dst, Integer type) {
        IntegerCouple tmp;
        Integer index;
        if (this.nodes.get(src) != null && this.nodes.get(dst) != null && (index = this.indexes.get(tmp = new IntegerCouple(src, dst))) != null) {
            this.ris.get(index).setType(type);
        }
    }

    public Integer getNodesNum() {
        return this.nodes.size();
    }

    public Integer getEdgesNum() {
        return this.ris.size();
    }

    public ArrayList<NodesInterconnection> getInterNodeConnections() {
        return this.ris;
    }

    public void readConnectivityPackage(String path) {
        this.pr.readConnectivityPackage(path);
    }

    public Double getMinNe_xn_ratio() {
        return this.pr.getMinNe_xn_ratio();
    }

    public Double getMaxNe_xn_ratio() {
        return this.pr.getMaxNe_xn_ratio();
    }

    public static void main(String[] args) {
        ConnectivityPackageManager rm = new ConnectivityPackageManager();
        rm.readConnectivityPackage("/home/knizontes/Documenti/uni/tesi/neural_network/connectivity_998");
        System.out.println("Nodes:" + rm.getNodesNum());
        System.out.println("Edges:" + rm.getEdgesNum());
    }
}

