/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.neuralnet.Network;
import org.apache.commons.math3.ml.neuralnet.Neuron;
import org.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import org.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapUtils {
    private MapUtils() {
    }

    public static Neuron findBest(double[] features, Iterable<Neuron> neurons, DistanceMeasure distance) {
        Neuron best = null;
        double min2 = Double.POSITIVE_INFINITY;
        for (Neuron n : neurons) {
            double d = distance.compute(n.getFeatures(), features);
            if (!(d < min2)) continue;
            min2 = d;
            best = n;
        }
        return best;
    }

    public static Pair<Neuron, Neuron> findBestAndSecondBest(double[] features, Iterable<Neuron> neurons, DistanceMeasure distance) {
        Neuron[] best = new Neuron[]{null, null};
        double[] min2 = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        for (Neuron n : neurons) {
            double d = distance.compute(n.getFeatures(), features);
            if (d < min2[0]) {
                min2[1] = min2[0];
                best[1] = best[0];
                min2[0] = d;
                best[0] = n;
                continue;
            }
            if (!(d < min2[1])) continue;
            min2[1] = d;
            best[1] = n;
        }
        return new Pair<Neuron, Neuron>(best[0], best[1]);
    }

    public static double[][] computeU(NeuronSquareMesh2D map2, DistanceMeasure distance) {
        int numRows = map2.getNumberOfRows();
        int numCols = map2.getNumberOfColumns();
        double[][] uMatrix = new double[numRows][numCols];
        Network net = map2.getNetwork();
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                Neuron neuron = map2.getNeuron(i, j);
                Collection<Neuron> neighbours = net.getNeighbours(neuron);
                double[] features = neuron.getFeatures();
                double d = 0.0;
                int count2 = 0;
                for (Neuron n : neighbours) {
                    ++count2;
                    d += distance.compute(features, n.getFeatures());
                }
                uMatrix[i][j] = d / (double)count2;
            }
        }
        return uMatrix;
    }

    public static int[][] computeHitHistogram(Iterable<double[]> data, NeuronSquareMesh2D map2, DistanceMeasure distance) {
        HashMap<Neuron, Integer> hit = new HashMap<Neuron, Integer>();
        Network net = map2.getNetwork();
        for (double[] f : data) {
            Neuron best = MapUtils.findBest(f, net, distance);
            Integer count2 = (Integer)hit.get(best);
            if (count2 == null) {
                hit.put(best, 1);
                continue;
            }
            hit.put(best, count2 + 1);
        }
        int numRows = map2.getNumberOfRows();
        int numCols = map2.getNumberOfColumns();
        int[][] histo = new int[numRows][numCols];
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                Neuron neuron = map2.getNeuron(i, j);
                Integer count3 = (Integer)hit.get(neuron);
                histo[i][j] = count3 == null ? 0 : count3;
            }
        }
        return histo;
    }

    public static double computeQuantizationError(Iterable<double[]> data, Iterable<Neuron> neurons, DistanceMeasure distance) {
        double d = 0.0;
        int count2 = 0;
        for (double[] f : data) {
            ++count2;
            d += distance.compute(f, MapUtils.findBest(f, neurons, distance).getFeatures());
        }
        if (count2 == 0) {
            throw new NoDataException();
        }
        return d / (double)count2;
    }

    public static double computeTopographicError(Iterable<double[]> data, Network net, DistanceMeasure distance) {
        int notAdjacentCount = 0;
        int count2 = 0;
        for (double[] f : data) {
            ++count2;
            Pair<Neuron, Neuron> p = MapUtils.findBestAndSecondBest(f, net, distance);
            if (net.getNeighbours(p.getFirst()).contains(p.getSecond())) continue;
            ++notAdjacentCount;
        }
        if (count2 == 0) {
            throw new NoDataException();
        }
        return (double)notAdjacentCount / (double)count2;
    }
}

