/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.factory;

import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.predicate.CodePointPredicate;
import org.eclipse.collections.impl.utility.StringIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringPredicates {
    private static final Predicates<String> EMPTY = new Empty();
    private static final Predicates<String> NOT_EMPTY = new NotEmpty();
    private static final Predicates<String> HAS_LETTERS = new HasLetters();
    private static final Predicates<String> HAS_DIGITS = new HasDigits();
    private static final Predicates<String> HAS_LETTERS_OR_DIGITS = new HasLettersOrDigits();
    private static final Predicates<String> HAS_LETTERS_AND_DIGITS = new HasLettersAndDigits();
    private static final Predicates<String> HAS_SPACES = new HasSpaces();
    private static final Predicates<String> HAS_UPPERCASE = new HasUppercase();
    private static final Predicates<String> HAS_LOWERCASE = new HasLowercase();
    private static final Predicates<String> HAS_UNDEFINED = new HasUndefined();
    private static final Predicates<String> IS_NUMERIC = new IsNumeric();
    private static final Predicates<String> IS_ALPHANUMERIC = new IsAlphanumeric();
    private static final Predicates<String> IS_BLANK = new IsBlank();
    private static final Predicates<String> NOT_BLANK = new NotBlank();
    private static final Predicates<String> IS_ALPHA = new IsAlpha();

    private StringPredicates() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static Predicates<String> empty() {
        return EMPTY;
    }

    public static Predicates<String> notEmpty() {
        return NOT_EMPTY;
    }

    public static Predicates<String> contains(String otherString) {
        return new ContainsString(otherString);
    }

    public static Predicates<String> notContains(String otherString) {
        return new NotContainsString(otherString);
    }

    public static Predicates<String> contains(char character) {
        return new ContainsCharacter(character);
    }

    public static Predicates<String> startsWith(String substring) {
        return new StartsWith(substring);
    }

    public static Predicates<String> endsWith(String substring) {
        return new EndsWith(substring);
    }

    public static Predicates<String> size(int size2) {
        return new Size(size2);
    }

    public static Predicates<String> equalsIgnoreCase(String otherString) {
        return new EqualsIgnoreCase(otherString);
    }

    public static Predicates<String> matches(String regex) {
        return new MatchesRegex(regex);
    }

    public static Predicates<String> lessThan(String string) {
        return new LessThan(string);
    }

    public static Predicates<String> lessThanOrEqualTo(String string) {
        return new LessThanOrEqualTo(string);
    }

    public static Predicates<String> greaterThan(String string) {
        return new GreaterThan(string);
    }

    public static Predicates<String> greaterThanOrEqualTo(String string) {
        return new GreaterThanOrEqualTo(string);
    }

    public static Predicates<String> hasLetters() {
        return HAS_LETTERS;
    }

    public static Predicates<String> hasDigits() {
        return HAS_DIGITS;
    }

    public static Predicates<String> hasLettersOrDigits() {
        return HAS_LETTERS_OR_DIGITS;
    }

    public static Predicates<String> hasLettersAndDigits() {
        return HAS_LETTERS_AND_DIGITS;
    }

    public static Predicates<String> hasSpaces() {
        return HAS_SPACES;
    }

    public static Predicates<String> hasUpperCase() {
        return HAS_UPPERCASE;
    }

    public static Predicates<String> hasLowerCase() {
        return HAS_LOWERCASE;
    }

    public static Predicates<String> hasUndefined() {
        return HAS_UNDEFINED;
    }

    public static Predicates<String> isNumeric() {
        return IS_NUMERIC;
    }

    public static Predicates<String> isAlphanumeric() {
        return IS_ALPHANUMERIC;
    }

    public static Predicates<String> isBlank() {
        return IS_BLANK;
    }

    public static Predicates<String> notBlank() {
        return NOT_BLANK;
    }

    public static Predicates<String> isAlpha() {
        return IS_ALPHA;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GreaterThanOrEqualTo
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;
        private final String string;

        private GreaterThanOrEqualTo(String newString) {
            this.string = newString;
        }

        @Override
        public boolean accept(String anObject) {
            return anObject != null && anObject.compareTo(this.string) >= 0;
        }

        public String toString() {
            return "StringPredicates.greaterThanOrEqualTo(\"" + this.string + "\")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GreaterThan
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;
        private final String string;

        private GreaterThan(String newString) {
            this.string = newString;
        }

        @Override
        public boolean accept(String anObject) {
            return anObject != null && anObject.compareTo(this.string) > 0;
        }

        public String toString() {
            return "StringPredicates.greaterThan(\"" + this.string + "\")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LessThanOrEqualTo
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;
        private final String string;

        private LessThanOrEqualTo(String newString) {
            this.string = newString;
        }

        @Override
        public boolean accept(String anObject) {
            return anObject != null && anObject.compareTo(this.string) <= 0;
        }

        public String toString() {
            return "StringPredicates.lessThanOrEqualTo(\"" + this.string + "\")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LessThan
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;
        private final String string;

        private LessThan(String newString) {
            this.string = newString;
        }

        @Override
        public boolean accept(String anObject) {
            return anObject != null && anObject.compareTo(this.string) < 0;
        }

        public String toString() {
            return "StringPredicates.lessThan(\"" + this.string + "\")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MatchesRegex
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;
        private final String regex;

        private MatchesRegex(String newRegex) {
            this.regex = newRegex;
        }

        @Override
        public boolean accept(String anObject) {
            return anObject != null && anObject.matches(this.regex);
        }

        public String toString() {
            return "StringPredicates.matches(\"" + this.regex + "\")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EqualsIgnoreCase
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;
        private final String otherString;

        private EqualsIgnoreCase(String newOtherString) {
            this.otherString = newOtherString;
        }

        @Override
        public boolean accept(String anObject) {
            return anObject != null && anObject.equalsIgnoreCase(this.otherString);
        }

        public String toString() {
            return "StringPredicates.equalsIgnoreCase(\"" + this.otherString + "\")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Size
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;
        private final int size;

        private Size(int newSize) {
            this.size = newSize;
        }

        @Override
        public boolean accept(String anObject) {
            return anObject != null && anObject.length() == this.size;
        }

        public String toString() {
            return "StringPredicates.size(" + this.size + ')';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EndsWith
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;
        private final String substring;

        private EndsWith(String newSubstring) {
            this.substring = newSubstring;
        }

        @Override
        public boolean accept(String anObject) {
            return anObject != null && anObject.endsWith(this.substring);
        }

        public String toString() {
            return "StringPredicates.endsWith(\"" + this.substring + "\")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StartsWith
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;
        private final String substring;

        private StartsWith(String newSubstring) {
            this.substring = newSubstring;
        }

        @Override
        public boolean accept(String anObject) {
            return anObject != null && anObject.startsWith(this.substring);
        }

        public String toString() {
            return "StringPredicates.startsWith(\"" + this.substring + "\")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ContainsCharacter
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;
        private final char character;

        private ContainsCharacter(char newCharacter) {
            this.character = newCharacter;
        }

        @Override
        public boolean accept(String string) {
            return StringIterate.notEmpty(string) && string.indexOf(this.character) > -1;
        }

        public String toString() {
            return "StringPredicates.contains(\"" + this.character + "\")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NotContainsString
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;
        private final String otherString;

        private NotContainsString(String newOtherString) {
            this.otherString = newOtherString;
        }

        @Override
        public boolean accept(String string) {
            return StringIterate.isEmpty(string) || !string.contains(this.otherString);
        }

        public String toString() {
            return "StringPredicates.notContains(\"" + this.otherString + "\")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ContainsString
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;
        private final String otherString;

        private ContainsString(String newOtherString) {
            this.otherString = newOtherString;
        }

        @Override
        public boolean accept(String string) {
            return StringIterate.notEmpty(string) && string.contains(this.otherString);
        }

        public String toString() {
            return "StringPredicates.contains(\"" + this.otherString + "\")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsAlpha
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;

        private IsAlpha() {
        }

        @Override
        public boolean accept(String anObject) {
            return anObject != null && StringIterate.allSatisfy(anObject, CodePointPredicate.IS_LETTER);
        }

        public String toString() {
            return "StringPredicates.isAlpha()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotBlank
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;

        private NotBlank() {
        }

        @Override
        public boolean accept(String string) {
            return StringIterate.notEmptyOrWhitespace(string);
        }

        public String toString() {
            return "StringPredicates.notBlank()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsBlank
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;

        private IsBlank() {
        }

        @Override
        public boolean accept(String string) {
            return StringIterate.isEmptyOrWhitespace(string);
        }

        public String toString() {
            return "StringPredicates.isBlank()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsAlphanumeric
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;

        private IsAlphanumeric() {
        }

        @Override
        public boolean accept(String anObject) {
            return StringIterate.allSatisfy(anObject, CodePointPredicate.IS_LETTER_OR_DIGIT);
        }

        public String toString() {
            return "StringPredicates.isAlphanumeric()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsNumeric
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;

        private IsNumeric() {
        }

        @Override
        public boolean accept(String anObject) {
            return StringIterate.allSatisfy(anObject, CodePointPredicate.IS_DIGIT);
        }

        public String toString() {
            return "StringPredicates.isNumeric()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HasUndefined
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;

        private HasUndefined() {
        }

        @Override
        public boolean accept(String anObject) {
            return StringIterate.anySatisfy(anObject, CodePointPredicate.IS_UNDEFINED);
        }

        public String toString() {
            return "StringPredicates.hasUndefined()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HasLowercase
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;

        private HasLowercase() {
        }

        @Override
        public boolean accept(String anObject) {
            return StringIterate.anySatisfy(anObject, CodePointPredicate.IS_LOWERCASE);
        }

        public String toString() {
            return "StringPredicates.hasLowerCase()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HasUppercase
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;

        private HasUppercase() {
        }

        @Override
        public boolean accept(String anObject) {
            return StringIterate.anySatisfy(anObject, CodePointPredicate.IS_UPPERCASE);
        }

        public String toString() {
            return "StringPredicates.hasUpperCase()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HasSpaces
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;

        private HasSpaces() {
        }

        @Override
        public boolean accept(String anObject) {
            return StringIterate.anySatisfy(anObject, CodePointPredicate.IS_WHITESPACE);
        }

        public String toString() {
            return "StringPredicates.hasSpaces()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HasLettersAndDigits
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;

        private HasLettersAndDigits() {
        }

        @Override
        public boolean accept(String string) {
            boolean hasLetter = false;
            boolean hasDigit = false;
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isLetter(string.codePointAt(i))) {
                    hasLetter = true;
                }
                if (Character.isDigit(string.codePointAt(i))) {
                    hasDigit = true;
                }
                if (!hasLetter || !hasDigit) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "StringPredicates.hasLettersAndDigits()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HasLettersOrDigits
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;

        private HasLettersOrDigits() {
        }

        @Override
        public boolean accept(String anObject) {
            return StringIterate.anySatisfy(anObject, CodePointPredicate.IS_LETTER_OR_DIGIT);
        }

        public String toString() {
            return "StringPredicates.hasLettersOrDigits()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HasDigits
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;

        private HasDigits() {
        }

        @Override
        public boolean accept(String anObject) {
            return StringIterate.anySatisfy(anObject, CodePointPredicate.IS_DIGIT);
        }

        public String toString() {
            return "StringPredicates.hasDigits()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HasLetters
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;

        private HasLetters() {
        }

        @Override
        public boolean accept(String anObject) {
            return StringIterate.anySatisfy(anObject, CodePointPredicate.IS_LETTER);
        }

        public String toString() {
            return "StringPredicates.hasLetters()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotEmpty
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;

        private NotEmpty() {
        }

        @Override
        public boolean accept(String anObject) {
            return anObject != null && anObject.length() > 0;
        }

        public String toString() {
            return "StringPredicates.notEmpty()";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Empty
    extends Predicates<String> {
        private static final long serialVersionUID = 1L;

        private Empty() {
        }

        @Override
        public boolean accept(String anObject) {
            return anObject != null && anObject.length() == 0;
        }

        public String toString() {
            return "StringPredicates.empty()";
        }
    }
}

