/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.collection.immutable;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.impl.AbstractRichIterable;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.utility.Iterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractImmutableCollection<T>
extends AbstractRichIterable<T>
implements ImmutableCollection<T>,
Collection<T> {
    protected abstract MutableCollection<T> newMutable(int var1);

    @Override
    public <K, V> ImmutableMap<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        UnifiedMap map2 = UnifiedMap.newMap();
        this.forEach(new MutatingAggregationProcedure<T, K, V>(map2, groupBy, zeroValueFactory, mutatingAggregator));
        return map2.toImmutable();
    }

    @Override
    public <K, V> ImmutableMap<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        UnifiedMap map2 = UnifiedMap.newMap();
        this.forEach(new NonMutatingAggregationProcedure<T, K, V>(map2, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map2.toImmutable();
    }

    @Override
    public <V> ImmutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return Iterate.groupByUniqueKey(this, function).toImmutable();
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    protected void removeAllFrom(Iterable<? extends T> elements, MutableCollection<T> result) {
        if (elements instanceof Set) {
            result.removeAll((Set)elements);
        } else if (elements instanceof List) {
            List toBeRemoved = (List)elements;
            if (this.size() * toBeRemoved.size() > 10000) {
                result.removeAll(UnifiedSet.newSet(elements));
            } else {
                result.removeAll(toBeRemoved);
            }
        } else {
            result.removeAll(UnifiedSet.newSet(elements));
        }
    }

    @Override
    public RichIterable<RichIterable<T>> chunk(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        Iterator iterator2 = this.iterator();
        MutableList result = Lists.mutable.empty();
        while (iterator2.hasNext()) {
            MutableCollection<T> batch = this.newMutable(size2);
            for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
                batch.add(iterator2.next());
            }
            result.add(batch.toImmutable());
        }
        return result.toImmutable();
    }
}

