/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.collection.mutable;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.Function3;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.tuple.Twin;
import org.eclipse.collections.impl.AbstractRichIterable;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.block.factory.Procedures2;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import org.eclipse.collections.impl.collection.mutable.CollectionAdapter;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.internal.IterableIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutableCollection<T>
extends AbstractRichIterable<T>
implements MutableCollection<T> {
    @Override
    public <P> Twin<MutableList<T>> selectAndRejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return IterableIterate.selectAndRejectWith(this, predicate, parameter);
    }

    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        return IterableIterate.removeIf(this, predicate);
    }

    @Override
    public <P> boolean removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return IterableIterate.removeIfWith(this, predicate, parameter);
    }

    @Override
    public <IV, P> IV injectIntoWith(IV injectValue, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        return IterableIterate.injectIntoWith(injectValue, this, function, parameter);
    }

    @Override
    public boolean addAllIterable(Iterable<? extends T> iterable) {
        int oldSize = this.size();
        if (iterable instanceof List && iterable instanceof RandomAccess) {
            List list = (List)iterable;
            int size2 = list.size();
            for (int i = 0; i < size2; ++i) {
                this.add((T)list.get(i));
            }
        } else {
            Iterate.forEachWith(iterable, Procedures2.addToCollection(), this);
        }
        return oldSize != this.size();
    }

    @Override
    public boolean removeAllIterable(Iterable<?> iterable) {
        return this.removeAll(CollectionAdapter.wrapSet(iterable));
    }

    @Override
    public boolean retainAllIterable(Iterable<?> iterable) {
        return this.retainAll(CollectionAdapter.wrapSet(iterable));
    }

    @Override
    public RichIterable<RichIterable<T>> chunk(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        Iterator iterator2 = this.iterator();
        MutableList<RichIterable<T>> result = Lists.mutable.empty();
        while (iterator2.hasNext()) {
            MutableCollection batch = this.newEmpty();
            for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
                batch.add(iterator2.next());
            }
            result.add(batch);
        }
        return result;
    }

    @Override
    public <K, V> MutableMap<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        UnifiedMap map2 = UnifiedMap.newMap();
        this.forEach(new MutatingAggregationProcedure<T, K, V>(map2, groupBy, zeroValueFactory, mutatingAggregator));
        return map2;
    }

    @Override
    public <K, V> MutableMap<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        UnifiedMap map2 = UnifiedMap.newMap();
        this.forEach(new NonMutatingAggregationProcedure<T, K, V>(map2, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map2;
    }

    @Override
    public boolean add(T element) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean remove(Object o) {
        Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (!Comparators.nullSafeEquals(o, iterator2.next())) continue;
            iterator2.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> source) {
        return this.addAllIterable(source);
    }

    @Override
    public boolean removeAll(Collection<?> source) {
        return this.removeAllIterable(source);
    }

    @Override
    public boolean retainAll(Collection<?> source) {
        int oldSize = this.size();
        Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (source.contains(iterator2.next())) continue;
            iterator2.remove();
        }
        return this.size() != oldSize;
    }

    @Override
    public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return Iterate.groupByUniqueKey(this, function);
    }
}

