/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel.bag;

import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.impl.block.procedure.IfProcedure;
import org.eclipse.collections.impl.lazy.parallel.AbstractBatch;
import org.eclipse.collections.impl.lazy.parallel.bag.CollectUnsortedBagBatch;
import org.eclipse.collections.impl.lazy.parallel.bag.FlatCollectUnsortedBagBatch;
import org.eclipse.collections.impl.lazy.parallel.bag.UnsortedBagBatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class SelectUnsortedBagBatch<T>
extends AbstractBatch<T>
implements UnsortedBagBatch<T> {
    private final UnsortedBagBatch<T> unsortedBagBatch;
    private final Predicate<? super T> predicate;

    public SelectUnsortedBagBatch(UnsortedBagBatch<T> unsortedBagBatch, Predicate<? super T> predicate) {
        this.unsortedBagBatch = unsortedBagBatch;
        this.predicate = predicate;
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        this.unsortedBagBatch.forEach(new IfProcedure<T>(this.predicate, procedure));
    }

    @Override
    public void forEachWithOccurrences(ObjectIntProcedure<? super T> procedure) {
        this.unsortedBagBatch.forEachWithOccurrences(new IfProcedureWithOccurrences(this.predicate, procedure));
    }

    @Override
    public UnsortedBagBatch<T> select(Predicate<? super T> predicate) {
        return new SelectUnsortedBagBatch<T>(this, predicate);
    }

    @Override
    public <V> UnsortedBagBatch<V> collect(Function<? super T, ? extends V> function) {
        return new CollectUnsortedBagBatch<T, V>(this, function);
    }

    @Override
    public <V> UnsortedBagBatch<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return new FlatCollectUnsortedBagBatch(this, function);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IfProcedureWithOccurrences<T>
    implements ObjectIntProcedure<T> {
        private final Predicate<? super T> predicate;
        private final ObjectIntProcedure<? super T> procedure;

        private IfProcedureWithOccurrences(Predicate<? super T> predicate, ObjectIntProcedure<? super T> procedure) {
            this.predicate = predicate;
            this.procedure = procedure;
        }

        @Override
        public void value(T each2, int parameter) {
            if (this.predicate.accept(each2)) {
                this.procedure.value(each2, parameter);
            }
        }
    }
}

