/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel.list;

import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.IfProcedure;
import org.eclipse.collections.impl.lazy.parallel.list.AbstractParallelListIterable;
import org.eclipse.collections.impl.lazy.parallel.list.ListBatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
class ParallelSelectListIterable<T>
extends AbstractParallelListIterable<T, ListBatch<T>> {
    private final AbstractParallelListIterable<T, ? extends ListBatch<T>> parallelIterable;
    private final Predicate<? super T> predicate;

    ParallelSelectListIterable(AbstractParallelListIterable<T, ? extends ListBatch<T>> parallelIterable, Predicate<? super T> predicate) {
        this.parallelIterable = parallelIterable;
        this.predicate = predicate;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.parallelIterable.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.parallelIterable.getBatchSize();
    }

    @Override
    public LazyIterable<ListBatch<T>> split() {
        return this.parallelIterable.split().collect(new Function<ListBatch<T>, ListBatch<T>>(){

            @Override
            public ListBatch<T> valueOf(ListBatch<T> eachBatch) {
                return eachBatch.select(ParallelSelectListIterable.this.predicate);
            }
        });
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        this.parallelIterable.forEach(new IfProcedure<T>(this.predicate, procedure));
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return this.parallelIterable.anySatisfy(Predicates.and(this.predicate, predicate));
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return this.parallelIterable.allSatisfy(new SelectAllSatisfyPredicate(this.predicate, predicate));
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return this.parallelIterable.detect(Predicates.and(this.predicate, predicate));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SelectAllSatisfyPredicate<T>
    implements Predicate<T> {
        private final Predicate<? super T> left;
        private final Predicate<? super T> right;

        private SelectAllSatisfyPredicate(Predicate<? super T> left, Predicate<? super T> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean accept(T each2) {
            boolean leftResult = this.left.accept(each2);
            return !leftResult || this.right.accept(each2);
        }
    }
}

