/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.Arrays;
import java.util.Iterator;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyLongIterable;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class CollectLongIterable<T>
extends AbstractLazyLongIterable {
    private final LazyIterable<T> iterable;
    private final LongFunction<? super T> function;
    private final LongFunctionToProcedure<T> longFunctionToProcedure;

    public CollectLongIterable(LazyIterable<T> adapted, LongFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.longFunctionToProcedure = new LongFunctionToProcedure(function);
    }

    @Override
    public LongIterator longIterator() {
        return new LongIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectLongIterable.this.iterable.iterator();
            }

            public long next() {
                return CollectLongIterable.this.function.longValueOf(this.iterator.next());
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    @Override
    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(LongProcedure procedure) {
        this.iterable.forEachWith(this.longFunctionToProcedure, procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(final LongPredicate predicate) {
        return this.iterable.count(new Predicate<T>(){

            @Override
            public boolean accept(T each2) {
                return predicate.accept(CollectLongIterable.this.function.longValueOf(each2));
            }
        });
    }

    @Override
    public boolean anySatisfy(final LongPredicate predicate) {
        return this.iterable.anySatisfy(new Predicate<T>(){

            @Override
            public boolean accept(T each2) {
                return predicate.accept(CollectLongIterable.this.function.longValueOf(each2));
            }
        });
    }

    @Override
    public boolean allSatisfy(final LongPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            @Override
            public boolean accept(T each2) {
                return predicate.accept(CollectLongIterable.this.function.longValueOf(each2));
            }
        });
    }

    @Override
    public boolean noneSatisfy(final LongPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            @Override
            public boolean accept(T each2) {
                return !predicate.accept(CollectLongIterable.this.function.longValueOf(each2));
            }
        });
    }

    @Override
    public long[] toArray() {
        final long[] array = new long[this.size()];
        this.iterable.forEachWithIndex(new ObjectIntProcedure<T>(){

            @Override
            public void value(T each2, int index) {
                array[index] = CollectLongIterable.this.function.longValueOf(each2);
            }
        });
        return array;
    }

    @Override
    public long[] toSortedArray() {
        long[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableLongList toList() {
        return LongArrayList.newList(this);
    }

    @Override
    public MutableLongSet toSet() {
        return LongHashSet.newSet(this);
    }

    @Override
    public MutableLongBag toBag() {
        return LongHashBag.newBag(this);
    }

    @Override
    public boolean containsAll(long ... source) {
        for (long value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(LongIterable source) {
        LongIterator iterator2 = source.longIterator();
        while (iterator2.hasNext()) {
            if (this.contains(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LongFunctionToProcedure<T>
    implements Procedure2<T, LongProcedure> {
        private static final long serialVersionUID = 1L;
        private final LongFunction<? super T> function;

        private LongFunctionToProcedure(LongFunction<? super T> function) {
            this.function = function;
        }

        @Override
        public void value(T each2, LongProcedure procedure) {
            procedure.value(this.function.longValueOf(each2));
        }
    }
}

