/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.sorted.immutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;
import org.eclipse.collections.api.set.sorted.ImmutableSortedSet;
import org.eclipse.collections.impl.block.procedure.checked.CheckedProcedure;
import org.eclipse.collections.impl.set.sorted.mutable.TreeSortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImmutableSortedSetSerializationProxy<T>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ImmutableSortedSet<T> set;

    public ImmutableSortedSetSerializationProxy() {
    }

    ImmutableSortedSetSerializationProxy(ImmutableSortedSet<T> set) {
        this.set = set;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeObject(this.set.comparator());
        out.writeInt(this.set.size());
        try {
            this.set.forEach(new CheckedProcedure<T>(){

                @Override
                public void safeValue(T each2) throws IOException {
                    out.writeObject(each2);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Comparator comparator = (Comparator)in.readObject();
        int size2 = in.readInt();
        TreeSortedSet deserializedSet = new TreeSortedSet(comparator);
        for (int i = 0; i < size2; ++i) {
            deserializedSet.add(in.readObject());
        }
        this.set = deserializedSet.toImmutable();
    }

    protected Object readResolve() {
        return this.set.toImmutable();
    }
}

