/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableIntStack;
import org.eclipse.collections.api.stack.primitive.IntStack;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedIntProcedure;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.IntStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableIntArrayStack
implements ImmutableIntStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IntArrayList delegate;

    private ImmutableIntArrayStack(int[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = new IntArrayList(newElements);
    }

    private ImmutableIntArrayStack(IntArrayList newElements) {
        this.checkOptimizedSize(newElements.size());
        this.delegate = newElements;
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use IntStacks.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableIntArrayStack newStack(IntIterable iterable) {
        return new ImmutableIntArrayStack(iterable.toArray());
    }

    public static ImmutableIntArrayStack newStackWith(int ... elements) {
        int[] newArray = new int[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableIntArrayStack(newArray);
    }

    public static ImmutableIntArrayStack newStackFromTopToBottom(int ... items) {
        return new ImmutableIntArrayStack(IntArrayList.newListWith(items).reverseThis());
    }

    public static ImmutableIntArrayStack newStackFromTopToBottom(IntIterable items) {
        return new ImmutableIntArrayStack(IntArrayList.newList(items).reverseThis());
    }

    @Override
    public ImmutableIntStack push(int item) {
        IntArrayList newDelegate = IntArrayList.newList(this.delegate);
        newDelegate.add(item);
        return new ImmutableIntArrayStack(newDelegate);
    }

    @Override
    public ImmutableIntStack pop() {
        IntArrayList newDelegate = IntArrayList.newList(this.delegate);
        newDelegate.removeAtIndex(this.delegate.size() - 1);
        return IntStacks.immutable.with(newDelegate.toArray());
    }

    @Override
    public ImmutableIntStack pop(int count2) {
        this.checkNegativeCount(count2);
        if (count2 == 0) {
            return this;
        }
        this.checkSizeLessThanCount(count2);
        IntArrayList newDelegate = IntArrayList.newList(this.delegate);
        while (count2 > 0) {
            newDelegate.removeAtIndex(newDelegate.size() - 1);
            --count2;
        }
        return IntStacks.immutable.with(newDelegate.toArray());
    }

    private void checkNegativeCount(int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count2);
        }
    }

    @Override
    public int peek() {
        return this.delegate.getLast();
    }

    @Override
    public IntList peek(int count2) {
        this.checkNegativeCount(count2);
        this.checkSizeLessThanCount(count2);
        if (count2 == 0) {
            return new IntArrayList();
        }
        IntArrayList subList = new IntArrayList(count2);
        int index = this.delegate.size() - 1;
        for (int i = 0; i < count2; ++i) {
            subList.add(this.delegate.get(index - i));
        }
        return subList;
    }

    @Override
    public int peekAt(int index) {
        this.rangeCheck(index);
        return this.delegate.get(this.delegate.size() - 1 - index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.delegate.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.delegate.size() - 1));
        }
    }

    @Override
    public IntIterator intIterator() {
        return new UnmodifiableIntIterator(this.delegate.asReversed().intIterator());
    }

    @Override
    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(IntProcedure procedure) {
        this.delegate.asReversed().forEach(procedure);
    }

    @Override
    public int count(IntPredicate predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    @Override
    public ImmutableIntStack select(IntPredicate predicate) {
        return IntStacks.immutable.withAllReversed(this.delegate.asReversed().select(predicate));
    }

    @Override
    public ImmutableIntStack reject(IntPredicate predicate) {
        return IntStacks.immutable.withAllReversed(this.delegate.asReversed().reject(predicate));
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.delegate.asReversed().detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableStack<V> collect(IntToObjectFunction<? extends V> function) {
        return Stacks.immutable.withAllReversed(this.delegate.asReversed().collect(function));
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public int max() {
        return this.delegate.max();
    }

    @Override
    public int maxIfEmpty(int defaultValue) {
        return this.max();
    }

    @Override
    public int min() {
        return this.delegate.min();
    }

    @Override
    public int minIfEmpty(int defaultValue) {
        return this.min();
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public int[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableIntList toSortedList() {
        return IntArrayList.newList(this).sortThis();
    }

    @Override
    public int[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    @Override
    public boolean contains(int value) {
        return this.delegate.asReversed().contains(value);
    }

    @Override
    public boolean containsAll(int ... source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public boolean containsAll(IntIterable source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public MutableIntList toList() {
        return IntArrayList.newList(this);
    }

    @Override
    public MutableIntSet toSet() {
        return IntHashSet.newSet(this);
    }

    @Override
    public MutableIntBag toBag() {
        return IntHashBag.newBag(this);
    }

    public <V> V injectInto(V injectedValue, ObjectIntToObjectFunction<? super V, ? extends V> function) {
        return this.delegate.toReversed().injectInto(injectedValue, function);
    }

    @Override
    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter(this);
    }

    @Override
    public ImmutableIntStack toImmutable() {
        return this;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof IntStack)) {
            return false;
        }
        IntStack stack = (IntStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.peekAt(i) == stack.peekAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode2 = 1;
        LazyIntIterable iterable = this.delegate.asReversed();
        IntIterator iterator2 = iterable.intIterator();
        while (iterator2.hasNext()) {
            int item = iterator2.next();
            hashCode2 = 31 * hashCode2 + item;
        }
        return hashCode2;
    }

    @Override
    public String toString() {
        return this.delegate.asReversed().toString();
    }

    @Override
    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    private void checkSizeLessThanCount(int count2) {
        if (this.delegate.size() < count2) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count2 + " Size = " + this.delegate.size());
        }
    }

    private Object writeReplace() {
        return new ImmutableIntStackSerializationProxy(this);
    }

    private static class ImmutableIntStackSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private IntStack stack;

        public ImmutableIntStackSerializationProxy() {
        }

        protected ImmutableIntStackSerializationProxy(IntStack stack) {
            this.stack = stack;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.stack.size());
            try {
                this.stack.forEach(new CheckedIntProcedure(){

                    public void safeValue(int item) throws IOException {
                        out.writeInt(item);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size2 = in.readInt();
            IntArrayList deserializedDelegate = new IntArrayList(size2);
            for (int i = 0; i < size2; ++i) {
                deserializedDelegate.add(in.readInt());
            }
            this.stack = ImmutableIntArrayStack.newStackFromTopToBottom(deserializedDelegate);
        }

        protected Object readResolve() {
            return this.stack;
        }
    }
}

