/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.lang.reflect.Array;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializerObjectArray;
import org.mapdb.serializer.SerializerUtils;

public class SerializerArray<T>
extends GroupSerializerObjectArray<T[]> {
    private static final long serialVersionUID = -982394293898234253L;
    protected final Serializer<T> serializer;
    protected final Class<T> componentType;

    public SerializerArray(Serializer<T> serializer) {
        this(serializer, null);
    }

    public SerializerArray(Serializer<T> serializer, Class<T> componentType) {
        if (serializer == null) {
            throw new NullPointerException("null serializer");
        }
        this.serializer = serializer;
        this.componentType = componentType != null ? componentType : Object.class;
    }

    @Override
    public void serialize(DataOutput2 out, T[] value) throws IOException {
        out.packInt(value.length);
        for (T a : value) {
            this.serializer.serialize(out, a);
        }
    }

    @Override
    public T[] deserialize(DataInput2 in, int available) throws IOException {
        Object[] ret2 = (Object[])Array.newInstance(this.componentType, in.unpackInt());
        for (int i = 0; i < ret2.length; ++i) {
            ret2[i] = this.serializer.deserialize(in, -1);
        }
        return ret2;
    }

    @Override
    public boolean isTrusted() {
        return this.serializer.isTrusted();
    }

    @Override
    public boolean equals(T[] a1, T[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (this.serializer.equals(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode(T[] objects, int seed) {
        seed += objects.length;
        for (T a : objects) {
            seed = -1640531527 * seed + this.serializer.hashCode(a, seed);
        }
        return seed;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.serializer.equals(((SerializerArray)o).serializer);
    }

    public int hashCode() {
        return this.serializer.hashCode();
    }

    @Override
    public int compare(Object[] o1, Object[] o2) {
        int len = Math.min(o1.length, o2.length);
        for (int i = 0; i < len; ++i) {
            Object a1 = o1[i];
            Object a2 = o2[i];
            int r = a1 == a2 ? 0 : (a1 == null ? 1 : (a2 == null ? -1 : this.serializer.compare((T)a1, (T)a2)));
            if (r == 0) continue;
            return r;
        }
        return SerializerUtils.compareInt(o1.length, o2.length);
    }
}

