/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.mapdb.serializer.SerializerArray;

public class SerializerArrayDelta<T>
extends SerializerArray<T> {
    private static final long serialVersionUID = -930920902390439234L;

    public SerializerArrayDelta(Serializer<T> serializer) {
        super(serializer);
    }

    @Override
    public void valueArraySerialize(DataOutput2 out, Object vals2) throws IOException {
        Object[] vals = (Object[])vals2;
        if (vals.length == 0) {
            return;
        }
        Object[] prevKey = (Object[])vals[0];
        out.packInt(prevKey.length);
        for (Object key : prevKey) {
            this.serializer.serialize(out, key);
        }
        for (int i = 1; i < vals.length; ++i) {
            int pos;
            Object[] key = (Object[])vals[i];
            int len = Math.min(key.length, prevKey.length);
            for (pos = 0; pos < len && (key[pos] == prevKey[pos] || this.serializer.equals(key[pos], prevKey[pos])); ++pos) {
            }
            out.packInt(pos);
            out.packInt(key.length - pos);
            while (pos < key.length) {
                this.serializer.serialize(out, key[pos]);
                ++pos;
            }
            prevKey = key;
        }
    }

    @Override
    public Object[] valueArrayDeserialize(DataInput2 in, int size2) throws IOException {
        int i;
        Object[] ret2 = new Object[size2];
        if (size2 == 0) {
            return ret2;
        }
        int ss = in.unpackInt();
        Object[] prevKey = new Object[ss];
        for (i = 0; i < ss; ++i) {
            prevKey[i] = this.serializer.deserialize(in, -1);
        }
        ret2[0] = prevKey;
        for (i = 1; i < size2; ++i) {
            int shared;
            int unq = in.unpackInt();
            Object[] key = new Object[shared + unq];
            System.arraycopy(prevKey, 0, key, 0, shared);
            for (shared = in.unpackInt(); shared < key.length; ++shared) {
                key[shared] = this.serializer.deserialize(in, -1);
            }
            ret2[i] = key;
            prevKey = key;
        }
        return ret2;
    }
}

