/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.volume;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.volume.ByteBufferVol;
import org.mapdb.volume.FileChannelVol;
import org.mapdb.volume.MappedFileVolSingle;
import org.mapdb.volume.RandomAccessFileVol;
import org.mapdb.volume.Volume;
import org.mapdb.volume.VolumeFactory;

public final class MappedFileVol
extends ByteBufferVol {
    public static final VolumeFactory FACTORY = new MappedFileFactory(false, false);
    protected final File file;
    protected final FileChannel fileChannel;
    protected final FileChannel.MapMode mapMode;
    protected final RandomAccessFile raf;
    protected final FileLock fileLock;
    protected final boolean preclearDisabled;

    public MappedFileVol(File file, boolean readOnly, long fileLockWait, int sliceShift, boolean cleanerHackEnabled, long initSize, boolean preclearDisabled) {
        super(readOnly, sliceShift, cleanerHackEnabled);
        this.file = file;
        this.mapMode = readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
        this.preclearDisabled = preclearDisabled;
        try {
            long fileSize;
            FileChannelVol.checkFolder(file, readOnly);
            this.raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
            this.fileChannel = this.raf.getChannel();
            this.fileLock = Volume.lockFile(file, this.fileChannel, readOnly, fileLockWait);
            long endSize = fileSize = this.fileChannel.size();
            if (initSize > fileSize && !readOnly) {
                endSize = initSize;
            }
            if (endSize > 0L) {
                int chunksSize = (int)(DataIO.roundUp(endSize, (long)this.sliceSize) >>> sliceShift);
                if (endSize > fileSize && !readOnly) {
                    RandomAccessFileVol.clearRAF(this.raf, fileSize, endSize);
                }
                this.slices = new ByteBuffer[chunksSize];
                for (int i = 0; i < this.slices.length; ++i) {
                    MappedByteBuffer b = this.fileChannel.map(this.mapMode, 1L * (long)this.sliceSize * (long)i, this.sliceSize);
                    if (b.order() != ByteOrder.BIG_ENDIAN) {
                        throw new AssertionError((Object)"Little-endian");
                    }
                    this.slices[i] = b;
                }
            } else {
                this.slices = new ByteBuffer[0];
            }
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public final void ensureAvailable(long offset) {
        int slicePos = (int)((offset = DataIO.roundUp(offset, 1L << this.sliceShift)) >>> this.sliceShift);
        if (slicePos < this.slices.length) {
            return;
        }
        this.growLock.lock();
        try {
            if (slicePos <= this.slices.length) {
                return;
            }
            int oldSize = this.slices.length;
            if (!this.preclearDisabled) {
                RandomAccessFileVol.clearRAF(this.raf, 1L * (long)oldSize * (long)this.sliceSize, offset);
            }
            ByteBuffer[] slices2 = this.slices;
            slices2 = Arrays.copyOf(slices2, slicePos);
            for (int pos = oldSize; pos < slices2.length; ++pos) {
                MappedByteBuffer b = this.fileChannel.map(this.mapMode, 1L * (long)this.sliceSize * (long)pos, this.sliceSize);
                if (b.order() != ByteOrder.BIG_ENDIAN) {
                    throw new AssertionError((Object)"Little-endian");
                }
                slices2[pos] = b;
            }
            this.slices = slices2;
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
        finally {
            this.growLock.unlock();
        }
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.growLock.lock();
        try {
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLock.release();
            }
            this.fileChannel.close();
            this.raf.close();
            if (this.cleanerHackEnabled) {
                for (ByteBuffer b : this.slices) {
                    if (b == null || !(b instanceof MappedByteBuffer)) continue;
                    MappedFileVol.unmap((MappedByteBuffer)b);
                }
            }
            Arrays.fill(this.slices, null);
            this.slices = null;
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
        finally {
            this.growLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() {
        if (this.readOnly) {
            return;
        }
        this.growLock.lock();
        try {
            ByteBuffer[] slices = this.slices;
            if (slices == null) {
                return;
            }
            for (int i = slices.length - 1; i >= 0; --i) {
                ByteBuffer b = slices[i];
                if (b == null || !(b instanceof MappedByteBuffer)) continue;
                MappedByteBuffer bb = (MappedByteBuffer)b;
                bb.force();
            }
        }
        finally {
            this.growLock.unlock();
        }
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean getFileLocked() {
        return this.fileLock != null && this.fileLock.isValid();
    }

    @Override
    public void truncate(long size2) {
        int maxSize = 1 + (int)(size2 >>> this.sliceShift);
        if (maxSize == this.slices.length) {
            return;
        }
        if (maxSize > this.slices.length) {
            this.ensureAvailable(size2);
            return;
        }
        this.growLock.lock();
        try {
            int i;
            if (maxSize >= this.slices.length) {
                return;
            }
            ByteBuffer[] old = this.slices;
            this.slices = Arrays.copyOf(this.slices, maxSize);
            for (i = maxSize; i < old.length; ++i) {
                if (this.cleanerHackEnabled) {
                    MappedFileVol.unmap((MappedByteBuffer)old[i]);
                }
                old[i] = null;
            }
            if (ByteBufferVol.windowsWorkaround) {
                for (i = 0; i < maxSize; ++i) {
                    if (this.cleanerHackEnabled) {
                        MappedFileVol.unmap((MappedByteBuffer)old[i]);
                    }
                    old[i] = null;
                }
            }
            try {
                this.fileChannel.truncate(1L * (long)this.sliceSize * (long)maxSize);
            }
            catch (IOException e) {
                throw new DBException.VolumeIOError(e);
            }
            if (ByteBufferVol.windowsWorkaround) {
                for (int pos = 0; pos < maxSize; ++pos) {
                    MappedByteBuffer b = this.fileChannel.map(this.mapMode, 1L * (long)this.sliceSize * (long)pos, this.sliceSize);
                    if (b.order() != ByteOrder.BIG_ENDIAN) {
                        throw new AssertionError((Object)"Little-endian");
                    }
                    this.slices[pos] = b;
                }
            }
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
        finally {
            this.growLock.unlock();
        }
    }

    @Override
    public boolean fileLoad() {
        ByteBuffer[] slices;
        for (ByteBuffer b : slices = this.slices) {
            if (!(b instanceof MappedByteBuffer)) continue;
            ((MappedByteBuffer)b).load();
        }
        return true;
    }

    public static class MappedFileFactory
    extends VolumeFactory {
        final boolean cleanerHackEnabled;
        final boolean preclearDisabled;

        public MappedFileFactory(boolean cleanerHackEnabled, boolean preclearDisabled) {
            this.cleanerHackEnabled = cleanerHackEnabled;
            this.preclearDisabled = preclearDisabled;
        }

        @Override
        public Volume makeVolume(String file, boolean readOnly, long fileLockWait, int sliceShift, long initSize, boolean fixedSize) {
            return MappedFileFactory.factory(file, readOnly, fileLockWait, sliceShift, this.cleanerHackEnabled, initSize, this.preclearDisabled);
        }

        @Override
        @NotNull
        public boolean exists(@Nullable String file) {
            return new File(file).exists();
        }

        @Override
        public boolean handlesReadonly() {
            return true;
        }

        private static Volume factory(String file, boolean readOnly, long fileLockWait, int sliceShift, boolean cleanerHackEnabled, long initSize, boolean preclearDisabled) {
            long flen;
            File f = new File(file);
            if (readOnly && (flen = f.length()) <= Integer.MAX_VALUE) {
                return new MappedFileVolSingle(f, readOnly, fileLockWait, Math.max(flen, initSize), cleanerHackEnabled);
            }
            return new MappedFileVol(f, readOnly, fileLockWait, sliceShift, cleanerHackEnabled, initSize, preclearDisabled);
        }
    }
}

