/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plotObjects;

import java.awt.Color;
import org.math.plot.plotObjects.Axis;
import org.math.plot.plotObjects.Base;
import org.math.plot.plotObjects.BaseDependant;
import org.math.plot.render.AbstractDrawer;

public class BasePlot
implements BaseDependant {
    public static Color DEFAULT_COLOR = Color.DARK_GRAY;
    protected Base base;
    protected Axis[] axis;
    protected boolean visible = true;
    protected Color color;

    public BasePlot(Base b, String ... as) {
        this(b, DEFAULT_COLOR, as);
    }

    public BasePlot(Base b, Color c, Axis ... a) {
        this.base = b;
        this.axis = a;
        this.color = c;
    }

    public BasePlot(Base b, Color c, String ... as) {
        this.base = b;
        if (as.length != this.base.dimension) {
            throw new IllegalArgumentException("String array of axes names must have " + this.base.dimension + " elements.");
        }
        this.color = c;
        this.axis = new Axis[this.base.dimension];
        for (int i = 0; i < this.base.dimension; ++i) {
            this.axis[i] = new Axis(this.base, as[i], this.color, i);
        }
    }

    public void setVisible(boolean v) {
        this.visible = v;
    }

    public void setVisible(int i, boolean v) {
        this.axis[i].setVisible(v);
    }

    public void setGridVisible(int i, boolean v) {
        this.axis[i].setGridVisible(v);
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setColor(Color c) {
        this.color = c;
        for (int i = 0; i < this.axis.length; ++i) {
            this.axis[i].setColor(c);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setLegend(String[] as) {
        if (as.length != this.base.dimension) {
            throw new IllegalArgumentException("String array of axes names must have " + this.base.dimension + " elements.");
        }
        for (int i = 0; i < this.axis.length; ++i) {
            this.axis[i].setLegend(as[i]);
        }
    }

    public void setLegend(int i, String as) {
        this.axis[i].setLegend(as);
    }

    public String[] getLegend() {
        String[] array = new String[this.axis.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.axis[i].getLegend();
        }
        return array;
    }

    public String getLegend(int i) {
        return this.axis[i].getLegend();
    }

    public void setBase(Base b) {
        this.base = b;
        for (int i = 0; i < this.axis.length; ++i) {
            this.axis[i].base = this.base;
        }
        this.resetBase();
    }

    public void plot(AbstractDrawer draw) {
        if (!this.visible) {
            return;
        }
        for (int i = 0; i < this.axis.length; ++i) {
            this.axis[i].plot(draw);
        }
    }

    public Axis getAxis(int i) {
        return this.axis[i];
    }

    public Axis[] getAxis() {
        return this.axis;
    }

    @Override
    public void resetBase() {
        for (int i = 0; i < this.axis.length; ++i) {
            this.axis[i].resetBase();
        }
    }
}

