/*
 * Decompiled with CFR 0.152.
 */
package spiking.controllers.node;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class NodeLink
implements Comparable<NodeLink> {
    private Integer srcNodeId;
    private Integer dstNodeId;
    private Integer srcNeuronId;
    private Integer dstNeuronId;

    public NodeLink(Integer srcNodeId, Integer srcNeuronId, Integer dstNodeId, Integer dstNeuronId) {
        this.srcNodeId = srcNodeId;
        this.srcNeuronId = srcNeuronId;
        this.dstNodeId = dstNodeId;
        this.dstNeuronId = dstNeuronId;
    }

    public String toString() {
        return "Node Link [src=" + this.srcNodeId + "-" + this.srcNeuronId + ", dst=" + this.dstNodeId + "-" + this.dstNeuronId + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        NodeLink rhs = (NodeLink)obj;
        return new EqualsBuilder().append(this.srcNodeId, rhs.srcNodeId).append(this.srcNeuronId, rhs.srcNeuronId).append(this.dstNodeId, rhs.dstNodeId).append(this.dstNeuronId, rhs.dstNeuronId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(7 * this.dstNeuronId << this.srcNodeId + this.srcNeuronId).append(this.srcNeuronId << this.dstNodeId + 3 * this.dstNeuronId).toHashCode();
    }

    @Override
    public int compareTo(NodeLink o) {
        if (this == o) {
            return 0;
        }
        int retval = this.srcNodeId.compareTo(o.getSrcNodeId());
        if (retval != 0) {
            return retval;
        }
        retval = this.srcNeuronId.compareTo(o.getSrcNeuronId());
        if (retval != 0) {
            return retval;
        }
        retval = this.dstNodeId.compareTo(o.getDstNodeId());
        if (retval != 0) {
            return retval;
        }
        retval = this.dstNeuronId.compareTo(o.getDstNeuronId());
        if (retval != 0) {
            return retval;
        }
        return retval;
    }

    public Integer getSrcNodeId() {
        return this.srcNodeId;
    }

    public Integer getDstNodeId() {
        return this.dstNodeId;
    }

    public Integer getSrcNeuronId() {
        return this.srcNeuronId;
    }

    public Integer getDstNeuronId() {
        return this.dstNeuronId;
    }
}

