/*
 * Decompiled with CFR 0.152.
 */
package spiking.node;

import spiking.controllers.node.NodeThread;
import utils.constants.Constants;
import utils.tools.IntegerCouple;

public class NodesInterconnection
extends IntegerCouple {
    public static final Integer MIXED2MIXED = 0;
    public static final Integer MIXED2EXC = 1;
    public static final Integer MIXED2INH = 2;
    public static final Integer EXC2MIXED = 3;
    public static final Integer EXC2EXC = 4;
    public static final Integer EXC2INH = 5;
    public static final Integer INH2MIXED = 6;
    public static final Integer INH2EXC = 7;
    public static final Integer INH2INH = 8;
    private Double Ne_xn_ratio;
    private Double mu_lambda = Constants.LENGTH_DEF_VAL;
    private Double mu_omega = 1.0;
    private Double sigma_omega = 0.0;
    private Double alpha_lambda = null;
    private Integer type = 0;

    public NodesInterconnection(NodeThread r1, NodeThread r2, Double Ne_xn_ratio, Double mu_omega, Double sigma_omega, Double mu_lambda, Double alpha_lambda, int type) {
        super(r1.getNodeId(), r2.getNodeId());
        this.Ne_xn_ratio = Ne_xn_ratio;
        this.mu_omega = mu_omega;
        this.sigma_omega = sigma_omega;
        this.mu_lambda = mu_lambda;
        this.sigma_omega = sigma_omega;
        this.type = type <= 8 ? type : MIXED2MIXED;
    }

    public NodesInterconnection(Integer r1, Integer r2, Double Ne_xn_ratio) {
        super(r1, r2);
        this.Ne_xn_ratio = Ne_xn_ratio;
    }

    public Double getNe_xn_ratio() {
        return this.Ne_xn_ratio;
    }

    public void setLength(Double length) {
        this.mu_lambda = length;
    }

    public Double getLength() {
        if (this.mu_lambda == null) {
            System.out.println("[NODES INTERCONNECTION WARNING] length 0 error");
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        return this.mu_lambda;
    }

    public Double getMu_omega() {
        return this.mu_omega;
    }

    public void setAmplitude(Double amplitude) {
        this.mu_omega = amplitude;
    }

    public Double getSigma_w() {
        return this.sigma_omega;
    }

    public void setAmplitudeStdDeviation(Double amplitudeStdDeviation) {
        this.sigma_omega = amplitudeStdDeviation;
    }

    public Double getLengthShapeParameter() {
        return this.alpha_lambda;
    }

    public void setLengthShapeParameter(Double lengthShapeParameter) {
        this.alpha_lambda = lengthShapeParameter;
    }

    public void setType(int type) {
        this.type = type <= 8 ? type : MIXED2MIXED;
    }

    public Integer getType() {
        return this.type;
    }
}

