/*
 * Decompiled with CFR 0.152.
 */
package spiking.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.math3.distribution.GammaDistribution;
import spiking.controllers.node.NodeThread;
import spiking.internode.InterNodeSpike;
import spiking.node.NodesInterconnection;
import spiking.simulator.SpikingNeuralSimulator;
import utils.exceptions.BadCurveException;
import utils.tools.IntegerCouple;

public class NodesManager
implements Serializable {
    public static final Double MAX_TRACT_LENGTH = 100000.0;
    private static final long serialVersionUID = -4781040115396333609L;
    private static final String TAG = "[Nodes Manager] ";
    private static final Boolean verbose = true;
    private static final Integer goodCurveGuessThreshold = 5;
    private static final Integer badCurveGuessThreshold = 15;
    private Boolean debug = false;
    private ArrayList<NodeThread> nodeThreads = new ArrayList();
    private HashMap<IntegerCouple, NodesInterconnection> nodesConnections = new HashMap();
    private Long n = 0L;
    private Long maxN = 0L;
    private double compressionFactor = 1.0;
    private Long excitatory = 0L;
    private Long inhibithory = 0L;
    private Integer externalInputs = 0;
    private ArrayList<Integer> regsWithExternalInputs = new ArrayList();
    private Long inter_node_conns_num = 0L;
    private Boolean initialized = false;
    private SpikingNeuralSimulator sim;
    private Double minTractLength = MAX_TRACT_LENGTH;
    private Random randGen = new Random(System.currentTimeMillis());
    private Double gammaInverseCumulativeProbX = 1.0;
    private Double bop_conservative_p = null;

    public NodesManager(SpikingNeuralSimulator sim, Double bop_conservative_p) {
        this.sim = sim;
        this.bop_conservative_p = bop_conservative_p;
    }

    public void addNodeThread(NodeThread regT) {
        if (this.initialized.booleanValue()) {
            return;
        }
        this.nodeThreads.add(regT);
        this.n = this.n + regT.getN();
        if (regT.getN() > this.maxN) {
            this.maxN = regT.getN();
        }
        this.println("adding node:" + regT.getNodeId() + ", n:" + regT.getN() + "\n");
        this.excitatory = this.excitatory + regT.getExcitatory();
        this.inhibithory = this.inhibithory + regT.getInhibithory();
        if (regT.hasExternalInput()) {
            this.externalInputs = this.externalInputs + regT.getExternalInputs();
            this.regsWithExternalInputs.add(regT.getNodeId());
        }
    }

    public void addInterNodeConnection(NodeThread node1, NodeThread node2, Double Ne_xn_ratio, Double mu_omega, Double sigma_omega, Double mu_lambda, Double alpha_lambda, Integer inter_node_conn_type) {
        if (mu_lambda == null) {
            this.println("length null 1...");
        }
        NodesInterconnection n_conn = new NodesInterconnection(node1, node2, Ne_xn_ratio, mu_omega, sigma_omega, mu_lambda, alpha_lambda, inter_node_conn_type);
        this.nodesConnections.put(new IntegerCouple(node1.getNodeId(), node2.getNodeId()), n_conn);
        this._addInterNodeConnection(node1.getNodeId(), node2.getNodeId(), Ne_xn_ratio, mu_omega, sigma_omega, mu_lambda, alpha_lambda, inter_node_conn_type);
    }

    public void addInterNodeConnectionParameters(Integer reg1Id, Integer reg2Id, Double weight, Double amplitude, Double amplitudeStdVariation, Double length, Double lengthShapeParameter, Integer inter_node_conn_type) {
        if (length == null) {
            this.println("length null 2...");
        }
        NodesInterconnection regi = new NodesInterconnection(reg1Id, reg2Id, weight);
        regi.setLength(length);
        this.nodesConnections.put(new IntegerCouple(reg1Id, reg2Id), regi);
        this._addInterNodeConnection(reg1Id, reg2Id, weight, amplitude, amplitudeStdVariation, length, lengthShapeParameter, inter_node_conn_type);
    }

    private void _addInterNodeConnection(Integer node1id, Integer node2id, Double weight, Double amplitude, Double amplitudeStdVariation, Double length, Double lengthShapeParameter, Integer inter_node_conn_type) {
        if (length == null) {
            this.println("length null...");
        }
        if (this.minTractLength == null) {
            this.println("min tract length null...");
        }
        if (length < this.minTractLength) {
            this.minTractLength = length;
        }
        try {
            this.__addInterNodeConnection(node1id, node2id, weight, amplitude, amplitudeStdVariation, length, lengthShapeParameter, inter_node_conn_type);
        }
        catch (BadCurveException e) {
            e.printStackTrace();
        }
    }

    private void __addInterNodeConnection(Integer reg1Id, Integer reg2Id, Double Ne_xn_ratio, Double mu_omega, Double sigma_omega, Double mu_lambda, Double alpha_lambda, Integer inter_node_conn_type) throws BadCurveException {
        long Nsrc = 0L;
        Nsrc = inter_node_conn_type == NodesInterconnection.EXC2MIXED || inter_node_conn_type == NodesInterconnection.EXC2EXC || inter_node_conn_type == NodesInterconnection.EXC2INH ? this.nodeThreads.get(reg1Id).getExcitatory() : (inter_node_conn_type == NodesInterconnection.INH2MIXED || inter_node_conn_type == NodesInterconnection.INH2EXC || inter_node_conn_type == NodesInterconnection.INH2INH ? this.nodeThreads.get(reg1Id).getInhibithory().longValue() : this.nodeThreads.get(reg1Id).getN().longValue());
        long tmp = (long)((double)Nsrc * Ne_xn_ratio);
        GammaDistribution gd = alpha_lambda != null ? new GammaDistribution(alpha_lambda, mu_lambda / alpha_lambda) : null;
        this.gammaInverseCumulativeProbX = alpha_lambda != null && this.bop_conservative_p != null ? gd.inverseCumulativeProbability(1.0 - this.bop_conservative_p) : 1.0;
        for (long i = 0L; i < tmp; ++i) {
            int goodCurveGuess;
            Long i1 = inter_node_conn_type == NodesInterconnection.EXC2MIXED || inter_node_conn_type == NodesInterconnection.EXC2EXC || inter_node_conn_type == NodesInterconnection.EXC2INH ? Long.valueOf((long)(Math.random() * (double)this.nodeThreads.get(reg1Id).getExcitatory().longValue())) : (inter_node_conn_type == NodesInterconnection.INH2MIXED || inter_node_conn_type == NodesInterconnection.INH2EXC || inter_node_conn_type == NodesInterconnection.INH2INH ? Long.valueOf(this.nodeThreads.get(reg1Id).getExcitatory() + (long)(Math.random() * (double)this.nodeThreads.get(reg1Id).getInhibithory().longValue())) : Long.valueOf((long)(Math.random() * (double)this.nodeThreads.get(reg1Id).getN().longValue())));
            Long i2 = inter_node_conn_type == NodesInterconnection.MIXED2EXC || inter_node_conn_type == NodesInterconnection.EXC2EXC || inter_node_conn_type == NodesInterconnection.INH2EXC ? Long.valueOf((long)(Math.random() * (double)this.nodeThreads.get(reg2Id).getExcitatory().longValue())) : (inter_node_conn_type == NodesInterconnection.MIXED2INH || inter_node_conn_type == NodesInterconnection.EXC2INH || inter_node_conn_type == NodesInterconnection.INH2INH ? Long.valueOf(this.nodeThreads.get(reg2Id).getExcitatory() + (long)(Math.random() * (double)this.nodeThreads.get(reg2Id).getInhibithory().longValue())) : Long.valueOf((long)(Math.random() * (double)this.nodeThreads.get(reg2Id).getN().longValue())));
            Double tmpLength = -1.0;
            Double tmp_mu_w = sigma_omega != null ? Math.abs(this.randGen.nextGaussian() * sigma_omega + mu_omega) : mu_omega;
            if (mu_omega < 0.0 && tmp_mu_w > 0.0) {
                tmp_mu_w = -tmp_mu_w.doubleValue();
            }
            for (goodCurveGuess = 0; tmpLength < 0.0 && goodCurveGuess < badCurveGuessThreshold; ++goodCurveGuess) {
                tmpLength = gd != null ? gd.sample() : mu_lambda.doubleValue();
            }
            if (goodCurveGuess >= goodCurveGuessThreshold) {
                this.sim.setBadCurve();
                if (goodCurveGuess >= badCurveGuessThreshold) {
                    throw new BadCurveException("the gamma curve G(" + alpha_lambda + ", " + alpha_lambda / mu_lambda + " has a shape which is not compliant with firnet scope.");
                }
            }
            this.nodeThreads.get(reg1Id).addInterNodeSynapse(reg1Id, i1, reg2Id, i2, this.nodeThreads.get(reg1Id).getExcitatoryPresynapticWeight(), tmp_mu_w, tmpLength);
            this.nodeThreads.get(reg2Id).addInterNodeSynapse(reg1Id, i1, reg2Id, i2, this.nodeThreads.get(reg1Id).getExcitatoryPresynapticWeight(), tmp_mu_w, tmpLength);
            this.inter_node_conns_num = this.inter_node_conns_num + 1L;
        }
    }

    public Long getTotalN() {
        return this.n;
    }

    public double getCompressionFactor() {
        return this.compressionFactor;
    }

    public void setCompressionFactor(double compressionFactor) {
        this.compressionFactor = compressionFactor;
    }

    public int getNodeThreadsNum() {
        return this.nodeThreads.size();
    }

    public Boolean getInitialized() {
        return this.initialized;
    }

    public Double getMinTractLength() {
        return this.gammaInverseCumulativeProbX == 1.0 ? this.minTractLength : this.gammaInverseCumulativeProbX;
    }

    public Double getGammaInverseCumulativeProbX() {
        return this.gammaInverseCumulativeProbX;
    }

    public Integer getnSms() {
        return this.nodeThreads.size();
    }

    public NodeThread getNodeThread(int index) {
        return this.nodeThreads.get(index);
    }

    public long getMaxN() {
        return this.maxN;
    }

    public Long getTotalInterNodeConnectionsNumber() {
        return this.inter_node_conns_num;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    private void println(String s) {
        if (verbose.booleanValue()) {
            System.out.println(TAG + s);
        }
    }

    private void debprintln(String s) {
        if (verbose.booleanValue() && this.debug.booleanValue()) {
            System.out.println("[Nodes Manager] [debug] " + s);
        }
    }

    public void printNodeFields() {
        this.println("n:\t\t" + this.n);
        this.println("excitatory:\t" + this.excitatory);
        this.println("inhibithory:\t" + this.inhibithory);
        this.println("external inputs:\t" + this.externalInputs);
    }

    public void startAll() {
        for (int i = 0; i < this.nodeThreads.size(); ++i) {
            this.nodeThreads.get(i).start();
        }
    }

    public void runNewSplit(double newStopTime) {
        this.updateInterNodeSpikes();
        for (int i = 0; i < this.nodeThreads.size(); ++i) {
            this.nodeThreads.get(i).runNewSplit(newStopTime);
        }
    }

    public void killAll() {
        for (int i = 0; i < this.nodeThreads.size(); ++i) {
            this.nodeThreads.get(i).kill();
        }
    }

    public synchronized Boolean splitComplete(Integer nodeId) {
        return this.sim.splitComplete(nodeId);
    }

    private void updateInterNodeSpikes() {
        for (int i = 0; i < this.nodeThreads.size(); ++i) {
            ArrayList<InterNodeSpike> tmpInterNodeSpikes = this.nodeThreads.get(i).pullInternodeFires();
            for (int j = 0; j < tmpInterNodeSpikes.size(); ++j) {
                this.deliverInterNodeSpike(tmpInterNodeSpikes.get(j));
            }
        }
    }

    private void deliverInterNodeSpike(InterNodeSpike irs) {
        this.nodeThreads.get(irs.getSyn().getBurningNodeId()).burnInterNodeSpike(irs);
    }
}

