/*
 * Decompiled with CFR 0.152.
 */
package spiking.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.math3.distribution.GammaDistribution;
import spiking.node.Node;
import spiking.node.Synapse;
import utils.tools.LongCouple;

public class SynapsesManager {
    private static final String TAG = "[Syapses Manager ";
    private static final Boolean verbose = true;
    private Node n;
    private HashMap<Synapse, Double> axmap;
    private HashMap<Synapse, Synapse> synapses;
    private HashMap<Long, ArrayList<Synapse>> firingNeuronSynapses;
    private HashMap<Long, ArrayList<Synapse>> burningNeuronSynapses;
    private HashMap<Long, ArrayList<Synapse>> firingNeuronInterNodeSynapses;
    private HashMap<Long, ArrayList<Synapse>> burningNeuronInterNodeConnections;
    public Double alpha = 1000000.0;
    public Double madel = 8.0;
    public Double beta = this.madel / this.alpha;
    private GammaDistribution gd;
    private Double minAxDelay = Double.MAX_VALUE;
    private Double avgNeuronalSignalSpeed;
    private Random randGen = new Random(System.currentTimeMillis());

    public SynapsesManager(Node n, Double avgNeuronalSignalSpeed) {
        this.n = n;
        this.gd = new GammaDistribution(this.alpha, this.beta);
        this.axmap = new HashMap();
        this.synapses = new HashMap();
        this.firingNeuronSynapses = new HashMap();
        if (n.getPlasticity().booleanValue()) {
            this.burningNeuronSynapses = new HashMap();
        }
        this.firingNeuronInterNodeSynapses = new HashMap();
        this.burningNeuronInterNodeConnections = new HashMap();
        this.avgNeuronalSignalSpeed = avgNeuronalSignalSpeed;
        this.init();
    }

    private void init() {
        Iterator<LongCouple> it = this.n.getKeyConnectionIterator();
        Double tmp_presynaptic_w = null;
        while (it.hasNext()) {
            LongCouple tmpCouple = it.next();
            tmp_presynaptic_w = this.n.getConnectionPresynapticWeight(tmpCouple.getFiring(), tmpCouple.getBurning());
            if (tmp_presynaptic_w == null) continue;
            double postSynW = Math.abs(this.randGen.nextGaussian() * this.n.getSigma_w_agnostic(tmpCouple.getBurning()) + this.n.getMu_w_agnostic(tmpCouple.getBurning()));
            if (this.n.getMu_w_agnostic(tmpCouple.getBurning()) < 0.0) {
                postSynW = -postSynW;
            }
            if (tmp_presynaptic_w == null) continue;
            this.setIntraNodeSynapse(new Synapse(this.n.getId(), tmpCouple.getFiring(), this.n.getId(), tmpCouple.getBurning(), 0.0, postSynW, tmp_presynaptic_w, false, false));
        }
    }

    public void setIntraNodeSynapse(Synapse syn) {
        if (syn.getAxonNodeId().equals(this.n.getId())) {
            this.putFiringIntraNodeSynapse(syn);
        }
        if (syn.getBurningNodeId().equals(this.n.getId())) {
            this.putBurningIntraNodeSynapse(syn);
        }
        if (syn.getAxonNodeId().equals(this.n.getId()) && syn.getBurningNodeId().equals(this.n.getId())) {
            this.synapses.put(syn, syn);
        } else {
            System.out.println("[SYNAPSES MANAGER SETPOSTSYNAPTICWEIGHT WARNING] adding an internode synapse as intranode");
        }
    }

    public void setIntraNodePostSynapticWeight(Synapse syn, Double postsynaptic_w) {
        Synapse s = this.synapses.get(syn);
        if (s != null) {
            s.setPostsynapticWeight(postsynaptic_w);
        }
    }

    public void setInterNodeSynapse(Synapse syn) {
        Synapse s = this.synapses.get(syn);
        if (s == null) {
            this.synapses.put(syn, syn);
        }
    }

    private void putFiringIntraNodeSynapse(Synapse firingNeuronSynapse) {
        if (this.firingNeuronSynapses.size() >= Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException("You are triyng to add to much internode connection to the same neuron:" + firingNeuronSynapse.getFiring() + "of the node:" + this.n.getId());
        }
        ArrayList<Synapse> list = this.firingNeuronSynapses.get(firingNeuronSynapse.getFiring());
        if (list == null) {
            this.firingNeuronSynapses.put(firingNeuronSynapse.getFiring(), new ArrayList());
            list = this.firingNeuronSynapses.get(firingNeuronSynapse.getFiring());
        }
        list.add(firingNeuronSynapse);
    }

    private void putBurningIntraNodeSynapse(Synapse burningNeuronSynapse) {
        if (!this.n.getPlasticity().booleanValue()) {
            return;
        }
        if (this.burningNeuronSynapses.size() >= Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException("You are triyng to add to much internode connection to the same neuron:" + burningNeuronSynapse.getBurning() + "of the region:" + this.n.getId());
        }
        ArrayList<Synapse> list = this.burningNeuronSynapses.get(burningNeuronSynapse.getBurning());
        if (list == null) {
            this.burningNeuronSynapses.put(burningNeuronSynapse.getBurning(), new ArrayList());
            list = this.burningNeuronSynapses.get(burningNeuronSynapse.getBurning());
        }
        list.add(burningNeuronSynapse);
    }

    public ArrayList<Synapse> getFiringNeuronSynapses(Long firingNeuronId) {
        ArrayList<Synapse> retval = this.firingNeuronSynapses.get(firingNeuronId);
        if (retval == null) {
            this.firingNeuronSynapses.put(firingNeuronId, new ArrayList());
            retval = this.firingNeuronSynapses.get(firingNeuronId);
        }
        return retval;
    }

    public ArrayList<Synapse> getBurningNeuronSynapses(Long burningNeuronId) {
        ArrayList<Synapse> retval = this.burningNeuronSynapses.get(burningNeuronId);
        if (retval == null) {
            this.burningNeuronSynapses.put(burningNeuronId, new ArrayList());
            retval = this.burningNeuronSynapses.get(burningNeuronId);
        }
        return retval;
    }

    public void addInterNodeSynapse(Integer firingNodeId, Long firingNeuronId, Integer burningNodeId, Long burningNeuronId, Double mu_w, Double presynaptic_w, Double length) {
        Synapse newSyn = new Synapse(firingNodeId, firingNeuronId, burningNodeId, burningNeuronId, length, mu_w, presynaptic_w, false, true);
        this.setInterNodeSynapse(newSyn);
        if (firingNodeId.equals(this.n.getId())) {
            this.putFiringNeuronInterNodeConnection(firingNeuronId, newSyn);
        } else if (burningNodeId.equals(this.n.getId())) {
            this.putBurningNeuronInterNodeConnection(burningNeuronId, newSyn);
        } else {
            System.out.println("[SYNAPSES MANAGER WARNING]adding an internode synapse which does not belong to the current node:\n\tsynapse:" + newSyn.toString() + "\n\tcurrent region:" + this.n.getId());
        }
    }

    public int interNodeConnectionsNum() {
        return this.axmap.size();
    }

    private void putFiringNeuronInterNodeConnection(Long firingNeuronId, Synapse neuronNodeConnection) {
        if (this.firingNeuronInterNodeSynapses.size() >= Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException("You are triyng to add too much interregion connections to the same neuron:" + firingNeuronId + "of the region:" + this.n.getId());
        }
        ArrayList<Synapse> list = this.firingNeuronInterNodeSynapses.get(firingNeuronId);
        if (list == null) {
            this.firingNeuronInterNodeSynapses.put(firingNeuronId, new ArrayList());
            list = this.firingNeuronInterNodeSynapses.get(firingNeuronId);
        }
        list.add(neuronNodeConnection);
        this.firingNeuronInterNodeSynapses.put(firingNeuronId, list);
    }

    public ArrayList<Synapse> getFiringNeuronInterNodesSynapses(Long firingNeuronId) {
        ArrayList<Synapse> retval = this.firingNeuronInterNodeSynapses.get(firingNeuronId);
        if (retval == null) {
            this.firingNeuronInterNodeSynapses.put(firingNeuronId, new ArrayList());
            retval = this.firingNeuronInterNodeSynapses.get(firingNeuronId);
        }
        return retval;
    }

    private void putBurningNeuronInterNodeConnection(Long burningNeuronId, Synapse neuronNodeConnection) {
        if (this.burningNeuronInterNodeConnections.size() >= Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException("You are triyng to add to much interregion connection to the same neuron:" + burningNeuronId + "of the region:" + this.n.getId());
        }
        ArrayList<Synapse> list = this.burningNeuronInterNodeConnections.get(burningNeuronId);
        if (list == null) {
            this.burningNeuronInterNodeConnections.put(burningNeuronId, new ArrayList());
            list = this.burningNeuronInterNodeConnections.get(burningNeuronId);
        }
        list.add(neuronNodeConnection);
    }

    public ArrayList<Synapse> getBurningNeuronInterNodeConnections(Long burningNeuronId) {
        ArrayList<Synapse> retval = this.burningNeuronInterNodeConnections.get(burningNeuronId);
        if (retval == null) {
            this.burningNeuronInterNodeConnections.put(burningNeuronId, new ArrayList());
            retval = this.burningNeuronInterNodeConnections.get(burningNeuronId);
        }
        return retval;
    }

    public Double getMinAxDelay() {
        return this.minAxDelay;
    }

    public Double getAxDelay(Synapse syn) {
        Double delta = syn.getLength() / this.avgNeuronalSignalSpeed;
        if (delta < this.minAxDelay) {
            this.minAxDelay = delta;
        }
        return delta;
    }

    public Iterator<Long> getNeuronIntermoduleConnectionIterator() {
        return this.firingNeuronInterNodeSynapses.keySet().iterator();
    }

    public void printAxMap() {
        if (!verbose.booleanValue()) {
            return;
        }
        this.println(" printing axmap");
        Iterator<Synapse> it = this.axmap.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Synapse k = it.next();
            System.out.println(i++ + ". " + k.toString() + " - " + this.axmap.get(k));
        }
    }

    private void println(String s) {
        if (verbose.booleanValue()) {
            if (this.n != null) {
                System.out.println(TAG + this.n.getId() + "] " + s);
            } else {
                System.out.println(TAG + this.n.getId() + "/-]" + s);
            }
        }
    }
}

