/*
 * Decompiled with CFR 0.152.
 */
package spiking.node.neuron;

import java.util.HashMap;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import spiking.node.Node;
import utils.constants.Constants;
import utils.tools.NiceNode;
import utils.tools.NiceQueue;

public class NodeNeuronsManager {
    private static final String TAG = "[Neurons Manager for Node: ";
    private static final Boolean verbose = true;
    private Node n;
    private Boolean debug = false;
    private Double D_exc = 0.001;
    private Double D_inh = 0.001;
    private Double c = 0.04;
    private Double t_arp = 0.3;
    private Double sth = 1.0 + this.c;
    private NiceQueue activeNeurons;
    private Double excitatoryPresynapticDefVal = 2.0;
    private Double inhibithoryPresynapticDefVal = -1.0;
    private Double externalSourcesPresynapticDefVal = 1.0;
    private HashMap<Long, Double> neuronStates;
    private HashMap<Long, Double> timesToFire;
    private HashMap<Long, Double> lastFiringTimes;
    private HashMap<Long, Double> lastBurningTimes;
    private HashMap<Long, Double> presynapticWeights;
    private ExponentialDistribution exponentialD;

    public NodeNeuronsManager(Node r, Double c, Double D_exc, Double D_inh, Double t_arp, Double excitatoryPresynapticDefVal, Double inhibithoryPresynapticDefVal, Double externalPresynapticDefVal) {
        this.n = r;
        this.c = c;
        this.sth = 1.0 + c;
        this.D_exc = D_exc;
        this.D_inh = D_inh;
        this.t_arp = t_arp;
        this.excitatoryPresynapticDefVal = excitatoryPresynapticDefVal;
        this.inhibithoryPresynapticDefVal = inhibithoryPresynapticDefVal;
        this.externalSourcesPresynapticDefVal = externalPresynapticDefVal;
        this.activeNeurons = new NiceQueue("activeNeurons-" + r.getId());
        this.init();
    }

    private void init() {
        this.neuronStates = new HashMap();
        this.timesToFire = new HashMap();
        this.lastFiringTimes = new HashMap();
        this.lastBurningTimes = new HashMap();
        this.presynapticWeights = new HashMap();
        this.exponentialD = new ExponentialDistribution(this.n.getExternalInput().getTimeStep());
    }

    public Double getT_arp() {
        return this.t_arp;
    }

    public Double getSpikingThr() {
        return this.sth;
    }

    public Double getLinearDecayD(Long neuronId) {
        return this.n.isExcitatory(neuronId) ? this.D_exc : this.D_inh;
    }

    public Double getLinearDecayD_exc() {
        return this.D_exc;
    }

    public Double getLinearDecayD_inh() {
        return this.D_inh;
    }

    public Double getExcitatoryPresynapticDefVal() {
        return this.excitatoryPresynapticDefVal;
    }

    public Double getInhibithorySynapticDefVal() {
        return this.inhibithoryPresynapticDefVal;
    }

    public Double getExternalSourcesPresynapticDefVal() {
        return this.externalSourcesPresynapticDefVal;
    }

    public void setTimeToFire(Long neuronId, Double val) {
        this.timesToFire.put(neuronId, val);
    }

    public Double getTimeToFire(Long neuronId) {
        Double retval = this.timesToFire.get(neuronId);
        if (retval == null) {
            if (neuronId < this.n.getN()) {
                return Constants.TIME_TO_FIRE_DEF_VAL;
            }
            return Constants.EXTERNAL_TIME_TO_FIRE_DEF_VAL;
        }
        return retval;
    }

    public void setPreSynapticWeight(Long neuronId, Double val) {
        this.presynapticWeights.put(neuronId, val);
    }

    public Double getPreSynapticWeight(Long neuronId) {
        Double retval = this.presynapticWeights.get(neuronId);
        if (retval == null) {
            retval = this.isExcitatory(neuronId) ? this.n.getExc_ampl() : this.n.getInh_ampl();
        }
        return retval;
    }

    public Double getState(Long neuronId) {
        Double retval = this.neuronStates.get(neuronId);
        if (retval == null) {
            Double lastBurningTime = this.lastBurningTimes.get(neuronId);
            if (lastBurningTime == null) {
                this.neuronStates.put(neuronId, Math.random());
                retval = this.neuronStates.get(neuronId);
            } else {
                retval = 0.0;
            }
        }
        return retval;
    }

    public void setState(Long neuronId, Double val) {
        this.neuronStates.put(neuronId, val);
    }

    public void resetState(Long neuronId) {
        this.neuronStates.put(neuronId, 0.0);
    }

    public void resetTimeToFire(Long neuronId) {
        this.timesToFire.remove(neuronId);
    }

    public void setLastFiringTime(Long neuronId, Double val) {
        this.lastFiringTimes.put(neuronId, val);
    }

    public Double getLastFiringTime(Long neuronId) {
        Double retval = this.lastFiringTimes.get(neuronId);
        if (retval == null) {
            retval = Constants.TIME_TO_FIRE_DEF_VAL;
        }
        return retval;
    }

    public NiceNode getNextFiringNeuron() {
        return this.activeNeurons.extractMin();
    }

    public Double getMinFiringTime() {
        return this.activeNeurons.getMinTime();
    }

    public boolean isExcitatory(Long neuronId) {
        return this.n.isExcitatory(neuronId);
    }

    public Double getLastBurningTime(Long neuronId) {
        Double retval = this.lastBurningTimes.get(neuronId);
        if (retval == null) {
            retval = 0.0;
        }
        return retval;
    }

    public void setLastBurningTime(Long neuronId, Double lastBurningTime) {
        this.lastBurningTimes.put(neuronId, lastBurningTime);
    }

    public void extInputReset(Long extNeuronId, double currentTime) {
        if (currentTime > (double)this.n.getExternalInput().getFireDuration().intValue()) {
            this.removeActiveNeuron(extNeuronId);
            return;
        }
        if (this.n.getExternalInputsType() == 1) {
            double fireTime = currentTime == 0.0 ? this.n.getExternalInputsTimeOffset(extNeuronId) : currentTime + this.n.getExternalInput().getTimeStep();
            this.setPreSynapticWeight(extNeuronId, this.n.getAmplitudeValue(extNeuronId));
            this.setTimeToFire(extNeuronId, fireTime);
            this.addActiveNeuron(extNeuronId, fireTime, currentTime, 0);
            return;
        }
        if (this.n.getExternalInputsType() == 2) {
            double fireTime = currentTime == 0.0 ? this.n.getExternalInputsTimeOffset(extNeuronId) + Math.random() * 2.0 * this.n.getExternalInput().getTimeStep() : currentTime + Math.random() * 2.0 * this.n.getExternalInput().getTimeStep();
            this.setPreSynapticWeight(extNeuronId, this.n.getAmplitudeValue(extNeuronId));
            this.setTimeToFire(extNeuronId, fireTime);
            this.addActiveNeuron(extNeuronId, fireTime, currentTime, 4);
            return;
        }
        double fireTime = currentTime + this.exponentialD.sample();
        this.setPreSynapticWeight(extNeuronId, this.n.getAmplitudeValue(extNeuronId));
        this.setTimeToFire(extNeuronId, fireTime);
        this.addActiveNeuron(extNeuronId, fireTime, currentTime, 1);
    }

    public void addActiveNeuron(Long neuronId, Double fireTime, Double currentTime, Integer debug) {
        if (fireTime < currentTime) {
            this.println("\n....................\ndebug" + debug + "\n....................");
            this.println("fire time:" + fireTime + " current time:" + currentTime);
            System.exit(1);
        }
        this.activeNeurons.insert(fireTime, neuronId);
    }

    public void removeActiveNeuron(Long neuronId) {
        this.activeNeurons.delete(neuronId);
    }

    public int getActiveNeuronsNum() {
        return this.activeNeurons.size();
    }

    private void println(String s) {
        if (verbose.booleanValue()) {
            System.out.println(TAG + this.n.getId() + "] " + s);
        }
    }

    private void debprintln(String s) {
        if (verbose.booleanValue() && this.debug.booleanValue()) {
            System.out.println(TAG + this.n.getId() + "][debug] " + s);
        }
    }

    public void printAn() {
        this.println("printing active neurons:");
        NiceNode[] tmp = this.activeNeurons.toArray();
        for (int i = 0; i < tmp.length; ++i) {
            System.out.println("active neuron " + i + ":\t" + tmp[i].toString() + ", state:" + this.getState(tmp[i].fn));
        }
    }
}

