/*
 * Decompiled with CFR 0.152.
 */
package spiking.simulator;

import connectivity.nodes.ConnectivityPackageManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import spiking.controllers.node.NodeThread;
import spiking.node.NodesInterconnection;
import spiking.node.NodesManager;
import utils.configuration.NeuManCfg;
import utils.configuration.NodeCfg;
import utils.configuration.SpikingConfigManager;
import utils.configuration.SpikingSimulatorCfg;
import utils.constants.Constants;
import utils.exceptions.BadParametersException;
import utils.experiment.Experiment;
import utils.statistics.StatisticsCollector;
import utils.tools.NiceQueue;

public class SpikingNeuralSimulator
extends Thread {
    private static final String TAG = "[Spiking Neural Simulator] ";
    private static final int SERIALIZE_AFTER = 1000000;
    private long simStartTime;
    private Boolean verbose = false;
    private Boolean debug = false;
    private NodesManager nMan;
    private Double minQueuesValue = Double.MAX_VALUE;
    private NiceQueue minQueue = null;
    private HashMap<Integer, Boolean> NOI;
    private volatile Boolean checkall = false;
    private double total_time = 10.0;
    private double cycle_time;
    public static final long simulationNeurons = 100L;
    public static final int externalNeurons = 10;
    private Boolean initialized = false;
    private int debNum = 27;
    private int[] debugCases = new int[this.debNum];
    private int completing;
    private double currentTime = 0.0;
    private long splitCount = 0L;
    private double compressionFactor;
    private Boolean keep_running = true;
    private Double avgNeuronalSignalSpeed = 5.1;
    private Boolean badCurve = false;
    public static final Double excitProportion4Test = 0.8;
    public static final Integer k4Test = 20;
    public static final Double prew4Test = 0.5;
    public static final Double d4Test = 0.04;
    public static final Double ld4Test = 0.001;
    public static final Double kr4Test = 0.3;
    public static final Double internalAmplitude4Test = 1.0;
    public static final Integer BnTest = 1;
    public static final Double IBITest = 0.001;
    private static final Double epsilon = 1.0E-8;
    long[] times = new long[10];
    private static final Double bop_to_cycle_factor = 1.0;
    private static final Double bop_conservative_p = 0.9999;
    private ArrayList<StatisticsCollector> scs = new ArrayList();
    private Boolean matlab = false;
    private Boolean gephi = false;
    private Boolean reducedOutput = false;
    private Boolean superReducedOutput = false;
    private String defFileName = null;
    private PrintWriter burningPw;
    private PrintWriter burningPwGephi;
    private PrintWriter burningPwMatlab;
    private File burningTowritefile;
    private File burningTowritefileGephi;
    private File burningTowritefileMatlab;
    private BufferedWriter burningBw;
    private BufferedWriter burningBwMatlab;
    private FileWriter burningFw;
    private FileWriter burningFwGephi;
    private FileWriter burningFwMatlab;
    private FileWriter firingFw;
    private FileWriter firingFwGephi;
    private FileWriter firingFwMatlab;
    private PrintWriter firingPw;
    private PrintWriter firingPwGephi;
    private PrintWriter firingPwMatlab;
    private File firingTowritefile;
    private File firingTowritefileGephi;
    private File firingTowritefileMatlab;
    private BufferedWriter firingBw;
    private BufferedWriter firingBwMatlab;

    public SpikingNeuralSimulator() {
        this.nMan = new NodesManager(this, bop_conservative_p);
        this.simStartTime = System.currentTimeMillis();
    }

    private void addNodeThread(NodeThread node) {
        this.nMan.addNodeThread(node);
    }

    public void init() {
        if (this.nMan.getnSms() <= 0) {
            return;
        }
        this.initialized = true;
        String minTractLengthStr = this.nMan.getMinTractLength() != NodesManager.MAX_TRACT_LENGTH ? "" + this.nMan.getMinTractLength() : " there are no connections between nodes.";
        this.println("min tract length:" + minTractLengthStr);
        this.println("avg neuronal signal speed:" + this.avgNeuronalSignalSpeed);
        this.cycle_time = (this.nMan.getMinTractLength() + epsilon) / (this.avgNeuronalSignalSpeed * bop_to_cycle_factor);
    }

    private void setTotalTime(double total_time) {
        this.total_time = total_time;
    }

    public void startAll() {
        this.completing = this.nMan.getNodeThreadsNum() - 1;
        this.nMan.startAll();
    }

    public void runNewSplit(double newStopTime) {
        double stopTime;
        double d = stopTime = newStopTime > this.total_time ? this.total_time : newStopTime;
        if (this.verbose.booleanValue() || this.splitCount % 100L == 0L) {
            this.println("running new split " + this.splitCount + " with new stop simulated time:" + stopTime);
        }
        this.nMan.runNewSplit(stopTime);
    }

    public void killAll() {
        this.println("stopping node threads...");
        this.nMan.killAll();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.keep_running = false;
        this.println("node threads stopped.");
        this.println("killing statistics collector...");
        this.killscs();
        this.println("statistics collector stopped.");
    }

    private void killscs() {
        for (int i = 0; i < this.scs.size(); ++i) {
            this.scs.get(i).kill();
        }
        this.scs.get(0).close();
    }

    @Override
    public void run() {
        if (!this.initialized.booleanValue()) {
            return;
        }
        this.println("starting nodes...");
        this.startAll();
        this.println("nodes started.");
        while (this.keep_running.booleanValue()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.println("end of simulator run, " + (System.currentTimeMillis() - this.simStartTime) + " ms elapsed.");
        this.println("effective simulation time: " + (System.currentTimeMillis() - this.simStartTime - this.times[0] - this.times[1] - this.times[2] - this.times[3] - this.times[4]) + " ms.");
        this.println("init phases:\n\t conn pckg read:\t\t" + this.times[0] + " ms\n\t config file read:\t\t" + this.times[1] + " ms\n\t node init:\t\t\t" + this.times[2] + " ms\n\t inter-node connections init:\t" + this.times[3] + " ms\n\t simulator init:\t\t" + this.times[4] + " ms\n\t total init time:\t\t" + (this.times[0] + this.times[1] + this.times[2] + this.times[3] + this.times[4]) + " ms");
        this.println("avg neuronal signal speed:" + this.avgNeuronalSignalSpeed);
        this.println("cycle time:" + this.cycle_time);
        this.println("total inter node axonal connections:" + this.nMan.getTotalInterNodeConnectionsNumber());
    }

    public Boolean splitComplete(Integer nodeId) {
        if (this.completing > 0) {
            --this.completing;
        } else {
            ++this.splitCount;
            if (this.currentTime >= this.total_time) {
                this.killAll();
            } else {
                try {
                    SpikingNeuralSimulator.sleep(5L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.currentTime += this.cycle_time;
                this.runNewSplit(this.currentTime);
                this.completing = this.nMan.getNodeThreadsNum() - 1;
            }
            return false;
        }
        return true;
    }

    private void setMinMaxNe_xn_ratiosScs(Double minNe_xn_ratio, Double maxNe_xn_ratio) {
        for (int i = 0; i < this.scs.size(); ++i) {
            this.scs.get(i).setMinMaxNe_xn_ratios(minNe_xn_ratio, maxNe_xn_ratio);
        }
    }

    private void setSerializeAfterScs(int serializeAfter) {
        for (int i = 0; i < this.scs.size(); ++i) {
            this.scs.get(i).setSerializeAfter(serializeAfter);
        }
    }

    public void startScs() {
        this.initBurningWriters();
        this.initFiringWriters();
        for (int i = 0; i < this.scs.size(); ++i) {
            this.scs.get(i).init(this.defFileName);
            this.scs.get(i).setWriters(this.burningPw, this.burningPwGephi, this.burningPwMatlab, this.firingPw, this.firingPwGephi, this.firingPwMatlab);
            this.scs.get(i).start();
        }
    }

    private void initBurningWriters() {
        Boolean newfile = false;
        try {
            this.burningTowritefile = this.reducedOutput != false ? new File(this.defFileName + "_burning_r.csv") : (this.superReducedOutput != false ? new File(this.defFileName + "_burning_R.csv") : new File(this.defFileName + "_burning.csv"));
            if (this.burningTowritefile.exists()) {
                this.burningFw = new FileWriter(this.firingTowritefile, true);
            } else {
                newfile = true;
                this.burningTowritefile.createNewFile();
                this.burningFw = new FileWriter(this.burningTowritefile);
            }
            this.burningBw = new BufferedWriter(this.burningFw);
            this.burningPw = new PrintWriter(this.burningBw);
            if (this.matlab.booleanValue()) {
                this.burningTowritefileMatlab = new File(this.defFileName + "_burning_matlab.csv");
                if (this.burningTowritefileMatlab.exists()) {
                    this.burningFwMatlab = new FileWriter(this.burningTowritefileMatlab, true);
                } else {
                    this.burningTowritefileMatlab.createNewFile();
                    this.burningFwMatlab = new FileWriter(this.burningTowritefileMatlab);
                }
                this.burningBwMatlab = new BufferedWriter(this.burningFwMatlab);
                this.burningPwMatlab = new PrintWriter(this.burningFwMatlab);
            }
            if (this.gephi.booleanValue()) {
                this.burningTowritefileGephi = new File(this.defFileName + "_burning_gephi.csv");
                if (this.burningTowritefileGephi.exists()) {
                    this.burningFwGephi = new FileWriter(this.burningTowritefileGephi, true);
                } else {
                    this.burningTowritefileGephi.createNewFile();
                    this.burningFwGephi = new FileWriter(this.burningTowritefileGephi);
                }
                BufferedWriter burningBwGephi = new BufferedWriter(this.burningFwGephi);
                this.burningPwGephi = new PrintWriter(burningBwGephi);
                if (newfile.booleanValue()) {
                    this.burningPwGephi.println("Firing, Burning");
                }
            }
            this.burningBw = new BufferedWriter(this.burningFw);
            if (newfile.booleanValue() && !this.reducedOutput.booleanValue()) {
                this.burningPw.println("Burning Time, Firing Node, Firing Neuron, Burning Node, Burning Neuron, External Source, From Internal State, To Internal State, Step in State, Post Synaptic Weight, Pre Synaptic Weight, Instant to Fire, (Afferent) Firing Time");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initFiringWriters() {
        Boolean newfile = false;
        try {
            this.firingTowritefile = this.reducedOutput != false ? new File(this.defFileName + "_firing_r.csv") : (this.superReducedOutput != false ? new File(this.defFileName + "_firing_R.csv") : new File(this.defFileName + "_firing.csv"));
            if (this.firingTowritefile.exists()) {
                this.firingFw = new FileWriter(this.firingTowritefile, true);
            } else {
                newfile = true;
                this.firingTowritefile.createNewFile();
                this.firingFw = new FileWriter(this.firingTowritefile);
            }
            this.firingBw = new BufferedWriter(this.firingFw);
            this.firingPw = new PrintWriter(this.firingBw);
            if (this.matlab.booleanValue()) {
                this.firingTowritefileMatlab = new File(this.defFileName + "_firing_matlab.csv");
                if (this.firingTowritefileMatlab.exists()) {
                    this.firingFwMatlab = new FileWriter(this.firingTowritefileMatlab, true);
                } else {
                    this.firingTowritefileMatlab.createNewFile();
                    this.firingFwMatlab = new FileWriter(this.firingTowritefileMatlab);
                }
                this.firingBwMatlab = new BufferedWriter(this.firingFwMatlab);
                this.firingPwMatlab = new PrintWriter(this.firingBwMatlab);
            }
            this.firingBw = new BufferedWriter(this.firingFw);
            if (newfile.booleanValue() && !this.reducedOutput.booleanValue()) {
                this.firingPw.println("Firing Time, Firing Node, Firing Neuron, Neuron Type, External Source");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setFilename(String filename) {
        int count2 = 1;
        while (true) {
            File towritefile;
            if (!(towritefile = this.superReducedOutput != false ? new File(filename + String.format("%03d", count2) + "_burning_R.csv") : (this.reducedOutput != false ? new File(filename + String.format("%03d", count2) + "_burning_r.csv") : new File(filename + String.format("%03d", count2) + "_burning.csv"))).exists()) break;
            ++count2;
        }
        this.defFileName = filename + String.format("%03d", count2);
    }

    public void init_scs() {
        for (int i = 0; i < this.scs.size(); ++i) {
            this.scs.get(i).init(this.defFileName);
        }
    }

    private void setMatlabScs() {
        this.matlab = true;
        for (int i = 0; i < this.scs.size(); ++i) {
            this.scs.get(i).setMatlab();
        }
    }

    private void setReducedOutputScs() {
        this.reducedOutput = true;
        for (int i = 0; i < this.scs.size(); ++i) {
            this.scs.get(i).setReducedOutput();
        }
    }

    private void setSuperReducedOutputScs() {
        this.superReducedOutput = true;
        for (int i = 0; i < this.scs.size(); ++i) {
            this.scs.get(i).setSuperReducedOutput();
        }
    }

    private void setGephiScs() {
        this.gephi = true;
        for (int i = 0; i < this.scs.size(); ++i) {
            this.scs.get(i).setGephi();
        }
    }

    private void printResultsScs() {
        for (int i = 0; i < this.scs.size(); ++i) {
            System.out.println("\n==============| node " + i + "|=============");
            this.scs.get(i).PrintResults();
        }
        System.out.println();
    }

    public void initFromConfigFileAndConnectivityPackage(String configPath, String connPkgPath, Boolean do_fast) throws BadParametersException {
        int i;
        long startTime;
        long lastTime = startTime = System.currentTimeMillis();
        this.println("reading connectivity package file:" + connPkgPath);
        ConnectivityPackageManager cpm = new ConnectivityPackageManager();
        cpm.readConnectivityPackage(connPkgPath);
        for (int i2 = 0; i2 < cpm.getNodesNum(); ++i2) {
            this.scs.add(new StatisticsCollector());
        }
        this.setMinMaxNe_xn_ratiosScs(cpm.getMinNe_xn_ratio(), cpm.getMaxNe_xn_ratio());
        ArrayList<NodesInterconnection> conns = cpm.getInterNodeConnections();
        this.times[0] = System.currentTimeMillis() - lastTime;
        lastTime += this.times[0];
        System.out.println("reading config file:" + configPath);
        SpikingSimulatorCfg ssc = SpikingConfigManager.readConfigFile(configPath);
        this.setTotalTime(new Double(ssc.getStop()));
        HashMap<Integer, NodeCfg> nodeCs = ssc.getNodesMap();
        this.avgNeuronalSignalSpeed = ssc.getAvg_neuronal_signal_speed();
        Integer serializeAfter = ssc.getSerialize_after();
        if (serializeAfter == null) {
            serializeAfter = 1000000;
        }
        this.setSerializeAfterScs(serializeAfter);
        this.times[1] = System.currentTimeMillis() - lastTime;
        lastTime += this.times[1];
        System.out.println("creating and adding nodes...\n");
        Boolean lif = new Boolean(ssc.getLif());
        Boolean exp_decay = new Boolean(ssc.getExp_decay());
        for (i = 0; i < cpm.getNodesNum(); ++i) {
            Double tmpTo;
            Integer tmpBn;
            NodeCfg tmp = nodeCs.get(i) != null ? nodeCs.get(i) : null;
            Long tmpN = tmp != null && tmp.getN() != null ? tmp.getN() : ssc.getGlob_local_n();
            Double tmpExcitRatio = tmp != null && tmp.getExcitatory_inhibitory_ratio() != null ? tmp.getExcitatory_inhibitory_ratio() : ssc.getR();
            Double tmp_mu_w_exc = tmp != null && tmp.getMu_w_exc() != null ? tmp.getMu_w_exc() : ssc.getGlob_mu_w_exc();
            Double tmp_mu_w_inh = tmp != null && tmp.getMu_w_inh() != null ? tmp.getMu_w_inh() : ssc.getGlob_mu_w_inh();
            Double tmp_sigma_w_exc = tmp != null && tmp.getSigma_w_exc() != null ? tmp.getSigma_w_exc() : ssc.getGlob_sigma_w_exc();
            Double tmp_sigma_w_inh = tmp != null && tmp.getSigma_w_inh() != null ? tmp.getSigma_w_inh() : ssc.getGlob_sigma_w_inh();
            Double tmpW_pre_exc = tmp != null && tmp.getW_pre_exc() != null ? tmp.getW_pre_exc() : ssc.getGlob_w_pre_exc();
            Double tmpW_pre_inh = tmp != null && tmp.getW_pre_inh() != null ? tmp.getW_pre_inh() : ssc.getGlob_w_pre_inh();
            Integer tmpK = tmp != null && tmp.getK() != null ? tmp.getK() : ssc.getGlob_k();
            Double tmpRewiringP = tmp != null && tmp.get_rewiring_P() != null ? tmp.get_rewiring_P() : ssc.getGlob_rewiring_P();
            Integer tmpExternal = tmp != null && tmp.getExternal_inputs_number() != null ? tmp.getExternal_inputs_number() : ssc.getGlob_external_inputs_number();
            Integer n = tmpBn = tmp != null && tmp.getBn() != null ? tmp.getBn() : ssc.getGlob_Bn();
            if (tmpBn == 0) {
                tmpBn = 1;
            }
            Double tmpIBI = tmp != null && tmp.getIBI() != null ? tmp.getIBI() : ssc.getGlob_IBI();
            NeuManCfg nmcfg = tmp != null && tmp.getNeuron_manager() != null ? tmp.getNeuron_manager() : ssc.getGlobal_neuron_manager();
            Boolean tmpPlasticity = tmp != null && tmp.getPlasticity() != null ? tmp.getPlasticity() : ssc.getPlasticity();
            Double tmpEtap = tmp != null && tmp.getEtap() != null ? tmp.getEtap() : ssc.getGlob_etap();
            Double tmpEtam = tmp != null && tmp.getEtam() != null ? tmp.getEtam() : ssc.getGlob_etam();
            Double tmpTaup = tmp != null && tmp.getTaup() != null ? tmp.getTaup() : ssc.getGlob_taup();
            Double tmpTaum = tmp != null && tmp.getTaum() != null ? tmp.getTaum() : ssc.getGlob_taum();
            Double tmpWMax = tmp != null && tmp.getW_max() != null ? tmp.getW_max() : ssc.getGlob_w_max();
            Double d = tmpTo = tmp != null && tmp.getTo() != null ? tmp.getTo() : ssc.getGlob_to();
            if ((long)tmpK.intValue() >= tmpN) {
                throw new BadParametersException("bad parameters exception, n has to be greater than k (now n is " + tmpN + " and k is +" + tmpK + ")");
            }
            this.println("adding node:" + i);
            if (tmpExternal.equals(0)) {
                this.addNodeThread(new NodeThread(this.nMan, cpm.getNode(i).getId(), tmpN, tmpExcitRatio, tmpK, tmpRewiringP, tmpBn, tmpIBI, nmcfg.getC(), nmcfg.getD_exc(), nmcfg.getD_inh(), nmcfg.getT_arp(), tmp_mu_w_exc, tmp_mu_w_inh, tmp_sigma_w_exc, tmp_sigma_w_inh, tmpW_pre_exc, tmpW_pre_inh, Constants.EXTERNAL_SOURCES_PRESYNAPTIC_DEF_VAL, tmpPlasticity, tmpEtap, tmpEtam, tmpTaup, tmpTaum, tmpWMax, tmpTo, this.avgNeuronalSignalSpeed, lif, exp_decay, do_fast, this.checkall != false || this.NOI.get(cpm.getNode(i).getId()) != false, this.scs.get(i)));
                continue;
            }
            Integer tmpExternalType = tmp != null && tmp.getExternal_inputs_type() != null ? tmp.getExternal_inputs_type() : ssc.getGlob_external_inputs_type();
            Double tmpExternalInputsTimeOffset = tmp != null && tmp.getExternal_inputs_time_offset() != null ? tmp.getExternal_inputs_time_offset() : ssc.getGlob_external_inputs_time_offset();
            Double tmpExternalTimestep = tmp != null && tmp.getExternal_inputs_timestep() != null ? tmp.getExternal_inputs_timestep() : ssc.getGlob_external_inputs_timestep();
            Integer tmpExternalFireDuration = tmp != null && tmp.getExternal_inputs_fireduration() != null ? tmp.getExternal_inputs_fireduration() : ssc.getGlob_external_inputs_fireduration();
            Integer tmpExternalFireOutdegree = tmp != null && tmp.getExternal_inputs_outdegree() != null ? tmp.getExternal_inputs_outdegree() : ssc.getGlob_external_inputs_outdegree();
            Double tmpExternalFireAmplitude = tmp != null && tmp.getExternal_inputs_amplitude() != null ? tmp.getExternal_inputs_amplitude() : ssc.getGlob_external_inputs_amplitude();
            this.addNodeThread(new NodeThread(this.nMan, cpm.getNode(i).getId(), tmpN, tmpExternal, tmpExternalType, tmpExternalInputsTimeOffset, tmpExternalTimestep, tmpExternalFireDuration, tmpExternalFireAmplitude, tmpExternalFireOutdegree, tmpExcitRatio, tmpK, tmpRewiringP, tmpBn, tmpIBI, nmcfg.getC(), nmcfg.getD_exc(), nmcfg.getD_inh(), nmcfg.getT_arp(), tmp_mu_w_exc, tmp_mu_w_inh, tmp_sigma_w_exc, tmp_sigma_w_inh, tmpW_pre_exc, tmpW_pre_inh, Constants.EXTERNAL_SOURCES_PRESYNAPTIC_DEF_VAL, tmpPlasticity, tmpEtap, tmpEtam, tmpTaup, tmpTaum, tmpWMax, tmpTo, this.avgNeuronalSignalSpeed, lif, exp_decay, do_fast, this.checkall != false || this.NOI.get(cpm.getNode(i).getId()) != false, this.scs.get(i)));
        }
        this.calculateCompressionFactor();
        this.times[2] = System.currentTimeMillis() - lastTime;
        lastTime += this.times[2];
        this.println("adding inter-node connection ...");
        for (i = 0; i < conns.size(); ++i) {
            this.println("adding connection bundle: " + conns.get(i).getSrc() + "-" + conns.get(i).getDst());
            this.addInterNodeThreadConnection(this.nMan.getNodeThread(conns.get(i).getSrc()), this.nMan.getNodeThread(conns.get(i).getDst()), conns.get(i).getNe_xn_ratio(), conns.get(i).getMu_omega(), conns.get(i).getSigma_w(), conns.get(i).getLength(), conns.get(i).getLengthShapeParameter(), conns.get(i).getType());
        }
        this.times[3] = System.currentTimeMillis() - lastTime;
        System.out.println("initializing simulator...\n");
        this.init();
        this.times[4] = System.currentTimeMillis() - (lastTime += this.times[3]);
        lastTime += this.times[4];
    }

    public void addInterNodeThreadConnection(NodeThread nd1, NodeThread nd2, Double Ne_xn_ratio, Double mu_omega, Double sigma_omega, Double mu_lambda, Double alpha_lambda, Integer inter_node_conn_type) {
        this.nMan.addInterNodeConnection(nd1, nd2, Ne_xn_ratio, mu_omega, sigma_omega, mu_lambda, alpha_lambda, inter_node_conn_type);
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
        this.nMan.setDebug(debug);
    }

    public void setExperimentName(String expName) {
        Experiment.setExperimentName(expName);
        File expDir = new File(Experiment.getExperimentDir());
        if (!expDir.exists()) {
            expDir.mkdirs();
        }
    }

    private void calculateCompressionFactor() {
        this.compressionFactor = this.nMan.getTotalN() > 1000000L ? new Double(2.147483647E9) / (double)this.nMan.getTotalN().longValue() : 1.0;
        this.nMan.setCompressionFactor(this.compressionFactor);
    }

    public double getReducingFactor() {
        return this.compressionFactor;
    }

    public void setNOI(HashMap<Integer, Boolean> NOI) {
        this.NOI = NOI;
    }

    public void checkAll() {
        this.checkall = true;
    }

    public void setVerbose() {
        this.verbose = true;
    }

    public void setBadCurve() {
        this.badCurve = true;
    }

    private void println(String s) {
        System.out.println(TAG + s);
    }

    private void debprintln(String s) {
        if (this.verbose.booleanValue() && this.debug.booleanValue()) {
            System.out.println("[Spiking Neural Simulator] [debug] " + s);
        }
    }

    public void printDebug() {
        System.out.println("debug variables:");
        for (int i = 0; i < this.debNum; ++i) {
            System.out.print("\n\t" + i + ". " + this.debugCases[i]);
        }
        System.out.println();
    }

    public void printNodeFields() {
        this.nMan.printNodeFields();
    }

    public void printBreakLine() {
        if (this.verbose.booleanValue()) {
            System.out.println("\n\n----------------------------------------" + this.splitCount + "-----------------------------------------------------\n");
        }
    }

    public static void main(String[] args) {
        CommandLine cmd;
        System.out.println("\n\n\n\t\t\t\t\t=================================");
        System.out.println("\t\t\t\t\t=\t    F N S\t\t=");
        System.out.println("\t\t\t\t\t=\tNeural Simulator\t=");
        System.out.println("\t\t\t\t\t=================================\n\n");
        Options options = new Options();
        options.addOption("n", "nodes-list", true, " followed by the list of the node of interest (NOI) for which to store the output data. The format for such list is like this exmaple: [3,25,13,12]. If this switch is not present, the entire set of nodeswill be considered for the generation of output data.");
        options.addOption("f", "fast", false, "enables faster algorithms at different levels, in return for some approximations (i.e., plasticity exponentials, etc.)");
        options.addOption("m", "matlab", false, "provides with a set of matlab-compliant CSV files, in addition to the output CSVs.");
        options.addOption("r", "reduced-output", false, "enables reduced CSV files, i.e., outputs that indicates only spiking events and inner states of the neurons");
        options.addOption("R", "super-reduced-output", false, "enables super-reduced CSV files, i.e., outputs that indicates only spiking events and inner states of the neurons with reduced precision");
        options.addOption("g", "gephi", false, "produce also a csv for Gephi");
        options.addOption("v", "verbose", false, "print verbose output");
        options.addOption("h", "help", false, "shows this help");
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        try {
            cmd = parser.parse(options, args);
            if (cmd.hasOption("help")) {
                formatter.printHelp("FNS", options);
                System.out.println("\nExamples:");
                System.out.println("[Windows] \t> .\\start.bat exp01 -f -n [3,25,13,12] -m -r");
                System.out.println("[Linux] \t$ ./start exp01 -f -n [3,25,13,12] -m -r\n");
                System.exit(0);
                return;
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp("FNS", options);
            System.out.println("\nExamples:");
            System.out.println("[Windows] > .\\start.bat exp01 -f -n [3,25,13,12] -p -m -r");
            System.out.println("[Linux] > ./start exp01 -f -n [3,25,13,12] -p -m -r\n");
            System.exit(1);
            return;
        }
        System.out.println("initializing simulator");
        SpikingNeuralSimulator sns = new SpikingNeuralSimulator();
        sns.setExperimentName(args[0]);
        String filename = null;
        HashMap<Integer, Boolean> NOI = new HashMap<Integer, Boolean>();
        Boolean do_plot = cmd.hasOption("plot");
        Boolean do_fast = cmd.hasOption("fast");
        String nodeListString = cmd.getOptionValue("nodes-list", "[]").replaceAll("\\s+", "").substring(1, cmd.getOptionValue("nodes-list", "[]").length() - 1);
        if (nodeListString.length() > 0) {
            String[] nodesStr = nodeListString.split(",");
            for (int i = 0; i < nodesStr.length; ++i) {
                NOI.put(Integer.parseInt(nodesStr[i]), true);
            }
            filename = Experiment.getExperimentDir() + "nodes_" + nodeListString.replaceAll(",", "-") + "_";
            sns.setNOI(NOI);
        } else {
            filename = Experiment.getExperimentDir() + "all_nodes_";
            sns.checkAll();
        }
        if (cmd.hasOption("verbose")) {
            sns.setVerbose();
        }
        try {
            sns.initFromConfigFileAndConnectivityPackage(new File(args[0] + "/config.xml").getAbsolutePath(), new File(args[0] + "/connectivity").getAbsolutePath(), do_fast);
        }
        catch (BadParametersException e) {
            e.printStackTrace();
        }
        if (cmd.hasOption("matlab")) {
            sns.setMatlabScs();
        }
        if (cmd.hasOption("reduced-output")) {
            sns.setReducedOutputScs();
        }
        if (cmd.hasOption("super-reduced-output")) {
            sns.setSuperReducedOutputScs();
        }
        if (cmd.hasOption("gephi")) {
            sns.setGephiScs();
        }
        System.out.println("nodes to check mask:" + nodeListString);
        sns.setFilename(filename);
        System.out.println("starting statistic collector...");
        sns.startScs();
        System.out.println("starting simulator...\n");
        sns.start();
        try {
            sns.join();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        sns.printResultsScs();
        sns.killscs();
        System.out.println("bye!");
        System.exit(0);
    }
}

