/*
 * Decompiled with CFR 0.152.
 */
package utils.math;

public class FastMath {
    private static float[] expadjust;

    public FastMath() {
        this.buildexptable(-10.0, 10.0, 1.0E-4);
    }

    public float fastexp(float x) {
        int temp = (int)(1.2102203E7f * x + 1.0653532E9f);
        return Float.intBitsToFloat(temp) * expadjust[temp >> 15 & 0xFF];
    }

    public float fastexp(Double x) {
        int temp = (int)(1.2102203E7 * x + 1.065353216E9);
        return Float.intBitsToFloat(temp) * expadjust[temp >> 15 & 0xFF];
    }

    private void buildexptable(double min2, double max2, double step) {
        expadjust = new float[256];
        int[] amount = new int[256];
        for (double x = min2; x < max2; x += step) {
            double exp = Math.exp(x);
            int temp = (int)(1.2102203E7 * x + 1.065353216E9);
            int index = temp >> 15 & 0xFF;
            double fexp = Float.intBitsToFloat(temp);
            int n = index;
            expadjust[n] = (float)((double)expadjust[n] + exp / fexp);
            int n2 = index;
            amount[n2] = amount[n2] + 1;
        }
        for (int k = 0; k < amount.length; ++k) {
            int n = k;
            expadjust[n] = expadjust[n] / (float)amount[k];
        }
    }

    public static void main(String[] args) {
        FastMath fm = new FastMath();
        Double d = 0.01;
        float f = 10.0f;
        float retval = 0.0f;
        retval = fm.fastexp(d);
        System.out.println("retval: " + retval);
    }
}

