/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.set.primitive.ShortSet;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractSynchronizedShortCollection;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableShortSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedShortSet
extends AbstractSynchronizedShortCollection
implements MutableShortSet {
    private static final long serialVersionUID = 1L;

    SynchronizedShortSet(MutableShortSet set) {
        super(set);
    }

    SynchronizedShortSet(MutableShortSet set, Object newLock) {
        super(set, newLock);
    }

    public static SynchronizedShortSet of(MutableShortSet set) {
        return new SynchronizedShortSet(set);
    }

    public static SynchronizedShortSet of(MutableShortSet set, Object lock) {
        return new SynchronizedShortSet(set, lock);
    }

    @GuardedBy(value="getLock()")
    private MutableShortSet getMutableShortSet() {
        return (MutableShortSet)this.getShortCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedShortSet without(short element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortSet().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedShortSet with(short element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortSet().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedShortSet withAll(ShortIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortSet().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedShortSet withoutAll(ShortIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableShortSet().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableShortSet select(ShortPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortSet().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableShortSet reject(ShortPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortSet().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableSet<V> collect(ShortToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortSet().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object otherSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortSet().equals(otherSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortSet().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyShortIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyShortIterableAdapter(this);
        }
    }

    @Override
    public MutableShortSet asUnmodifiable() {
        return new UnmodifiableShortSet(this);
    }

    @Override
    public MutableShortSet asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShortSet freeze() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortSet().freeze();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableShortSet toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableShortSet().toImmutable();
        }
    }
}

