/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.strategy.immutable;

import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.factory.set.strategy.ImmutableHashingStrategySetFactory;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.set.strategy.immutable.ImmutableEmptySetWithHashingStrategy;
import org.eclipse.collections.impl.set.strategy.immutable.ImmutableUnifiedSetWithHashingStrategy;
import org.eclipse.collections.impl.utility.Iterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class ImmutableHashingStrategySetFactoryImpl
implements ImmutableHashingStrategySetFactory {
    @Override
    public <T> ImmutableSet<T> of(HashingStrategy<? super T> hashingStrategy) {
        return this.with(hashingStrategy);
    }

    @Override
    public <T> ImmutableSet<T> with(HashingStrategy<? super T> hashingStrategy) {
        return new ImmutableEmptySetWithHashingStrategy<T>(hashingStrategy);
    }

    @Override
    public <T> ImmutableSet<T> of(HashingStrategy<? super T> hashingStrategy, T ... items) {
        return this.with(hashingStrategy, items);
    }

    @Override
    public <T> ImmutableSet<T> with(HashingStrategy<? super T> hashingStrategy, T ... items) {
        if (items == null || items.length == 0) {
            return this.of(hashingStrategy);
        }
        return ImmutableUnifiedSetWithHashingStrategy.newSetWith(hashingStrategy, items);
    }

    @Override
    public <T> ImmutableSet<T> ofAll(HashingStrategy<? super T> hashingStrategy, Iterable<? extends T> items) {
        return this.withAll(hashingStrategy, items);
    }

    @Override
    public <T> ImmutableSet<T> withAll(HashingStrategy<? super T> hashingStrategy, Iterable<? extends T> items) {
        return this.with(hashingStrategy, Iterate.toArray(items));
    }
}

