/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Arrays;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.GroupSerializerObjectArray;
import org.mapdb.serializer.SerializerUtils;

public class SerializerFloatArray
extends GroupSerializerObjectArray<float[]> {
    @Override
    public void serialize(DataOutput2 out, float[] value) throws IOException {
        out.packInt(value.length);
        for (float v : value) {
            out.writeFloat(v);
        }
    }

    @Override
    public float[] deserialize(DataInput2 in, int available) throws IOException {
        float[] ret2 = new float[in.unpackInt()];
        for (int i = 0; i < ret2.length; ++i) {
            ret2[i] = in.readFloat();
        }
        return ret2;
    }

    @Override
    public boolean isTrusted() {
        return true;
    }

    @Override
    public boolean equals(float[] a1, float[] a2) {
        return Arrays.equals(a1, a2);
    }

    @Override
    public int hashCode(float[] floats, int seed) {
        for (float element : floats) {
            seed = -1640531527 * seed + Float.floatToIntBits(element);
        }
        return seed;
    }

    @Override
    public int compare(float[] o1, float[] o2) {
        if (o1 == o2) {
            return 0;
        }
        int len = Math.min(o1.length, o2.length);
        for (int i = 0; i < len; ++i) {
            if (o1[i] == o2[i]) continue;
            if (o1[i] > o2[i]) {
                return 1;
            }
            return -1;
        }
        return SerializerUtils.compareInt(o1.length, o2.length);
    }
}

