/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.DoubleBag;
import org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.factory.primitive.DoubleBags;
import org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableDoubleSingletonBag
implements ImmutableDoubleBag,
Serializable {
    private static final long serialVersionUID = 1L;
    private final double element1;

    ImmutableDoubleSingletonBag(double element) {
        this.element1 = element;
    }

    @Override
    public ImmutableDoubleBag newWith(double element) {
        return DoubleBags.immutable.with(this.element1, element);
    }

    @Override
    public ImmutableDoubleBag newWithout(double element) {
        return Double.compare(this.element1, element) == 0 ? DoubleBags.immutable.with() : this;
    }

    @Override
    public ImmutableDoubleBag newWithAll(DoubleIterable elements) {
        return DoubleHashBag.newBag(elements).with(this.element1).toImmutable();
    }

    @Override
    public ImmutableDoubleBag newWithoutAll(DoubleIterable elements) {
        return elements.contains(this.element1) ? DoubleBags.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public boolean contains(double value) {
        return Double.compare(this.element1, value) == 0;
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        DoubleIterator iterator2 = source.doubleIterator();
        while (iterator2.hasNext()) {
            if (Double.compare(this.element1, iterator2.next()) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(double ... source) {
        for (double value : source) {
            if (Double.compare(this.element1, value) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(DoubleProcedure procedure) {
        procedure.value(this.element1);
    }

    @Override
    public ImmutableDoubleBag select(DoublePredicate predicate) {
        return predicate.accept(this.element1) ? DoubleHashBag.newBagWith(this.element1).toImmutable() : new DoubleHashBag().toImmutable();
    }

    @Override
    public ImmutableDoubleBag reject(DoublePredicate predicate) {
        return predicate.accept(this.element1) ? new DoubleHashBag().toImmutable() : DoubleHashBag.newBagWith(this.element1).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(DoubleToObjectFunction<? extends V> function) {
        return HashBag.newBagWith(function.valueOf(this.element1)).toImmutable();
    }

    @Override
    public MutableDoubleList toList() {
        return DoubleArrayList.newListWith(this.element1);
    }

    @Override
    public int sizeDistinct() {
        return 1;
    }

    @Override
    public int occurrencesOf(double item) {
        return Double.compare(this.element1, item) == 0 ? 1 : 0;
    }

    @Override
    public void forEachWithOccurrences(DoubleIntProcedure doubleIntProcedure) {
        doubleIntProcedure.value(this.element1, 1);
    }

    @Override
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    @Override
    public int count(DoublePredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public double sum() {
        return this.element1;
    }

    @Override
    public double min() {
        return this.element1;
    }

    @Override
    public double max() {
        return this.element1;
    }

    @Override
    public double maxIfEmpty(double defaultValue) {
        return this.element1;
    }

    @Override
    public double minIfEmpty(double defaultValue) {
        return this.element1;
    }

    @Override
    public double average() {
        return this.element1;
    }

    @Override
    public double median() {
        return this.element1;
    }

    @Override
    public double[] toSortedArray() {
        return new double[]{this.element1};
    }

    @Override
    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newListWith(this.element1);
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        return !predicate.accept(this.element1);
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        return predicate.accept(this.element1);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.element1);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DoubleBag)) {
            return false;
        }
        DoubleBag bag = (DoubleBag)obj;
        if (bag.size() != 1) {
            return false;
        }
        return this.occurrencesOf(this.element1) == bag.occurrencesOf(this.element1);
    }

    @Override
    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.element1) ^ Double.doubleToLongBits(this.element1) >>> 32) ^ 1;
    }

    @Override
    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSetWith(this.element1);
    }

    @Override
    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBagWith(this.element1);
    }

    @Override
    public ImmutableDoubleBag toImmutable() {
        return this;
    }

    @Override
    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter(this);
    }

    @Override
    public double[] toArray() {
        return new double[]{this.element1};
    }

    @Override
    public String toString() {
        return '[' + this.makeString() + ']';
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator(DoubleHashBag.newBagWith(this.element1).doubleIterator());
    }
}

