/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.forkjoin;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinTask;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.impl.forkjoin.FJListObjectIntProcedureRunner;
import org.eclipse.collections.impl.parallel.ObjectIntProcedureFactory;
import org.eclipse.collections.impl.utility.ArrayListIterate;
import org.eclipse.collections.impl.utility.ListIterate;

public class FJListObjectIntProcedureTask<T, PT extends ObjectIntProcedure<? super T>>
extends ForkJoinTask<PT> {
    private final ObjectIntProcedureFactory<PT> procedureFactory;
    private PT procedure;
    private final List<T> list;
    private final int start;
    private final int end;
    private final FJListObjectIntProcedureRunner<T, PT> taskRunner;

    public FJListObjectIntProcedureTask(FJListObjectIntProcedureRunner<T, PT> newFJTaskRunner, ObjectIntProcedureFactory<PT> newBlockFactory, List<T> list, int index, int sectionSize, boolean isLast) {
        this.taskRunner = newFJTaskRunner;
        this.procedureFactory = newBlockFactory;
        this.list = list;
        this.start = index * sectionSize;
        this.end = isLast ? this.list.size() - 1 : this.start + sectionSize - 1;
    }

    @Override
    protected boolean exec() {
        try {
            this.procedure = this.procedureFactory.create();
            if (this.list instanceof ListIterable) {
                ((ListIterable)((Object)this.list)).forEachWithIndex(this.start, this.end, this.procedure);
            } else if (this.list instanceof ArrayList) {
                ArrayListIterate.forEachWithIndex((ArrayList)this.list, this.start, this.end, this.procedure);
            } else {
                ListIterate.forEachWithIndex(this.list, this.start, this.end, this.procedure);
            }
        }
        catch (Throwable newError) {
            this.taskRunner.setFailed(newError);
        }
        finally {
            this.taskRunner.taskCompleted(this);
        }
        return true;
    }

    @Override
    public PT getRawResult() {
        return this.procedure;
    }

    @Override
    protected void setRawResult(PT value) {
        throw new UnsupportedOperationException();
    }
}

