/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ByteIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.ByteIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteIntMap;
import org.eclipse.collections.api.map.primitive.MutableByteIntMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.ByteIntPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedByteIntProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.map.mutable.primitive.ByteIntHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableByteIntHashMap
implements ImmutableByteIntMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableByteIntMap delegate;

    ImmutableByteIntHashMap(ByteIntMap delegate) {
        this.delegate = new ByteIntHashMap(delegate);
    }

    @Override
    public int get(byte key) {
        return this.delegate.get(key);
    }

    @Override
    public int getIfAbsent(byte key, int ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public int getOrThrow(byte key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public boolean containsKey(byte key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(int value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(IntProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(ByteProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(ByteIntProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public LazyByteIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<ByteIntPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableByteIntMap select(ByteIntPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableByteIntMap reject(ByteIntPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public ImmutableByteIntMap toImmutable() {
        return this;
    }

    @Override
    public IntIterator intIterator() {
        return new UnmodifiableIntIterator(this.delegate.intIterator());
    }

    @Override
    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(IntProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(IntPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableIntCollection select(IntPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableIntCollection reject(IntPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public int max() {
        return this.delegate.max();
    }

    @Override
    public int maxIfEmpty(int defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public int min() {
        return this.delegate.min();
    }

    @Override
    public int minIfEmpty(int defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public int[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableIntList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public int[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public boolean contains(int value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(int ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(IntIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableIntList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableIntSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableIntBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyIntIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableByteIntMap newWithKeyValue(byte key, int value) {
        ByteIntHashMap map2 = new ByteIntHashMap(this.size() + 1);
        map2.putAll(this);
        map2.put(key, value);
        return map2.toImmutable();
    }

    @Override
    public ImmutableByteIntMap newWithoutKey(byte key) {
        ByteIntHashMap map2 = new ByteIntHashMap(this.size());
        map2.putAll(this);
        map2.removeKey(key);
        return map2.toImmutable();
    }

    @Override
    public ImmutableByteIntMap newWithoutAllKeys(ByteIterable keys) {
        ByteIntHashMap map2 = new ByteIntHashMap(this.size());
        map2.putAll(this);
        ByteIterator iterator2 = keys.byteIterator();
        while (iterator2.hasNext()) {
            map2.removeKey(iterator2.next());
        }
        return map2.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(this.delegate.keySet());
    }

    @Override
    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableByteIntMapSerializationProxy(this);
    }

    protected static class ImmutableByteIntMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ByteIntMap map;

        public ImmutableByteIntMapSerializationProxy() {
        }

        protected ImmutableByteIntMapSerializationProxy(ByteIntMap map2) {
            this.map = map2;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedByteIntProcedure(){

                    public void safeValue(byte key, int value) throws IOException {
                        out.writeByte(key);
                        out.writeInt(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size2 = in.readInt();
            ByteIntHashMap deserializedMap = new ByteIntHashMap();
            for (int i = 0; i < size2; ++i) {
                deserializedMap.put(in.readByte(), in.readInt());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

