/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.ByteObjectPredicate;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ByteObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.MutableByteIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.ByteObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteObjectMap;
import org.eclipse.collections.api.map.primitive.MutableByteObjectMap;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ObjectLongMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.ByteSet;
import org.eclipse.collections.api.set.primitive.ImmutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.ByteObjectPair;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.bag.sorted.mutable.TreeBag;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Functions0;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.factory.PrimitiveFunctions;
import org.eclipse.collections.impl.block.factory.Procedures2;
import org.eclipse.collections.impl.block.procedure.MapCollectProcedure;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.PartitionProcedure;
import org.eclipse.collections.impl.block.procedure.SelectInstancesOfProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectBooleanProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectByteProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectCharProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectDoubleProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectFloatProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectIntProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectLongProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectShortProcedure;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.ByteObjectMaps;
import org.eclipse.collections.impl.factory.primitive.ByteSets;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyByteIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.map.mutable.primitive.ImmutableByteMapKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectDoubleHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectLongHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedByteObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableByteObjectMap;
import org.eclipse.collections.impl.map.sorted.mutable.TreeSortedMap;
import org.eclipse.collections.impl.multimap.bag.HashBagMultimap;
import org.eclipse.collections.impl.partition.bag.PartitionHashBag;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedByteSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import org.eclipse.collections.impl.set.sorted.mutable.TreeSortedSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.internal.IterableIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteObjectHashMap<V>
implements MutableByteObjectMap<V>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final byte EMPTY_KEY = 0;
    private static final byte REMOVED_KEY = 1;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 1;
    private static final int INITIAL_LINEAR_PROBE = 32;
    private byte[] keys;
    private V[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues<V> sentinelValues;
    private boolean copyKeysOnWrite = false;

    public ByteObjectHashMap() {
        this.allocateTable(16);
    }

    public ByteObjectHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    public ByteObjectHashMap(ByteObjectMap<? extends V> map2) {
        this(Math.max(map2.size(), 8));
        this.putAll(map2);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static <V> ByteObjectHashMap<V> newMap() {
        return new ByteObjectHashMap<V>();
    }

    public static <V> ByteObjectHashMap<V> newMap(ByteObjectMap<? extends V> map2) {
        return new ByteObjectHashMap<V>(map2);
    }

    public static <V> ByteObjectHashMap<V> newWithKeysValues(byte key, V value) {
        return new ByteObjectHashMap<V>(1).withKeyValue(key, (Object)value);
    }

    public static <V> ByteObjectHashMap<V> newWithKeysValues(byte key1, V value1, byte key2, V value2) {
        return new ByteObjectHashMap<V>(2).withKeysValues(key1, value1, key2, value2);
    }

    public static <V> ByteObjectHashMap<V> newWithKeysValues(byte key1, V value1, byte key2, V value2, byte key3, V value3) {
        return new ByteObjectHashMap<V>(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteObjectMap)) {
            return false;
        }
        ByteObjectMap other = (ByteObjectMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey((byte)0) || other.containsKey((byte)1)) {
                return false;
            }
        } else {
            if (!(!((SentinelValues)this.sentinelValues).containsZeroKey || other.containsKey((byte)0) && ByteObjectHashMap.nullSafeEquals(((SentinelValues)this.sentinelValues).zeroValue, other.get((byte)0)))) {
                return false;
            }
            if (!(!((SentinelValues)this.sentinelValues).containsOneKey || other.containsKey((byte)1) && ByteObjectHashMap.nullSafeEquals(((SentinelValues)this.sentinelValues).oneValue, other.get((byte)1)))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte key = this.keys[i];
            if (!ByteObjectHashMap.isNonSentinel(key) || other.containsKey(key) && ByteObjectHashMap.nullSafeEquals(this.values[i], other.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result += 0 ^ (((SentinelValues)this.sentinelValues).zeroValue == null ? 0 : ((SentinelValues)this.sentinelValues).zeroValue.hashCode());
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result += 1 ^ (((SentinelValues)this.sentinelValues).oneValue == null ? 0 : ((SentinelValues)this.sentinelValues).oneValue.hashCode());
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ (this.values[i] == null ? 0 : this.values[i].hashCode());
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                appendable.append(0).append("=").append(((SentinelValues)this.sentinelValues).zeroValue);
                first = false;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1).append("=").append(((SentinelValues)this.sentinelValues).oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte key = this.keys[i];
            if (!ByteObjectHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    @Override
    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    @Override
    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                    appendable.append(String.valueOf(((SentinelValues)this.sentinelValues).zeroValue));
                    first = false;
                }
                if (((SentinelValues)this.sentinelValues).containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(((SentinelValues)this.sentinelValues).oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                byte key = this.keys[i];
                if (!ByteObjectHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<V> iterator() {
        return new InternalIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result[index++] = ((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result[index++] = ((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result[index++] = this.values[i];
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size2 = this.size();
        final Object[] result = a.length < size2 ? (Object[])Array.newInstance(a.getClass().getComponentType(), size2) : a;
        this.forEachWithIndex((ObjectIntProcedure<? super V>)new ObjectIntProcedure<Object>(){

            @Override
            public void value(Object each2, int index) {
                result[index] = each2;
            }
        });
        if (result.length > size2) {
            result[size2] = null;
        }
        return result;
    }

    @Override
    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public boolean containsAllIterable(Iterable<?> source) {
        for (Object item : source) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> source) {
        return this.containsAllIterable(source);
    }

    @Override
    public boolean containsAllArguments(Object ... elements) {
        for (Object item : elements) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ByteObjectHashMap<V> tap(Procedure<? super V> procedure) {
        this.forEachValue(procedure);
        return this;
    }

    @Override
    public void forEach(Procedure<? super V> procedure) {
        this.each(procedure);
    }

    @Override
    public void each(Procedure<? super V> procedure) {
        this.forEachValue(procedure);
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        int index = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                objectIntProcedure.value(((SentinelValues)this.sentinelValues).zeroValue, index++);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                objectIntProcedure.value(((SentinelValues)this.sentinelValues).oneValue, index++);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            objectIntProcedure.value(this.values[i], index++);
        }
    }

    @Override
    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value(((SentinelValues)this.sentinelValues).zeroValue, parameter);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value(((SentinelValues)this.sentinelValues).oneValue, parameter);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i], parameter);
        }
    }

    @Override
    public void forEachValue(Procedure<? super V> procedure) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    @Override
    public void forEachKey(ByteProcedure procedure) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value((byte)0);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value((byte)1);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    @Override
    public void forEachKeyValue(ByteObjectProcedure<? super V> procedure) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value((byte)0, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value((byte)1, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    @Override
    public ByteObjectHashMap<V> select(ByteObjectPredicate<? super V> predicate) {
        ByteObjectHashMap<Object> result = ByteObjectHashMap.newMap();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept((byte)0, ((SentinelValues)this.sentinelValues).zeroValue)) {
                result.put((byte)0, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept((byte)1, ((SentinelValues)this.sentinelValues).oneValue)) {
                result.put((byte)1, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public ByteObjectHashMap<V> reject(ByteObjectPredicate<? super V> predicate) {
        ByteObjectHashMap<Object> result = ByteObjectHashMap.newMap();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept((byte)0, ((SentinelValues)this.sentinelValues).zeroValue)) {
                result.put((byte)0, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept((byte)1, ((SentinelValues)this.sentinelValues).oneValue)) {
                result.put((byte)1, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public MutableCollection<V> select(Predicate<? super V> predicate) {
        FastList<Object> result = FastList.newList();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                result.add(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                result.add(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            target.add(this.values[i]);
        }
        return target;
    }

    @Override
    public <P> MutableCollection<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.select((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            targetCollection.add(this.values[i]);
        }
        return targetCollection;
    }

    @Override
    public MutableCollection<V> reject(Predicate<? super V> predicate) {
        FastList<Object> result = FastList.newList();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                result.add(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                result.add(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            target.add(this.values[i]);
        }
        return target;
    }

    @Override
    public <P> MutableCollection<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.reject((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i], parameter)) continue;
            targetCollection.add(this.values[i]);
        }
        return targetCollection;
    }

    @Override
    public PartitionMutableBag<V> partition(Predicate<? super V> predicate) {
        PartitionHashBag partitionMutableBag = new PartitionHashBag();
        this.forEach((Procedure<? super V>)new PartitionProcedure<V>(predicate, partitionMutableBag));
        return partitionMutableBag;
    }

    @Override
    public <P> PartitionMutableBag<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        PartitionHashBag partitionMutableBag = new PartitionHashBag();
        this.forEach((Procedure<? super V>)new PartitionProcedure<V>(Predicates.bind(predicate, parameter), partitionMutableBag));
        return partitionMutableBag;
    }

    @Override
    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        HashBag result = HashBag.newBag(this.size());
        this.forEach((Procedure<? super V>)new SelectInstancesOfProcedure<S>(clazz, result));
        return result;
    }

    @Override
    public <VV> MutableCollection<VV> collect(Function<? super V, ? extends VV> function) {
        return this.collect(function, (R)FastList.newList(this.size()));
    }

    @Override
    public MutableBooleanCollection collectBoolean(BooleanFunction<? super V> booleanFunction) {
        return this.collectBoolean(booleanFunction, (R)new BooleanArrayList(this.size()));
    }

    @Override
    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super V> booleanFunction, R target) {
        this.forEach((Procedure<? super V>)new CollectBooleanProcedure<V>(booleanFunction, target));
        return target;
    }

    @Override
    public MutableByteCollection collectByte(ByteFunction<? super V> byteFunction) {
        return this.collectByte(byteFunction, (R)new ByteArrayList(this.size()));
    }

    @Override
    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super V> byteFunction, R target) {
        this.forEach((Procedure<? super V>)new CollectByteProcedure<V>(byteFunction, target));
        return target;
    }

    @Override
    public MutableCharCollection collectChar(CharFunction<? super V> charFunction) {
        return this.collectChar(charFunction, (R)new CharArrayList(this.size()));
    }

    @Override
    public <R extends MutableCharCollection> R collectChar(CharFunction<? super V> charFunction, R target) {
        this.forEach((Procedure<? super V>)new CollectCharProcedure<V>(charFunction, target));
        return target;
    }

    @Override
    public MutableDoubleCollection collectDouble(DoubleFunction<? super V> doubleFunction) {
        return this.collectDouble(doubleFunction, (R)new DoubleArrayList(this.size()));
    }

    @Override
    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super V> doubleFunction, R target) {
        this.forEach((Procedure<? super V>)new CollectDoubleProcedure<V>(doubleFunction, target));
        return target;
    }

    @Override
    public MutableFloatCollection collectFloat(FloatFunction<? super V> floatFunction) {
        return this.collectFloat(floatFunction, (R)new FloatArrayList(this.size()));
    }

    @Override
    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super V> floatFunction, R target) {
        this.forEach((Procedure<? super V>)new CollectFloatProcedure<V>(floatFunction, target));
        return target;
    }

    @Override
    public MutableIntCollection collectInt(IntFunction<? super V> intFunction) {
        return this.collectInt(intFunction, (R)new IntArrayList(this.size()));
    }

    @Override
    public <R extends MutableIntCollection> R collectInt(IntFunction<? super V> intFunction, R target) {
        this.forEach((Procedure<? super V>)new CollectIntProcedure<V>(intFunction, target));
        return target;
    }

    @Override
    public MutableLongCollection collectLong(LongFunction<? super V> longFunction) {
        return this.collectLong(longFunction, (R)new LongArrayList(this.size()));
    }

    @Override
    public <R extends MutableLongCollection> R collectLong(LongFunction<? super V> longFunction, R target) {
        this.forEach((Procedure<? super V>)new CollectLongProcedure<V>(longFunction, target));
        return target;
    }

    @Override
    public MutableShortCollection collectShort(ShortFunction<? super V> shortFunction) {
        return this.collectShort(shortFunction, (R)new ShortArrayList(this.size()));
    }

    @Override
    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super V> shortFunction, R target) {
        this.forEach((Procedure<? super V>)new CollectShortProcedure<V>(shortFunction, target));
        return target;
    }

    @Override
    public <P, VV> MutableCollection<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter) {
        return this.collect((Function)Functions.bind(function, parameter));
    }

    @Override
    public <P, VV, R extends Collection<VV>> R collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter, R targetCollection) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                targetCollection.add(function.value(((SentinelValues)this.sentinelValues).zeroValue, parameter));
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                targetCollection.add(function.value(((SentinelValues)this.sentinelValues).oneValue, parameter));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            targetCollection.add(function.value(this.values[i], parameter));
        }
        return targetCollection;
    }

    @Override
    public <VV, R extends Collection<VV>> R collect(Function<? super V, ? extends VV> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                target.add(function.valueOf(((SentinelValues)this.sentinelValues).zeroValue));
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                target.add(function.valueOf(((SentinelValues)this.sentinelValues).oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    @Override
    public <VV> MutableBag<VV> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function) {
        return this.collectIf(predicate, function, (R)HashBag.newBag());
    }

    @Override
    public <VV, R extends Collection<VV>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                target.add(function.valueOf(((SentinelValues)this.sentinelValues).zeroValue));
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                target.add(function.valueOf(((SentinelValues)this.sentinelValues).oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    @Override
    public <VV> MutableList<VV> flatCollect(Function<? super V, ? extends Iterable<VV>> function) {
        return this.flatCollect(function, (R)FastList.newList());
    }

    @Override
    public <VV, R extends Collection<VV>> R flatCollect(Function<? super V, ? extends Iterable<VV>> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                Iterate.addAllTo(function.valueOf(((SentinelValues)this.sentinelValues).zeroValue), target);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                Iterate.addAllTo(function.valueOf(((SentinelValues)this.sentinelValues).oneValue), target);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            Iterate.addAllTo(function.valueOf(this.values[i]), target);
        }
        return target;
    }

    @Override
    public V detect(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public <P> V detectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return function.value();
    }

    @Override
    public <P> V detectWithIfNone(Predicate2<? super V, ? super P> predicate, P parameter, Function0<? extends V> function) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            return this.values[i];
        }
        return function.value();
    }

    @Override
    public int count(Predicate<? super V> predicate) {
        int count2 = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                ++count2;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                ++count2;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public <P> int countWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        int count2 = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                ++count2;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                ++count2;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public boolean anySatisfy(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return true;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                return true;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return false;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                return false;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i], parameter)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return false;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                return false;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function) {
        IV result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.value(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.value(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.value(result, this.values[i]);
        }
        return result;
    }

    @Override
    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function) {
        int result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.intValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.intValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.intValueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function) {
        long result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.longValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.longValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.longValueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function) {
        float result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.floatValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.floatValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.floatValueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function) {
        double result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.doubleValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.doubleValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.doubleValueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    @Deprecated
    public <S> MutableBag<Pair<V, S>> zip(Iterable<S> that) {
        return this.zip(that, HashBag.newBag());
    }

    @Override
    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target) {
        return IterableIterate.zip(this, that, target);
    }

    @Override
    @Deprecated
    public MutableSet<Pair<V, Integer>> zipWithIndex() {
        return this.zipWithIndex(UnifiedSet.newSet());
    }

    @Override
    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target) {
        return IterableIterate.zipWithIndex(this, target);
    }

    @Override
    public RichIterable<RichIterable<V>> chunk(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        Iterator<V> iterator2 = this.iterator();
        MutableList<RichIterable<V>> result = Lists.mutable.of();
        while (iterator2.hasNext()) {
            FastList<V> batch = FastList.newList();
            for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
                batch.add(iterator2.next());
            }
            result.add(batch);
        }
        return result;
    }

    @Override
    public <K, VV> MutableMap<K, VV> aggregateInPlaceBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Procedure2<? super VV, ? super V> mutatingAggregator) {
        UnifiedMap map2 = UnifiedMap.newMap();
        this.forEach((Procedure<? super V>)new MutatingAggregationProcedure<V, K, VV>(map2, groupBy, zeroValueFactory, mutatingAggregator));
        return map2;
    }

    @Override
    public <K, VV> MutableMap<K, VV> aggregateBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Function2<? super VV, ? super V, ? extends VV> nonMutatingAggregator) {
        UnifiedMap map2 = UnifiedMap.newMap();
        this.forEach((Procedure<? super V>)new NonMutatingAggregationProcedure<V, K, VV>(map2, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map2;
    }

    @Override
    public <VV> MutableBagMultimap<VV, V> groupBy(Function<? super V, ? extends VV> function) {
        return this.groupBy(function, (R)HashBagMultimap.newMultimap());
    }

    @Override
    public <VV, R extends MutableMultimap<VV, V>> R groupBy(Function<? super V, ? extends VV> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                target.put(function.valueOf(((SentinelValues)this.sentinelValues).zeroValue), (Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                target.put(function.valueOf(((SentinelValues)this.sentinelValues).oneValue), (Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            target.put(function.valueOf(this.values[i]), this.values[i]);
        }
        return target;
    }

    @Override
    public <VV> MutableBagMultimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> function) {
        return this.groupByEach(function, (R)HashBagMultimap.newMultimap());
    }

    @Override
    public <VV, R extends MutableMultimap<VV, V>> R groupByEach(Function<? super V, ? extends Iterable<VV>> function, R target) {
        if (this.sentinelValues != null) {
            Iterable<VV> iterable;
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                iterable = function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
                for (VV key : iterable) {
                    target.put(key, (Object)((SentinelValues)this.sentinelValues).zeroValue);
                }
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                iterable = function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
                for (VV key : iterable) {
                    target.put(key, (Object)((SentinelValues)this.sentinelValues).oneValue);
                }
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            Iterable<VV> iterable = function.valueOf(this.values[i]);
            for (VV key : iterable) {
                target.put(key, this.values[i]);
            }
        }
        return target;
    }

    @Override
    public <VV> MutableMap<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        return this.groupByUniqueKey(function, (R)UnifiedMap.newMap());
    }

    @Override
    public <VV, R extends MutableMap<VV, V>> R groupByUniqueKey(Function<? super V, ? extends VV> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && target.put(function.valueOf(((SentinelValues)this.sentinelValues).zeroValue), (Object)((SentinelValues)this.sentinelValues).zeroValue) != null) {
                throw new IllegalStateException("Key " + function.valueOf(((SentinelValues)this.sentinelValues).zeroValue) + " already exists in map!");
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && target.put(function.valueOf(((SentinelValues)this.sentinelValues).oneValue), (Object)((SentinelValues)this.sentinelValues).oneValue) != null) {
                throw new IllegalStateException("Key " + function.valueOf(((SentinelValues)this.sentinelValues).oneValue) + " already exists in map!");
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || target.put(function.valueOf(this.values[i]), this.values[i]) == null) continue;
            throw new IllegalStateException("Key " + function.valueOf(this.values[i]) + " already exists in map!");
        }
        return target;
    }

    @Override
    public V getFirst() {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            return this.values[i];
        }
        return null;
    }

    @Override
    public V getLast() {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            return this.values[i];
        }
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
        }
        return null;
    }

    @Override
    public MutableList<V> toList() {
        MutableList list = Lists.mutable.of();
        this.forEachWith(Procedures2.addToCollection(), (P)list);
        return list;
    }

    @Override
    public MutableList<V> toSortedList() {
        return this.toList().sortThis();
    }

    @Override
    public MutableList<V> toSortedList(Comparator<? super V> comparator) {
        return this.toList().sortThis(comparator);
    }

    @Override
    public <VV extends Comparable<? super VV>> MutableList<V> toSortedListBy(Function<? super V, ? extends VV> function) {
        return this.toList().sortThis(Comparators.byFunction(function));
    }

    @Override
    public MutableSet<V> toSet() {
        UnifiedSet set = UnifiedSet.newSet();
        this.forEachWith(Procedures2.addToCollection(), (P)set);
        return set;
    }

    @Override
    public MutableSortedSet<V> toSortedSet() {
        TreeSortedSet set = TreeSortedSet.newSet();
        this.forEachWith(Procedures2.addToCollection(), (P)set);
        return set;
    }

    @Override
    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator) {
        TreeSortedSet<? super V> set = TreeSortedSet.newSet(comparator);
        this.forEachWith(Procedures2.addToCollection(), (P)set);
        return set;
    }

    @Override
    public <VV extends Comparable<? super VV>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends VV> function) {
        TreeSortedSet<? super V> set = TreeSortedSet.newSet(Comparators.byFunction(function));
        this.forEachWith(Procedures2.addToCollection(), (P)set);
        return set;
    }

    @Override
    public MutableBag<V> toBag() {
        MutableBag bag = Bags.mutable.of();
        this.forEachWith(Procedures2.addToCollection(), (P)bag);
        return bag;
    }

    @Override
    public MutableSortedBag<V> toSortedBag() {
        TreeBag sortedBag = TreeBag.newBag();
        this.forEachWith(Procedures2.addToCollection(), (P)sortedBag);
        return sortedBag;
    }

    @Override
    public MutableSortedBag<V> toSortedBag(Comparator<? super V> comparator) {
        TreeBag<? super V> sortedBag = TreeBag.newBag(comparator);
        this.forEachWith(Procedures2.addToCollection(), (P)sortedBag);
        return sortedBag;
    }

    @Override
    public <VV extends Comparable<? super VV>> MutableSortedBag<V> toSortedBagBy(Function<? super V, ? extends VV> function) {
        return this.toSortedBag((Comparator<? super V>)Comparators.byFunction(function));
    }

    @Override
    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        UnifiedMap map2 = UnifiedMap.newMap();
        this.forEach((Procedure<? super V>)new MapCollectProcedure<V, NK, NV>(map2, keyFunction, valueFunction));
        return map2;
    }

    @Override
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.toSortedMap((Comparator<? super NK>)Comparators.naturalOrder(), keyFunction, valueFunction);
    }

    @Override
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        TreeSortedMap sortedMap = TreeSortedMap.newMap(comparator);
        this.forEach((Procedure<? super V>)new MapCollectProcedure<V, NK, NV>(sortedMap, keyFunction, valueFunction));
        return sortedMap;
    }

    @Override
    public LazyIterable<V> asLazy() {
        return LazyIterate.adapt(this);
    }

    @Override
    public V min(Comparator<? super V> comparator) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object min2 = null;
        boolean isMinSet = false;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                min2 = ((SentinelValues)this.sentinelValues).zeroValue;
                isMinSet = true;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && (!isMinSet || comparator.compare(min2, ((SentinelValues)this.sentinelValues).oneValue) > 0)) {
                min2 = ((SentinelValues)this.sentinelValues).oneValue;
                isMinSet = true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || isMinSet && comparator.compare(min2, this.values[i]) <= 0) continue;
            min2 = this.values[i];
            isMinSet = true;
        }
        return (V)min2;
    }

    @Override
    public V max(Comparator<? super V> comparator) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object max2 = null;
        boolean isMaxSet = false;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                max2 = ((SentinelValues)this.sentinelValues).zeroValue;
                isMaxSet = true;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && (!isMaxSet || comparator.compare(max2, ((SentinelValues)this.sentinelValues).oneValue) < 0)) {
                max2 = ((SentinelValues)this.sentinelValues).oneValue;
                isMaxSet = true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || isMaxSet && comparator.compare(max2, this.values[i]) >= 0) continue;
            max2 = this.values[i];
            isMaxSet = true;
        }
        return (V)max2;
    }

    @Override
    public V min() {
        return (V)this.min(Comparators.naturalOrder());
    }

    @Override
    public V max() {
        return (V)this.max(Comparators.naturalOrder());
    }

    @Override
    public <VV extends Comparable<? super VV>> V maxBy(Function<? super V, ? extends VV> function) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object max2 = null;
        boolean isMaxSet = false;
        Comparable maxValue = null;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                max2 = ((SentinelValues)this.sentinelValues).zeroValue;
                isMaxSet = true;
                maxValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                Comparable nextValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
                if (!isMaxSet || nextValue.compareTo(maxValue) > 0) {
                    max2 = ((SentinelValues)this.sentinelValues).oneValue;
                    isMaxSet = true;
                    maxValue = nextValue;
                }
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            V next = this.values[i];
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (isMaxSet && nextValue.compareTo(maxValue) <= 0) continue;
            max2 = next;
            isMaxSet = true;
            maxValue = nextValue;
        }
        return (V)max2;
    }

    @Override
    public <VV extends Comparable<? super VV>> V minBy(Function<? super V, ? extends VV> function) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object min2 = null;
        boolean isMinSet = false;
        Comparable minValue = null;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                min2 = ((SentinelValues)this.sentinelValues).zeroValue;
                isMinSet = true;
                minValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                Comparable nextValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
                if (!isMinSet || nextValue.compareTo(minValue) < 0) {
                    min2 = ((SentinelValues)this.sentinelValues).oneValue;
                    isMinSet = true;
                    minValue = nextValue;
                }
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            V next = this.values[i];
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (isMinSet && nextValue.compareTo(minValue) >= 0) continue;
            min2 = next;
            isMinSet = true;
            minValue = nextValue;
        }
        return (V)min2;
    }

    @Override
    public long sumOfInt(IntFunction<? super V> function) {
        long sum2 = 0L;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                sum2 += (long)function.intValueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                sum2 += (long)function.intValueOf(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            sum2 += (long)function.intValueOf(this.values[i]);
        }
        return sum2;
    }

    @Override
    public double sumOfFloat(FloatFunction<? super V> function) {
        double sum2 = 0.0;
        double compensation = 0.0;
        if (this.sentinelValues != null) {
            double nextSum;
            double adjustedValue;
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                adjustedValue = (double)function.floatValueOf(((SentinelValues)this.sentinelValues).zeroValue) - compensation;
                nextSum = sum2 + adjustedValue;
                compensation = nextSum - sum2 - adjustedValue;
                sum2 = nextSum;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                adjustedValue = (double)function.floatValueOf(((SentinelValues)this.sentinelValues).oneValue) - compensation;
                nextSum = sum2 + adjustedValue;
                compensation = nextSum - sum2 - adjustedValue;
                sum2 = nextSum;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            double adjustedValue = (double)function.floatValueOf(this.values[i]) - compensation;
            double nextSum = sum2 + adjustedValue;
            compensation = nextSum - sum2 - adjustedValue;
            sum2 = nextSum;
        }
        return sum2;
    }

    @Override
    public long sumOfLong(LongFunction<? super V> function) {
        long sum2 = 0L;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                sum2 += function.longValueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                sum2 += function.longValueOf(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            sum2 += function.longValueOf(this.values[i]);
        }
        return sum2;
    }

    @Override
    public double sumOfDouble(DoubleFunction<? super V> function) {
        double sum2 = 0.0;
        double compensation = 0.0;
        if (this.sentinelValues != null) {
            double nextSum;
            double adjustedValue;
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                adjustedValue = function.doubleValueOf(((SentinelValues)this.sentinelValues).zeroValue) - compensation;
                nextSum = sum2 + adjustedValue;
                compensation = nextSum - sum2 - adjustedValue;
                sum2 = nextSum;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                adjustedValue = function.doubleValueOf(((SentinelValues)this.sentinelValues).oneValue) - compensation;
                nextSum = sum2 + adjustedValue;
                compensation = nextSum - sum2 - adjustedValue;
                sum2 = nextSum;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            double adjustedValue = function.doubleValueOf(this.values[i]) - compensation;
            double nextSum = sum2 + adjustedValue;
            compensation = nextSum - sum2 - adjustedValue;
            sum2 = nextSum;
        }
        return sum2;
    }

    @Override
    public <V1> ObjectLongMap<V1> sumByInt(Function<V, V1> groupBy, IntFunction<? super V> function) {
        ObjectLongHashMap result = ObjectLongHashMap.newMap();
        return this.injectInto((IV)result, (Function2)PrimitiveFunctions.sumByIntFunction(groupBy, function));
    }

    @Override
    public <V1> ObjectDoubleMap<V1> sumByFloat(Function<V, V1> groupBy, FloatFunction<? super V> function) {
        ObjectDoubleHashMap result = ObjectDoubleHashMap.newMap();
        return this.injectInto((IV)result, (Function2)PrimitiveFunctions.sumByFloatFunction(groupBy, function));
    }

    @Override
    public <V1> ObjectLongMap<V1> sumByLong(Function<V, V1> groupBy, LongFunction<? super V> function) {
        ObjectLongHashMap result = ObjectLongHashMap.newMap();
        return this.injectInto((IV)result, (Function2)PrimitiveFunctions.sumByLongFunction(groupBy, function));
    }

    @Override
    public <V1> ObjectDoubleMap<V1> sumByDouble(Function<V, V1> groupBy, DoubleFunction<? super V> function) {
        ObjectDoubleHashMap result = ObjectDoubleHashMap.newMap();
        return this.injectInto((IV)result, (Function2)PrimitiveFunctions.sumByDoubleFunction(groupBy, function));
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.keys = new byte[this.keys.length];
            this.copyKeysOnWrite = false;
        }
        Arrays.fill(this.keys, (byte)0);
        Arrays.fill(this.values, null);
    }

    @Override
    public V put(byte key, V value) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).zeroValue;
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return (V)oldValue;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).oneValue;
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return (V)oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            V oldValue = this.values[index];
            this.values[index] = value;
            return oldValue;
        }
        this.addKeyValueAtIndex(key, value, index);
        return null;
    }

    @Override
    public void putAll(ByteObjectMap<? extends V> map2) {
        map2.forEachKeyValue(new ByteObjectProcedure<V>(){

            @Override
            public void value(byte key, V value) {
                ByteObjectHashMap.this.put(key, value);
            }
        });
    }

    @Override
    public boolean containsKey(byte key) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && ((SentinelValues)this.sentinelValues).containsZeroKey;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && ((SentinelValues)this.sentinelValues).containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i]) || !ByteObjectHashMap.nullSafeEquals(this.values[i], value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(byte key) {
        return (V)this.getIfAbsent(key, Functions0.nullValue());
    }

    @Override
    public V getIfAbsent(byte key, Function0<? extends V> ifAbsent) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsZeroKey) {
                return ifAbsent.value();
            }
            return (V)((SentinelValues)this.sentinelValues).zeroValue;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsOneKey) {
                return ifAbsent.value();
            }
            return (V)((SentinelValues)this.sentinelValues).oneValue;
        }
        int index = this.probe(key);
        if (this.keys[this.probe(key)] == key) {
            return this.values[index];
        }
        return ifAbsent.value();
    }

    @Override
    public V getIfAbsentPut(byte key, V value) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return value;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public V getIfAbsentPut(byte key, Function0<? extends V> function) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                V value = function.value();
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            V value = function.value();
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return value;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                V value = function.value();
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            V value = function.value();
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        V value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> V getIfAbsentPutWith(byte key, Function<? super P, ? extends V> function, P parameter) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                V value = function.valueOf(parameter);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            V value = function.valueOf(parameter);
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return value;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                V value = function.valueOf(parameter);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            V value = function.valueOf(parameter);
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        V value = function.valueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public V getIfAbsentPutWithKey(byte key, ByteToObjectFunction<? extends V> function) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                V value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            V value = function.valueOf(key);
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return value;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                V value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            V value = function.valueOf(key);
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        V value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public V updateValue(byte key, Function0<? extends V> factory, Function<? super V, ? extends V> function) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.valueOf(factory.value());
            } else if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                ((SentinelValues)this.sentinelValues).zeroValue = function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
            } else {
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.valueOf(factory.value());
            }
            return (V)((SentinelValues)this.sentinelValues).zeroValue;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.valueOf(factory.value());
            } else if (((SentinelValues)this.sentinelValues).containsOneKey) {
                ((SentinelValues)this.sentinelValues).oneValue = function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
            } else {
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.valueOf(factory.value());
            }
            return (V)((SentinelValues)this.sentinelValues).oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        V value = function.valueOf(factory.value());
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> V updateValueWith(byte key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.value(factory.value(), parameter);
            } else if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                ((SentinelValues)this.sentinelValues).zeroValue = function.value(((SentinelValues)this.sentinelValues).zeroValue, parameter);
            } else {
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.value(factory.value(), parameter);
            }
            return (V)((SentinelValues)this.sentinelValues).zeroValue;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.value(factory.value(), parameter);
            } else if (((SentinelValues)this.sentinelValues).containsOneKey) {
                ((SentinelValues)this.sentinelValues).oneValue = function.value(((SentinelValues)this.sentinelValues).oneValue, parameter);
            } else {
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.value(factory.value(), parameter);
            }
            return (V)((SentinelValues)this.sentinelValues).oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.value(this.values[index], parameter);
            return this.values[index];
        }
        V value = function.value(factory.value(), parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public V removeKey(byte key) {
        if (ByteObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsZeroKey) {
                return null;
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).zeroValue;
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                ((SentinelValues)this.sentinelValues).containsZeroKey = false;
                ((SentinelValues)this.sentinelValues).zeroValue = null;
            } else {
                this.sentinelValues = null;
            }
            return (V)oldValue;
        }
        if (ByteObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsOneKey) {
                return null;
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).oneValue;
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                ((SentinelValues)this.sentinelValues).containsOneKey = false;
                ((SentinelValues)this.sentinelValues).oneValue = null;
            } else {
                this.sentinelValues = null;
            }
            return (V)oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            V oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return null;
    }

    @Override
    public V remove(byte key) {
        return this.removeKey(key);
    }

    @Override
    public ByteObjectHashMap<V> withKeyValue(byte key, V value) {
        this.put(key, value);
        return this;
    }

    @Override
    public MutableByteObjectMap<V> withoutKey(byte key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public MutableByteObjectMap<V> withoutAllKeys(ByteIterable keys) {
        ByteIterator iterator2 = keys.byteIterator();
        while (iterator2.hasNext()) {
            byte item = iterator2.next();
            this.removeKey(item);
        }
        return this;
    }

    public ByteObjectHashMap<V> withKeysValues(byte key1, V value1, byte key2, V value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ByteObjectHashMap<V> withKeysValues(byte key1, V value1, byte key2, V value2, byte key3, V value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ByteObjectHashMap<V> withKeysValues(byte key1, V value1, byte key2, V value2, byte key3, V value3, byte key4, V value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    @Override
    public MutableByteObjectMap<V> asUnmodifiable() {
        return new UnmodifiableByteObjectMap(this);
    }

    @Override
    public MutableByteObjectMap<V> asSynchronized() {
        return new SynchronizedByteObjectMap(this);
    }

    @Override
    public ImmutableByteObjectMap<V> toImmutable() {
        return ByteObjectMaps.immutable.withAll(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                out.writeByte(0);
                out.writeObject(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                out.writeByte(1);
                out.writeObject(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeByte(this.keys[i]);
            out.writeObject(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        for (int i = 0; i < size2; ++i) {
            this.put(in.readByte(), in.readObject());
        }
    }

    private void addKeyValueAtIndex(byte key, V value, int index) {
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = 1;
        this.values[index] = null;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
        if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
            this.rehash();
        }
    }

    private void copyKeys() {
        byte[] copy = new byte[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    @Override
    public MutableByteSet keySet() {
        return new KeySet();
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        byte[] old = this.keys;
        V[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ByteObjectHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
        this.copyKeysOnWrite = false;
    }

    int probe(byte element) {
        int index = this.spreadAndMask(element);
        byte keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spreadAndMask(byte element) {
        return this.mask(element);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new byte[sizeToAllocate];
        this.values = new Object[sizeToAllocate];
    }

    private static boolean isEmptyKey(byte key) {
        return key == 0;
    }

    private static boolean isRemovedKey(byte key) {
        return key == 1;
    }

    private static boolean isNonSentinel(byte key) {
        return !ByteObjectHashMap.isEmptyKey(key) && !ByteObjectHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    @Override
    public Collection<V> values() {
        return new ValuesCollection();
    }

    @Override
    public LazyByteIterable keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<ByteObjectPair<V>> keyValuesView() {
        return new KeyValuesView();
    }

    static /* synthetic */ byte[] access$802(ByteObjectHashMap x0, byte[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$1002(ByteObjectHashMap x0, Object[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<ByteObjectPair<V>> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super ByteObjectPair<V>> procedure) {
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair((byte)0, ByteObjectHashMap.this.sentinelValues.zeroValue));
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair((byte)1, ByteObjectHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < ByteObjectHashMap.this.keys.length; ++i) {
                if (!ByteObjectHashMap.isNonSentinel(ByteObjectHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ByteObjectHashMap.this.keys[i], ByteObjectHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ByteObjectPair<V>> objectIntProcedure) {
            int index = 0;
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair((byte)0, ByteObjectHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair((byte)1, ByteObjectHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < ByteObjectHashMap.this.keys.length; ++i) {
                if (!ByteObjectHashMap.isNonSentinel(ByteObjectHashMap.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(ByteObjectHashMap.this.keys[i], ByteObjectHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ByteObjectPair<V>, ? super P> procedure, P parameter) {
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair((byte)0, ByteObjectHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair((byte)1, ByteObjectHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < ByteObjectHashMap.this.keys.length; ++i) {
                if (!ByteObjectHashMap.isNonSentinel(ByteObjectHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ByteObjectHashMap.this.keys[i], ByteObjectHashMap.this.values[i]), parameter);
            }
        }

        @Override
        public Iterator<ByteObjectPair<V>> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<ByteObjectPair<V>> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public ByteObjectPair<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (ByteObjectHashMap.this.containsKey((byte)0)) {
                        return PrimitiveTuples.pair((byte)0, ByteObjectHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (ByteObjectHashMap.this.containsKey((byte)1)) {
                        return PrimitiveTuples.pair((byte)1, ByteObjectHashMap.this.sentinelValues.oneValue);
                    }
                }
                byte[] keys = ByteObjectHashMap.this.keys;
                while (!ByteObjectHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ByteObjectPair<Object> result = PrimitiveTuples.pair(keys[this.position], ByteObjectHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ByteObjectHashMap.this.size();
            }
        }
    }

    private class KeysView
    extends AbstractLazyByteIterable {
        private KeysView() {
        }

        public ByteIterator byteIterator() {
            return new UnmodifiableByteIterator(new KeysSetIterator());
        }

        public void forEach(ByteProcedure procedure) {
            this.each(procedure);
        }

        public void each(ByteProcedure procedure) {
            ByteObjectHashMap.this.forEachKey(procedure);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ValuesCollection
    implements Collection<V> {
        protected ValuesCollection() {
        }

        @Override
        public boolean add(V v) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public void clear() {
            ByteObjectHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return ByteObjectHashMap.this.containsValue(o);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return Iterate.allSatisfy(collection, Predicates.in(this));
        }

        @Override
        public boolean isEmpty() {
            return ByteObjectHashMap.this.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return ByteObjectHashMap.this.iterator();
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    if (it.next() != null) continue;
                    it.remove();
                    return true;
                }
            } else {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    Object o2 = it.next();
                    if (o != o2 && !o2.equals(o)) continue;
                    it.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object obj : collection) {
                if (!this.remove(obj)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            Iterator e = this.iterator();
            while (e.hasNext()) {
                if (collection.contains(e.next())) continue;
                e.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public int size() {
            return ByteObjectHashMap.this.size();
        }

        @Override
        public Object[] toArray() {
            return ByteObjectHashMap.this.toArray();
        }

        @Override
        public <T> T[] toArray(T[] result) {
            return ByteObjectHashMap.this.toArray(result);
        }
    }

    private class KeysSetIterator
    implements MutableByteIterator {
        private int count;
        private int position;
        private byte lastKey;
        private boolean handledZeroKey;
        private boolean handledOneKey;
        private boolean canRemove;

        private KeysSetIterator() {
        }

        public boolean hasNext() {
            return this.count != ByteObjectHashMap.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZeroKey) {
                this.handledZeroKey = true;
                if (ByteObjectHashMap.this.containsKey((byte)0)) {
                    this.lastKey = 0;
                    return this.lastKey;
                }
            }
            if (!this.handledOneKey) {
                this.handledOneKey = true;
                if (ByteObjectHashMap.this.containsKey((byte)1)) {
                    this.lastKey = 1;
                    return this.lastKey;
                }
            }
            byte[] keys = ByteObjectHashMap.this.keys;
            while (!ByteObjectHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            ByteObjectHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableByteSet {
        private KeySet() {
        }

        @Override
        public MutableByteIterator byteIterator() {
            return new KeysSetIterator();
        }

        @Override
        public void forEach(ByteProcedure procedure) {
            this.each(procedure);
        }

        @Override
        public void each(ByteProcedure procedure) {
            ByteObjectHashMap.this.forEachKey(procedure);
        }

        @Override
        public int count(BytePredicate predicate) {
            int count2 = 0;
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    ++count2;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    ++count2;
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count2;
            }
            return count2;
        }

        @Override
        public boolean anySatisfy(BytePredicate predicate) {
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return true;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return true;
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
            T result = injectedValue;
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, (byte)0);
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, (byte)1);
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key)) continue;
                result = function.valueOf(result, key);
            }
            return result;
        }

        @Override
        public boolean allSatisfy(BytePredicate predicate) {
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((byte)0)) {
                    return false;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey && !predicate.accept((byte)1)) {
                    return false;
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean noneSatisfy(BytePredicate predicate) {
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return false;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return false;
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean add(byte element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(byte ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(ByteIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(byte key) {
            int oldSize = ByteObjectHashMap.this.size();
            ByteObjectHashMap.this.removeKey(key);
            return oldSize != ByteObjectHashMap.this.size();
        }

        @Override
        public boolean removeAll(ByteIterable source) {
            int oldSize = ByteObjectHashMap.this.size();
            ByteIterator iterator2 = source.byteIterator();
            while (iterator2.hasNext()) {
                ByteObjectHashMap.this.removeKey(iterator2.next());
            }
            return oldSize != ByteObjectHashMap.this.size();
        }

        @Override
        public boolean removeAll(byte ... source) {
            int oldSize = ByteObjectHashMap.this.size();
            for (byte item : source) {
                ByteObjectHashMap.this.removeKey(item);
            }
            return oldSize != ByteObjectHashMap.this.size();
        }

        @Override
        public boolean retainAll(ByteIterable source) {
            int oldSize = this.size();
            final ByteSet sourceSet = source instanceof ByteSet ? (ByteSet)source : source.toSet();
            MutableByteObjectMap retained = ByteObjectHashMap.this.select(new ByteObjectPredicate<V>(){

                @Override
                public boolean accept(byte key, V value) {
                    return sourceSet.contains(key);
                }
            });
            if (((ByteObjectHashMap)retained).size() != oldSize) {
                ByteObjectHashMap.access$802(ByteObjectHashMap.this, ((ByteObjectHashMap)retained).keys);
                ByteObjectHashMap.access$1002(ByteObjectHashMap.this, ((ByteObjectHashMap)retained).values);
                ByteObjectHashMap.this.sentinelValues = ((ByteObjectHashMap)retained).sentinelValues;
                ByteObjectHashMap.this.occupiedWithData = ((ByteObjectHashMap)retained).occupiedWithData;
                ByteObjectHashMap.this.occupiedWithSentinels = ((ByteObjectHashMap)retained).occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(byte ... source) {
            return this.retainAll(ByteHashSet.newSetWith(source));
        }

        @Override
        public void clear() {
            ByteObjectHashMap.this.clear();
        }

        @Override
        public MutableByteSet select(BytePredicate predicate) {
            ByteHashSet result = new ByteHashSet();
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    result.add((byte)0);
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    result.add((byte)1);
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        @Override
        public MutableByteSet reject(BytePredicate predicate) {
            ByteHashSet result = new ByteHashSet();
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey && !predicate.accept((byte)0)) {
                    result.add((byte)0);
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey && !predicate.accept((byte)1)) {
                    result.add((byte)1);
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        @Override
        public MutableByteSet with(byte element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableByteSet without(byte element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableByteSet withAll(ByteIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableByteSet withoutAll(ByteIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public byte detectIfNone(BytePredicate predicate, byte ifNone) {
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept((byte)0)) {
                    return 0;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept((byte)1)) {
                    return 1;
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        @Override
        public <V> MutableSet<V> collect(ByteToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf((byte)0));
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf((byte)1));
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        @Override
        public MutableByteSet asUnmodifiable() {
            return UnmodifiableByteSet.of(this);
        }

        @Override
        public MutableByteSet asSynchronized() {
            return SynchronizedByteSet.of(this);
        }

        @Override
        public long sum() {
            long result = 0L;
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0L;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (byte key : ByteObjectHashMap.this.keys) {
                if (!ByteObjectHashMap.isNonSentinel(key)) continue;
                result += (long)key;
            }
            return result;
        }

        @Override
        public byte max() {
            if (ByteObjectHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            byte max2 = 0;
            boolean isMaxSet = false;
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey) {
                    max2 = 0;
                    isMaxSet = true;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey) {
                    max2 = 1;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < ByteObjectHashMap.this.keys.length; ++i) {
                if (!ByteObjectHashMap.isNonSentinel(ByteObjectHashMap.this.keys[i]) || isMaxSet && max2 >= ByteObjectHashMap.this.keys[i]) continue;
                max2 = ByteObjectHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max2;
        }

        @Override
        public byte maxIfEmpty(byte defaultValue) {
            if (ByteObjectHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        @Override
        public byte min() {
            if (ByteObjectHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            byte min2 = 0;
            boolean isMinSet = false;
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey) {
                    min2 = 0;
                    isMinSet = true;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey && !isMinSet) {
                    min2 = 1;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < ByteObjectHashMap.this.keys.length; ++i) {
                if (!ByteObjectHashMap.isNonSentinel(ByteObjectHashMap.this.keys[i]) || isMinSet && ByteObjectHashMap.this.keys[i] >= min2) continue;
                min2 = ByteObjectHashMap.this.keys[i];
                isMinSet = true;
            }
            return min2;
        }

        @Override
        public byte minIfEmpty(byte defaultValue) {
            if (ByteObjectHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        @Override
        public double average() {
            if (ByteObjectHashMap.this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        @Override
        public double median() {
            if (ByteObjectHashMap.this.isEmpty()) {
                throw new ArithmeticException();
            }
            byte[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                byte first = sortedArray[middleIndex];
                byte second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        @Override
        public byte[] toSortedArray() {
            byte[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        @Override
        public MutableByteList toSortedList() {
            return ByteArrayList.newList(this).sortThis();
        }

        @Override
        public byte[] toArray() {
            int size2 = ByteObjectHashMap.this.size();
            final byte[] result = new byte[size2];
            ByteObjectHashMap.this.forEachKey(new ByteProcedure(){
                private int index;

                public void value(byte each2) {
                    result[this.index] = each2;
                    ++this.index;
                }
            });
            return result;
        }

        @Override
        public boolean contains(byte value) {
            return ByteObjectHashMap.this.containsKey(value);
        }

        @Override
        public boolean containsAll(byte ... source) {
            for (byte item : source) {
                if (ByteObjectHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(ByteIterable source) {
            ByteIterator iterator2 = source.byteIterator();
            while (iterator2.hasNext()) {
                if (ByteObjectHashMap.this.containsKey(iterator2.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public MutableByteList toList() {
            return ByteArrayList.newList(this);
        }

        @Override
        public MutableByteSet toSet() {
            return ByteHashSet.newSet(this);
        }

        @Override
        public MutableByteBag toBag() {
            return ByteHashBag.newBag(this);
        }

        @Override
        public LazyByteIterable asLazy() {
            return new LazyByteIterableAdapter(this);
        }

        @Override
        public ByteSet freeze() {
            ByteObjectHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (ByteObjectHashMap.this.sentinelValues != null) {
                containsZeroKey = ByteObjectHashMap.this.sentinelValues.containsZeroKey;
                containsOneKey = ByteObjectHashMap.this.sentinelValues.containsOneKey;
            }
            return new ImmutableByteMapKeySet(ByteObjectHashMap.this.keys, ByteObjectHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }

        @Override
        public ImmutableByteSet toImmutable() {
            return ByteSets.immutable.withAll(this);
        }

        @Override
        public int size() {
            return ByteObjectHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ByteObjectHashMap.this.isEmpty();
        }

        @Override
        public boolean notEmpty() {
            return ByteObjectHashMap.this.notEmpty();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ByteSet)) {
                return false;
            }
            ByteSet other = (ByteSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        @Override
        public int hashCode() {
            int result = 0;
            if (ByteObjectHashMap.this.sentinelValues != null) {
                if (ByteObjectHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (ByteObjectHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < ByteObjectHashMap.this.keys.length; ++i) {
                if (!ByteObjectHashMap.isNonSentinel(ByteObjectHashMap.this.keys[i])) continue;
                result += ByteObjectHashMap.this.keys[i];
            }
            return result;
        }

        @Override
        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        @Override
        public String makeString() {
            return this.makeString(", ");
        }

        @Override
        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        @Override
        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        @Override
        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        @Override
        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        @Override
        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (ByteObjectHashMap.this.sentinelValues != null) {
                    if (ByteObjectHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (ByteObjectHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (byte key : ByteObjectHashMap.this.keys) {
                    if (!ByteObjectHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalIterator
    implements Iterator<V> {
        private int count;
        private int position;
        private byte currentKey;
        private boolean isCurrentKeySet;
        private boolean handledZeroKey;
        private boolean handledOneKey;

        private InternalIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count != ByteObjectHashMap.this.size();
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            if (!this.handledZeroKey) {
                this.handledZeroKey = true;
                if (ByteObjectHashMap.this.containsKey((byte)0)) {
                    this.currentKey = 0;
                    this.isCurrentKeySet = true;
                    return ByteObjectHashMap.this.sentinelValues.zeroValue;
                }
            }
            if (!this.handledOneKey) {
                this.handledOneKey = true;
                if (ByteObjectHashMap.this.containsKey((byte)1)) {
                    this.currentKey = 1;
                    this.isCurrentKeySet = true;
                    return ByteObjectHashMap.this.sentinelValues.oneValue;
                }
            }
            byte[] keys = ByteObjectHashMap.this.keys;
            while (!ByteObjectHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.currentKey = ByteObjectHashMap.this.keys[this.position];
            this.isCurrentKeySet = true;
            Object result = ByteObjectHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (ByteObjectHashMap.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                ByteObjectHashMap.this.removeKeyAtIndex(index);
            } else {
                ByteObjectHashMap.this.removeKey(this.currentKey);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SentinelValues<V> {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private V zeroValue;
        private V oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(V value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && ByteObjectHashMap.nullSafeEquals(this.zeroValue, value);
            boolean valueEqualsOneValue = this.containsOneKey && ByteObjectHashMap.nullSafeEquals(this.oneValue, value);
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

