/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap.list;

import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.multimap.list.ImmutableListMultimap;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.AbstractMutableMultimap;
import org.eclipse.collections.impl.multimap.bag.HashBagMultimap;
import org.eclipse.collections.impl.multimap.list.FastListMultimap;
import org.eclipse.collections.impl.multimap.list.ImmutableListMultimapImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutableListMultimap<K, V>
extends AbstractMutableMultimap<K, V, MutableList<V>>
implements MutableListMultimap<K, V> {
    protected AbstractMutableListMultimap() {
    }

    protected AbstractMutableListMultimap(Pair<K, V> ... pairs) {
        super(pairs);
    }

    protected AbstractMutableListMultimap(Iterable<Pair<K, V>> inputIterable) {
        super(inputIterable);
    }

    protected AbstractMutableListMultimap(int size2) {
        super(size2);
    }

    @Override
    public MutableListMultimap<K, V> toMutable() {
        return new FastListMultimap(this);
    }

    @Override
    public ImmutableListMultimap<K, V> toImmutable() {
        final UnifiedMap map2 = UnifiedMap.newMap();
        this.map.forEachKeyValue(new Procedure2<K, MutableList<V>>(){

            @Override
            public void value(K key, MutableList<V> list) {
                map2.put(key, list.toImmutable());
            }
        });
        return new ImmutableListMultimapImpl(map2);
    }

    @Override
    public <K2, V2> HashBagMultimap<K2, V2> collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return this.collectKeysValues(function, HashBagMultimap.newMultimap());
    }

    @Override
    public <V2> FastListMultimap<K, V2> collectValues(Function<? super V, ? extends V2> function) {
        return this.collectValues(function, FastListMultimap.newMultimap());
    }
}

