/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal;

import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.set.sorted.ImmutableSortedSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.set.sorted.SortedSetIterable;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.set.sorted.mutable.TreeSortedSet;
import org.eclipse.collections.impl.utility.Iterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SortedSetIterables {
    private SortedSetIterables() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> MutableSortedSet<MutableSortedSet<T>> powerSet(SortedSet<T> set) {
        Comparator<T> comparator = set.comparator();
        TreeSortedSet<T> innerTree = TreeSortedSet.newSet(comparator);
        TreeSortedSet sortedSetIterables = TreeSortedSet.newSet(Comparators.powerSet());
        MutableCollection seed = sortedSetIterables.with(innerTree);
        return (MutableSortedSet)Iterate.injectInto(seed, set, new Function2<MutableSortedSet<MutableSortedSet<T>>, T, MutableSortedSet<MutableSortedSet<T>>>(){

            @Override
            public MutableSortedSet<MutableSortedSet<T>> value(MutableSortedSet<MutableSortedSet<T>> accumulator, final T element) {
                return accumulator.union(accumulator.collect(new Function<MutableSortedSet<T>, MutableSortedSet<T>>(){

                    @Override
                    public MutableSortedSet<T> valueOf(MutableSortedSet<T> set) {
                        MutableSortedSet newSet = set.clone();
                        newSet.add(element);
                        return newSet;
                    }
                }).toSet());
            }
        });
    }

    public static <T> ImmutableSortedSet<ImmutableSortedSet<T>> immutablePowerSet(SortedSet<T> set) {
        return SortedSetIterables.powerSet(set).collect(new Function<MutableSortedSet<T>, ImmutableSortedSet<T>>(){

            @Override
            public ImmutableSortedSet<T> valueOf(MutableSortedSet<T> set) {
                return set.toImmutable();
            }
        }, TreeSortedSet.newSet(Comparators.powerSet())).toImmutable();
    }

    public static <T> int compare(SortedSetIterable<T> setA, SortedSetIterable<T> setB) {
        Iterator itrA = setA.iterator();
        Iterator itrB = setB.iterator();
        if (setA.comparator() != null) {
            Comparator comparator = setA.comparator();
            while (itrA.hasNext()) {
                if (itrB.hasNext()) {
                    int val = comparator.compare(itrA.next(), itrB.next());
                    if (val == 0) continue;
                    return val;
                }
                return 1;
            }
            return itrB.hasNext() ? -1 : 0;
        }
        while (itrA.hasNext()) {
            if (itrB.hasNext()) {
                int val = ((Comparable)itrA.next()).compareTo(itrB.next());
                if (val == 0) continue;
                return val;
            }
            return 1;
        }
        return itrB.hasNext() ? -1 : 0;
    }
}

