/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ConstantsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DBException;
import org.mapdb.StoreTrivial;
import org.mapdb.StoreTx;
import org.mapdb.Utils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0011\u0010\u001b\u001a\u0004\u0018\u00010\u0012H\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0012H\u0004J\b\u0010#\u001a\u00020\u0019H\u0016R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lorg/mapdb/StoreTrivialTx;", "Lorg/mapdb/StoreTrivial;", "Lorg/mapdb/StoreTx;", "file", "Ljava/io/File;", "isThreadSafe", "", "deleteFilesAfterClose", "(Ljava/io/File;ZZ)V", "getDeleteFilesAfterClose", "()Z", "getFile", "()Ljava/io/File;", "fileChannel", "Ljava/nio/channels/FileChannel;", "fileLock", "Ljava/nio/channels/FileLock;", "lastFileNum", "", "path", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getPath", "()Ljava/nio/file/Path;", "close", "", "commit", "findLattestCommitMarker", "findLattestCommitMarker$mapdb", "()Ljava/lang/Long;", "getAllFiles", "", "", "loadFrom", "number", "rollback", "Companion", "mapdb"})
public final class StoreTrivialTx
extends StoreTrivial
implements StoreTx {
    private final Path path;
    private final FileChannel fileChannel;
    private final FileLock fileLock;
    private long lastFileNum;
    @NotNull
    private final File file;
    private final boolean deleteFilesAfterClose;
    @NotNull
    private static final String COMMIT_MARKER_SUFFIX = ".c";
    @NotNull
    private static final String DATA_SUFFIX = ".d";
    public static final Companion Companion = new Companion(null);

    public final Path getPath() {
        return this.path;
    }

    @Nullable
    public final Long findLattestCommitMarker$mapdb() {
        Utils.INSTANCE.assertReadLock(this.getLock());
        if (this.path == null) {
            return null;
        }
        long highestCommitNumber = -1L;
        Path path = this.path.getFileName();
        if (path == null) {
            Intrinsics.throwNpe();
        }
        String name = ((Object)path).toString();
        Iterator iterator2 = Files.list(this.path.getParent()).iterator();
        while (iterator2.hasNext()) {
            String cname;
            Path child = (Path)iterator2.next();
            if (!Files.isRegularFile(child, new LinkOption[0])) continue;
            Path path2 = child.getFileName();
            if (path2 == null) {
                Intrinsics.throwNpe();
            }
            if (!StringsKt.startsWith$default(cname = ((Object)path2).toString(), name, false, 2, null) || !StringsKt.endsWith$default(cname, Companion.getCOMMIT_MARKER_SUFFIX$mapdb(), false, 2, null)) continue;
            List splited = StringsKt.split$default((CharSequence)cname.toString(), new char[]{'.'}, false, 0, 6, null);
            try {
                Long commitNumber = Long.valueOf((String)splited.get(splited.size() - 2));
                if (Intrinsics.compare(((Number)commitNumber).longValue(), highestCommitNumber) <= 0) continue;
                Long l = commitNumber;
                Intrinsics.checkExpressionValueIsNotNull(l, "commitNumber");
                highestCommitNumber = ((Number)l).longValue();
            }
            catch (NumberFormatException e) {}
        }
        return highestCommitNumber == -1L ? (Long)null : Long.valueOf(highestCommitNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final void loadFrom(long number) {
        void this_$iv;
        if (1 != 0) {
            Utils.INSTANCE.assertWriteLock(this.getLock());
        }
        Path path = this.path;
        Intrinsics.checkExpressionValueIsNotNull(path, "path");
        Path readFrom = Utils.INSTANCE.pathChangeSuffix(path, "." + number + Companion.getDATA_SUFFIX$mapdb());
        Object object = Utils.INSTANCE;
        if (true && this_$iv.getLOG().isLoggable(Level.FINE)) {
            Level level = Level.FINE;
            Logger logger = this_$iv.getLOG();
            String string = "Loading from " + readFrom + " with length " + readFrom.toFile().length();
            logger.log(level, string);
        }
        object = Files.newInputStream(readFrom, StandardOpenOption.READ);
        int n = 0;
        boolean $i$f$logDebug = true;
        Object var7_12 = null;
        if (var7_12 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
        }
        if ($i$f$logDebug & true) {
            n = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
        n = 0;
        try {
            BufferedInputStream it = (BufferedInputStream)object;
            this.loadFromInternal(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            n = 1;
            try {
                object.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (n == 0) {
                object.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void commit() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLock();
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            void this_$iv;
            long prev = this.lastFileNum;
            long next = prev + (long)1;
            Path path = this.path;
            Intrinsics.checkExpressionValueIsNotNull(path, "path");
            Path saveTo = Utils.INSTANCE.pathChangeSuffix(path, "." + next + Companion.getDATA_SUFFIX$mapdb());
            Object object = Files.newOutputStream(saveTo, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            int n = 0;
            boolean bl = true;
            Object var11_12 = null;
            if (var11_12 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
            }
            if (bl & true) {
                n = ConstantsKt.DEFAULT_BUFFER_SIZE;
            }
            object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
            n = 0;
            try {
                Object it = (BufferedOutputStream)object;
                this.saveTo((OutputStream)it);
                it = Unit.INSTANCE;
            }
            catch (Exception it) {
                n = 1;
                try {
                    object.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw (Throwable)it;
            }
            finally {
                if (n == 0) {
                    object.close();
                }
            }
            Path path2 = this.path;
            Intrinsics.checkExpressionValueIsNotNull(path2, "path");
            Files.createFile(Utils.INSTANCE.pathChangeSuffix(path2, "." + next + Companion.getCOMMIT_MARKER_SUFFIX$mapdb()), new FileAttribute[0]);
            this.lastFileNum = next;
            Path path3 = this.path;
            Intrinsics.checkExpressionValueIsNotNull(path3, "path");
            Files.deleteIfExists(Utils.INSTANCE.pathChangeSuffix(path3, "." + prev + Companion.getCOMMIT_MARKER_SUFFIX$mapdb()));
            Path path4 = this.path;
            Intrinsics.checkExpressionValueIsNotNull(path4, "path");
            Files.deleteIfExists(Utils.INSTANCE.pathChangeSuffix(path4, "." + prev + Companion.getDATA_SUFFIX$mapdb()));
            object = Utils.INSTANCE;
            if (true && this_$iv.getLOG().isLoggable(Level.FINE)) {
                Level level = Level.FINE;
                Logger logger = this_$iv.getLOG();
                String string = "Committed into " + saveTo + " with length " + saveTo.toFile().length();
                logger.log(level, string);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLock();
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            if (this.lastFileNum == -1L) {
                this.clearInternal$mapdb();
                return;
            }
            this.loadFrom(this.lastFileNum);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void close() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLock();
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            this.fileLock.release();
            this.fileChannel.close();
            super.close();
            if (this.deleteFilesAfterClose) {
                String f = this.file.getPath();
                long l = 0;
                long l2 = this.lastFileNum;
                if (l <= l2) {
                    while (true) {
                        void i;
                        void elements$iv;
                        String[] stringArray = new String[]{Companion.getCOMMIT_MARKER_SUFFIX$mapdb(), Companion.getDATA_SUFFIX$mapdb()};
                        String[] stringArray2 = (String[])((Object[])elements$iv);
                        for (int j = 0; j < stringArray2.length; ++j) {
                            String suffix = stringArray2[j];
                            new File(f + "." + (long)i + suffix).delete();
                        }
                        if (i == l2) break;
                        ++i;
                    }
                }
                this.file.delete();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    @Override
    @NotNull
    public Iterable<String> getAllFiles() {
        return CollectionsKt.arrayListOf(this.file.getPath());
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final boolean getDeleteFilesAfterClose() {
        return this.deleteFilesAfterClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public StoreTrivialTx(@NotNull File file, boolean isThreadSafe, boolean deleteFilesAfterClose) {
        void lock$iv;
        Object object;
        Intrinsics.checkParameterIsNotNull(file, "file");
        super(isThreadSafe);
        this.file = file;
        this.deleteFilesAfterClose = deleteFilesAfterClose;
        this.path = this.file.toPath();
        FileChannel fileChannel = FileChannel.open(this.path, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        Intrinsics.checkExpressionValueIsNotNull(fileChannel, "FileChannel.open(path, S\u2026tandardOpenOption.CREATE)");
        this.fileChannel = fileChannel;
        StoreTrivialTx storeTrivialTx = this;
        try {
            StoreTrivialTx storeTrivialTx2 = storeTrivialTx;
            FileLock fileLock = this.fileChannel.tryLock();
            Intrinsics.checkExpressionValueIsNotNull(fileLock, "fileChannel.tryLock()");
            object = fileLock;
        }
        catch (OverlappingFileLockException e) {
            StoreTrivialTx storeTrivialTx3 = storeTrivialTx;
            Path path = this.path;
            if (path == null) {
                Intrinsics.throwNpe();
            }
            throw (Throwable)new DBException.FileLocked(path, e);
        }
        storeTrivialTx2.fileLock = object;
        this.lastFileNum = -1L;
        object = Utils.INSTANCE;
        ReadWriteLock e = this.getLock();
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            ByteBuffer buf = ByteBuffer.allocate(8);
            if (this.fileChannel.size() > 0L) {
                Long lattest;
                void this_$iv;
                this.fileChannel.read(buf, 0L);
                long header = buf.getLong(0);
                this.fileHeaderCheck(header);
                Utils utils = Utils.INSTANCE;
                if (true && this_$iv.getLOG().isLoggable(Level.FINE)) {
                    Level level = Level.FINE;
                    Logger logger = this_$iv.getLOG();
                    String string = "Opened file " + this.path;
                    logger.log(level, string);
                }
                Long l = lattest = this.findLattestCommitMarker$mapdb();
                long l2 = this.lastFileNum = l != null ? ((Number)l).longValue() : -1L;
                if (lattest != null) {
                    this.loadFrom(((Number)lattest).longValue());
                }
            } else {
                long header = this.fileHeaderCompose();
                buf.putLong(0, header);
                this.fileChannel.write(buf, 0L);
                this.fileChannel.force(true);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    public /* synthetic */ StoreTrivialTx(File file, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(file, bl, bl2);
    }

    static {
        COMMIT_MARKER_SUFFIX = COMMIT_MARKER_SUFFIX;
        DATA_SUFFIX = DATA_SUFFIX;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/mapdb/StoreTrivialTx$Companion;", "", "()V", "COMMIT_MARKER_SUFFIX", "", "getCOMMIT_MARKER_SUFFIX$mapdb", "()Ljava/lang/String;", "DATA_SUFFIX", "getDATA_SUFFIX$mapdb", "mapdb"})
    public static final class Companion {
        @NotNull
        public final String getCOMMIT_MARKER_SUFFIX$mapdb() {
            return COMMIT_MARKER_SUFFIX;
        }

        @NotNull
        public final String getDATA_SUFFIX$mapdb() {
            return DATA_SUFFIX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

