/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Arrays;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.GroupSerializerObjectArray;
import org.mapdb.serializer.SerializerUtils;

public class SerializerIntArray
extends GroupSerializerObjectArray<int[]> {
    @Override
    public void serialize(DataOutput2 out, int[] value) throws IOException {
        out.packInt(value.length);
        for (int c : value) {
            out.writeInt(c);
        }
    }

    @Override
    public int[] deserialize(DataInput2 in, int available) throws IOException {
        int size2 = in.unpackInt();
        int[] ret2 = new int[size2];
        for (int i = 0; i < size2; ++i) {
            ret2[i] = in.readInt();
        }
        return ret2;
    }

    @Override
    public boolean isTrusted() {
        return true;
    }

    @Override
    public boolean equals(int[] a1, int[] a2) {
        return Arrays.equals(a1, a2);
    }

    @Override
    public int hashCode(int[] bytes, int seed) {
        for (int i : bytes) {
            seed = -1640531527 * seed + i;
        }
        return seed;
    }

    @Override
    public int compare(int[] o1, int[] o2) {
        if (o1 == o2) {
            return 0;
        }
        int len = Math.min(o1.length, o2.length);
        for (int i = 0; i < len; ++i) {
            if (o1[i] == o2[i]) continue;
            if (o1[i] > o2[i]) {
                return 1;
            }
            return -1;
        }
        return SerializerUtils.compareInt(o1.length, o2.length);
    }

    @Override
    public int[] nextValue(int[] value) {
        value = (int[])value.clone();
        int i = value.length - 1;
        while (true) {
            int b1;
            if ((b1 = value[i]) == Integer.MAX_VALUE) {
                if (i == 0) {
                    return null;
                }
            } else {
                value[i] = b1 + 1;
                return value;
            }
            value[i] = Integer.MIN_VALUE;
            --i;
        }
    }
}

