/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plots;

import java.awt.Color;
import org.math.plot.FrameView;
import org.math.plot.Plot2DPanel;
import org.math.plot.plots.LayerPlot;
import org.math.plot.plots.Plot;
import org.math.plot.render.AbstractDrawer;
import org.math.plot.utils.Array;

public class VectorLayerPlot
extends LayerPlot {
    public static int RADIUS = 5;
    double[][] V;

    public VectorLayerPlot(Plot p, double[][] v) {
        super("Vector of " + p.name, p);
        if (v != null) {
            Array.checkRowDimension(v, p.getData().length);
            Array.checkColumnDimension(v, p.getData()[0].length);
        }
        this.V = v;
    }

    @Override
    public void setData(double[][] v) {
        this.V = v;
    }

    @Override
    public double[][] getData() {
        return this.V;
    }

    @Override
    public void plot(AbstractDrawer draw, Color c) {
        if (!this.plot.visible) {
            return;
        }
        draw.setColor(c);
        draw.setLineType(1);
        for (int i = 0; i < this.plot.getData().length; ++i) {
            double[] d = Array.getRowCopy(this.plot.getData(), i);
            for (int j = 0; j < d.length; ++j) {
                int n = j;
                d[n] = d[n] + this.V[i][j];
            }
            draw.drawLine(this.plot.getData()[i], d);
        }
    }

    public static void main(String[] args) {
        Plot2DPanel p2 = new Plot2DPanel();
        double[][] XYZ = new double[100][2];
        double[][] dXYZ = new double[100][2];
        for (int j = 0; j < XYZ.length; ++j) {
            XYZ[j][0] = Math.random() * 10.0;
            XYZ[j][1] = Math.random() * 10.0;
            dXYZ[j][0] = 1.0 / Math.sqrt(1.0 + Math.log(XYZ[j][0]) * Math.log(XYZ[j][0]));
            dXYZ[j][1] = Math.log(XYZ[j][0]) / Math.sqrt(1.0 + Math.log(XYZ[j][0]) * Math.log(XYZ[j][0]));
        }
        p2.addScatterPlot("toto", XYZ);
        p2.addVectortoPlot(0, dXYZ);
        new FrameView(p2).setDefaultCloseOperation(3);
    }
}

