/*
 * Decompiled with CFR 0.152.
 */
package spiking.node.external_inputs;

import spiking.node.Node;

public class ExternalInput {
    public static final int POISSON = 0;
    public static final int CONSTANT = 1;
    public static final int NOISE = 2;
    private static final String TAG = "[External Input] ";
    private static final Boolean verbose = true;
    public static final Double EXTERNAL_AMPLITUDE_DEF_VALUE = 0.1;
    private Node n;
    private Integer externalInputs;
    private Double externalInputsTimeOffset = 0.1;
    private Integer fireDuration = 5;
    private double timeStep = 1.0;
    private int type;
    private int externalSpikes = 0;
    private Double externalAmplitude = EXTERNAL_AMPLITUDE_DEF_VALUE;
    private Integer externalOutdegree;

    public ExternalInput(Node n, int type, Double externalInputsTimeOffset, int fireDuration, Double externalAmplitude, int externalOutdegree, double timeStep) {
        this.n = n;
        this.type = type;
        this.externalInputsTimeOffset = externalInputsTimeOffset != null && externalInputsTimeOffset > 0.0 ? externalInputsTimeOffset : this.externalInputsTimeOffset;
        this.fireDuration = fireDuration;
        this.timeStep = timeStep;
        this.externalAmplitude = externalAmplitude;
        this.externalOutdegree = externalOutdegree;
        this.externalInputs = n.getExternalInputs();
    }

    public Double getAmplitudeValue(int extNeuron) {
        return this.externalAmplitude;
    }

    public double getTimeStep() {
        return this.timeStep;
    }

    protected Integer getExternalInputsNum() {
        return this.externalInputs;
    }

    public int getExternalSpikesInQueue() {
        return this.externalSpikes;
    }

    public Integer getFireDuration() {
        return this.fireDuration;
    }

    public Integer getExternalOutdegree() {
        return this.externalOutdegree;
    }

    private void println(String s) {
        if (verbose.booleanValue()) {
            System.out.println(TAG + s);
        }
    }
}

