/*
 * Decompiled with CFR 0.152.
 */
package spiking.node.plasticity;

import java.util.HashMap;
import spiking.node.Synapse;
import spiking.node.plasticity.Afferent;
import utils.constants.Constants;

public class AfferentManager {
    HashMap<Synapse, Afferent> affMap = new HashMap();
    private Double etap = 0.01;
    private Double etam = 0.05;
    private Double taup = 15.0;
    private Double taum = 30.0;
    private Double pwMax = 100.0;
    private Double to = 3.0;

    public void addAfferent(Afferent aff) {
        this.affMap.put(aff.getSynapse(), aff);
    }

    public Afferent findNoLtp(Synapse syn) {
        Afferent retval = this.affMap.get(syn);
        retval = retval.getLtpFlag() != false ? retval : null;
        return retval;
    }

    public Afferent popNoLtp(Synapse syn) {
        Afferent retval = this.affMap.get(syn);
        if (retval == null) {
            return retval;
        }
        Afferent afferent = retval = retval.getLtpFlag() != false ? retval : null;
        if (retval == null) {
            return retval;
        }
        retval = retval.getLastFireTime().equals(Constants.TIME_TO_FIRE_DEF_VAL) ? null : retval;
        this.affMap.remove(retval);
        return retval;
    }

    public Afferent popNoLtd(Synapse syn) {
        Afferent retval = this.affMap.get(syn);
        if (retval == null) {
            return retval;
        }
        retval = retval.getLtdFlag() != false ? retval : null;
        retval = retval.getLastFireTime().equals(Constants.TIME_TO_FIRE_DEF_VAL) ? null : retval;
        this.affMap.remove(retval);
        return retval;
    }

    public Double getEtap() {
        return this.etap;
    }

    public Double getEtam() {
        return this.etam;
    }

    public Double getTaup() {
        return this.taup;
    }

    public Double getTaum() {
        return this.taum;
    }

    public Double getPwMax() {
        return this.pwMax;
    }

    public Double getTo() {
        return this.to;
    }
}

