/*
 * Decompiled with CFR 0.152.
 */
package utils.plotter;

import java.awt.Dimension;
import java.awt.RenderingHints;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.FastScatterPlot;
import org.jfree.ui.ApplicationFrame;

public class FastScatterPlotter
extends ApplicationFrame {
    private float[][] data;

    public FastScatterPlotter(String title, float[] x, float[] y) {
        super(title);
        this.data = new float[2][x.length];
        for (int i = 0; i < x.length; ++i) {
            this.data[0][i] = x[i];
            this.data[1][i] = y[i];
        }
        NumberAxis domainAxis = new NumberAxis("X");
        domainAxis.setAutoRangeIncludesZero(false);
        NumberAxis rangeAxis = new NumberAxis("Y");
        rangeAxis.setAutoRangeIncludesZero(false);
        FastScatterPlot plot = new FastScatterPlot();
        plot.setData(this.data);
        plot.setDomainAxis(domainAxis);
        plot.setRangeAxis(rangeAxis);
        JFreeChart chart = new JFreeChart("Fast Scatter Plot", plot);
        chart.getRenderingHints().put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ChartPanel panel = new ChartPanel(chart, true);
        panel.setPreferredSize(new Dimension(500, 270));
        panel.setMinimumDrawHeight(10);
        panel.setMaximumDrawHeight(2000);
        panel.setMinimumDrawWidth(20);
        panel.setMaximumDrawWidth(2000);
        this.setContentPane(panel);
    }
}

