/*
 * Decompiled with CFR 0.152.
 */
package utils.tools;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class CompressedFire
implements Comparable<CompressedFire> {
    private Integer compressedNeuronId;
    private Double compressedFireTime;

    public CompressedFire(int regionId, long neuronId, double fireTime, Long maxN, Double reducingFactor) {
        this.compressedNeuronId = (int)(new Double((long)regionId * maxN + neuronId) * reducingFactor);
        this.compressedFireTime = fireTime;
    }

    public Integer getCompressedNeuronId() {
        return this.compressedNeuronId;
    }

    public Double getCompressedFireTime() {
        return this.compressedFireTime;
    }

    public String toString() {
        return "compressedFire [id:" + this.compressedNeuronId + ", t:" + this.compressedFireTime + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        CompressedFire cf = (CompressedFire)obj;
        return new EqualsBuilder().append(this.compressedNeuronId, cf.compressedNeuronId).append(this.compressedFireTime, cf.compressedFireTime).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(7L << (int)((long)this.compressedNeuronId.intValue() + 9L)).append(this.compressedFireTime + (double)this.compressedNeuronId.intValue() + this.compressedFireTime + 17.0).toHashCode();
    }

    @Override
    public int compareTo(CompressedFire o) {
        if (this == o) {
            return 0;
        }
        int retval = this.compressedNeuronId.compareTo(o.getCompressedNeuronId());
        if (retval != 0) {
            return retval;
        }
        retval = this.compressedFireTime.compareTo(o.getCompressedFireTime());
        return retval;
    }
}

